/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;

import jp.terasoluna.utlib.MockServletContext;
import jp.terasoluna.utlib.UTUtil;

import org.apache.commons.digester.Digester;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * ActionServletExNXeXgP[X.
 */
public class ActionServletExTest {

    ActionServletEx target;

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
        target = new ActionServletEx();
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
    }

    /**
     * initModuleConfig\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>prefix : "aaa"</li>
     * <li>paths : "aaa, bbb"</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testInitModuleConfigStringString001() throws Exception {
        final MockServletContext servletContext = new MockServletContext();

        // p[^
        String prefix = "aaa";
        String paths = "aaa, bbb";

        ActionServletEx actionServletEx = new ActionServletEx() {
            private static final long serialVersionUID = -3001804950464635560L;

            @Override
            public ServletContext getServletContext() {
                return servletContext;
            }

            @Override
            protected Digester initConfigDigester() throws ServletException {
                return new Digester();
            }

            @Override
            protected void parseModuleConfigFile(Digester digester, String path)
                                                                                throws UnavailableException {
            }
        };

        // eXg
        ModuleConfig mc = actionServletEx.initModuleConfig(prefix, paths);

        // 
        assertNotNull(mc);
    }

    /**
     * initModuleConfig\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>prefix : "aaa"</li>
     * <li>paths : "aaa, bbb"</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testInitModuleConfigStringString002() throws Exception {
        final MockServletContext servletContext = new MockServletContext();

        // p[^
        String prefix = "aaa";
        String paths = "aaa, bbb";

        ActionServletEx actionServletEx = new ActionServletEx() {
            private static final long serialVersionUID = -3001804950464635560L;

            @Override
            public ServletContext getServletContext() {
                return servletContext;
            }

            @Override
            protected Digester initConfigDigester() throws ServletException {
                return new Digester();
            }

            @Override
            protected void parseModuleConfigFile(Digester digester, String path)
                                                                                throws UnavailableException {
            }

            @Override
            protected String parseModuleConfigPath(String locationPattern)
                                                                          throws UnavailableException {
                return "aaa,bbb,";
            }
        };

        // eXg
        ModuleConfig mc = actionServletEx.initModuleConfig(prefix, paths);

        // 
        assertNotNull(mc);
    }

    /**
     * parseModuleConfigPath\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>locationPattern : "^^"iׂĔpj</li>
     * <li>paths : {"/aaa", "/aa/bb", "/aa/aaa"}</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : "/aa/aaa,/aaa"</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testParseModuleConfigPath001() throws Exception {
        List<String> pathList = new ArrayList<String>();
        pathList.add("/aaa");
        pathList.add("/aa/bb");
        pathList.add("/aa/aaa");

        final Set<String> paths = new HashSet<String>(pathList);

        final MockServletContext servletContext = new MockServletContext() {
            @SuppressWarnings("unchecked")
            @Override
            public Set getResourcePaths(String s) {
                return paths;
            }
        };

        // p[^
        String locationPattern = "/**/aaa";

        ActionServletEx actionServletEx = new ActionServletEx() {
            private static final long serialVersionUID = -3001804950464635560L;

            @Override
            public ServletContext getServletContext() {
                return servletContext;
            }

            @Override
            protected Digester initConfigDigester() throws ServletException {
                return new Digester();
            }

            @Override
            protected void parseModuleConfigFile(Digester digester, String path)
                                                                                throws UnavailableException {
            }
        };

        // eXg
        String result = actionServletEx.parseModuleConfigPath(locationPattern);

        // 
        assertNotNull(result);
        assertEquals("/aa/aaa,/aaa,", result);
    }

    /**
     * parseModuleConfigPath\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>locationPattern : "^^"iׂĔpj</li>
     * <li>paths : {"/aaa", "/aa/bb", "/aa/aaa"}</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : "/abc"</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testParseModuleConfigPath002() throws Exception {
        List<String> pathList = new ArrayList<String>();
        pathList.add("/aaa");
        pathList.add("/aa/bb");
        pathList.add("/aa/aaa");

        final Set<String> paths = new HashSet<String>(pathList);

        final MockServletContext servletContext = new MockServletContext() {
            @SuppressWarnings("unchecked")
            @Override
            public Set getResourcePaths(String s) {
                return paths;
            }
        };

        // p[^
        String locationPattern = "/abc";

        ActionServletEx actionServletEx = new ActionServletEx() {
            private static final long serialVersionUID = -3001804950464635560L;

            @Override
            public ServletContext getServletContext() {
                return servletContext;
            }

            @Override
            protected Digester initConfigDigester() throws ServletException {
                return new Digester();
            }

            @Override
            protected void parseModuleConfigFile(Digester digester, String path)
                                                                                throws UnavailableException {
            }
        };

        // eXg
        String result = actionServletEx.parseModuleConfigPath(locationPattern);

        // 
        assertNotNull(result);
        assertEquals("/abc,", result);
    }

    /**
     * handleConfigException\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>locationPattern : "^^"iׂĔpj</li>
     * <li>paths : {"/aaa", "/aa/bb", "/aa/aaa"}</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : "/abc"</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testHandleConfigException001() throws Exception {
        List<String> pathList = new ArrayList<String>();
        pathList.add("/aaa");
        pathList.add("/aa/bb");
        pathList.add("/aa/aaa");

        final Set<String> paths = new HashSet<String>(pathList);

        final MockServletContext servletContext = new MockServletContext() {
            @SuppressWarnings("unchecked")
            @Override
            public Set getResourcePaths(String s) {
                return paths;
            }
        };

        // p[^
        String path = null;
        Exception e = null;
        // String locationPattern = "/abc";
        //
        ActionServletEx actionServletEx = new ActionServletEx() {
            private static final long serialVersionUID = -3001804950464635560L;

            @Override
            public ServletContext getServletContext() {
                return servletContext;
            }

            @Override
            protected Digester initConfigDigester() throws ServletException {
                return new Digester();
            }

            @Override
            protected void parseModuleConfigFile(Digester digester, String path)
                                                                                throws UnavailableException {
            }
        };
        MessageResourcesFactory factory = null;
        String config = null;
        MessageResources internal = new MockMessageResources(factory, config);
        UTUtil.setPrivateField(actionServletEx, "internal", internal);

        // eXg
        try {
            actionServletEx.handleConfigException(path, e);
            fail("s");
        } catch (Exception ex) {
            // 
            assertNotNull(ex);
            assertEquals(UnavailableException.class, ex.getClass());
            assertEquals("???ja_JP.configParse???", ex.getMessage());
        }
    }

}
