/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockFilterChain;
import jp.terasoluna.utlib.MockFilterConfig;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.MockHttpSession;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.thin.SessionLockControlFilter} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ZbV̏̓sB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.thin.SessionLockControlFilter
 */
public class SessionLockControlFilterTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(SessionLockControlFilterTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public SessionLockControlFilterTest(String name) {
        super(name);
    }


    /**
     * testInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:interruptResponseCode:500<br>
     *         () config:threshold:1<br>
     *         
     * <br>
     * ҒlF(ԕω) interruptResponseCode:500<br>
     *         (ԕω) threshold:1<br>
     *         (ԕω) O:yfobOOz<br>
     *                    bZ[WF"threshold = 1. LimitedLock is enabled."<br>
     * <br>
     * p[^ݒ肳ĂꍇAtB[hinterruptResponseCode, thresholdɔf邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit01() throws Exception {
        // O
        // RtBO
        MockFilterConfig filterConfig = new MockFilterConfig();
        filterConfig.setInitParameter("interruptResponseCode", "500");
        filterConfig.setInitParameter("threshold", "1");
        // tB^̗p
        SessionLockControlFilter filter
            = new SessionLockControlFilter();
        
        // eXg{
        filter.init(filterConfig);

        // 
        assertEquals(500, UTUtil.getPrivateField(filter, "interruptResponseCode"));
        assertEquals(1, UTUtil.getPrivateField(filter, "threshold"));
        assertTrue(LogUTUtil.checkDebug("threshold = 1. LimitedLock is enabled."));
    }

    /**
     * testInit02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:interruptResponseCode:null(ݒȂ)<br>
     *         () config:threshold:-1<br>
     *         
     * <br>
     * ҒlF(ԕω) interruptResponseCode:500<br>
     *         (ԕω) threshold:-1<br>
     *         (ԕω) O:yfobOOz<br>
     *                    bZ[WF"threshold = -1. LimitedLock is disabled. Reason: threshold is negative number."<br>
     * <br>
     * LimitedLock𖳌ݒp^[ɔf邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit02() throws Exception {
        // O
        // RtBO
        MockFilterConfig filterConfig = new MockFilterConfig();
        filterConfig.setInitParameter("threshold", "-1");
        // tB^̗p
        SessionLockControlFilter filter
            = new SessionLockControlFilter();
        
        // eXg{
        filter.init(filterConfig);

        // 
        assertEquals(-1, UTUtil.getPrivateField(filter, "threshold"));
        assertTrue(LogUTUtil.checkDebug("threshold = -1. LimitedLock is disabled. Reason: threshold is negative number."));
    }

    /**
     * testInit03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:interruptResponseCode:null(ݒȂ)<br>
     *         () config:threshold:null(ݒȂ)<br>
     *         
     * <br>
     * ҒlF(ԕω) interruptResponseCode:503<br>
     *         (ԕω) threshold:2<br>
     *         
     * <br>
     * p[^ݒ肳ĂȂꍇAtB[hinterruptResponseCode, threshold̓ftHgl(503, 2)ł邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit03() throws Exception {
        // O
        // RtBO
        MockFilterConfig filterConfig = new MockFilterConfig();
        // tB^̗p
        SessionLockControlFilter filter
            = new SessionLockControlFilter();
        
        // eXg{
        filter.init(filterConfig);

        // 
        assertEquals(503, UTUtil.getPrivateField(filter, "interruptResponseCode"));
        assertEquals(2, UTUtil.getPrivateField(filter, "threshold"));
    }

    /**
     * testInit04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:interruptResponseCode:AAA<br>
     *         () config:threshold:null(ݒȂ)<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NumberFormatException<br>
     *         
     * <br>
     * p[^interruptResponseCodeɐȊOݒ肳ĂꍇANumberFormatException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit04() throws Exception {
        // O
        // RtBO
        MockFilterConfig filterConfig = new MockFilterConfig();
        filterConfig.setInitParameter("interruptResponseCode", "AAA");
        // tB^̗p
        SessionLockControlFilter filter
            = new SessionLockControlFilter();
        
        // eXg{
        try {
            filter.init(filterConfig);
            fail();
        } catch (NumberFormatException e) {
            // Ғʂ
        }
    }

    /**
     * testInit05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:interruptResponseCode:null(ݒȂ)<br>
     *         () config:threshold:AAA<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NumberFormatException<br>
     *         
     * <br>
     * p[^thresholdɐȊOݒ肳ĂꍇANumberFormatException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit05() throws Exception {
        // O
        // RtBO
        MockFilterConfig filterConfig = new MockFilterConfig();
        filterConfig.setInitParameter("threshold", "AAA");
        // tB^̗p
        SessionLockControlFilter filter
            = new SessionLockControlFilter();
        
        // eXg{
        try {
            filter.init(filterConfig);
            fail();
        } catch (NumberFormatException e) {
            // Ғʂ
        }
    }

    /**
     * testDoFilter01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() req:not null<br>
     *         () req:session:null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:yfobOOz<br>
     *                    bZ[WF"not lock."<br>
     *         
     * <br>
     * ZbVĂȂꍇAZbVɂ铯sȂƂmFB<br>
     * fobOOɂāAsȂ[gɓƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter01() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setSession(null);
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        SessionLockControlFilter filter = new SessionLockControlFilter();

        // eXg{
        filter.doFilter(req, res, chain);
        
        // 
        assertTrue(LogUTUtil.checkDebug("not lock."));
    }

    /**
     * testDoFilter02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FB
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () threshold:-1<br>
     *         
     * <br>
     * ҒlF(ԕω) ZbVIDinternsynchronizedAFilterChain#doFilters<br>
     *         (ԕω) O:yfobOOz<br>
     *                    bZ[WF"use synchronized lock."<br>
     *         
     * <br>
     * threshold0菬ꍇAsynchronizedubNgpēsƂmFB<br>
     * ZbVIDinternœĂ邱ƂmFB<br>
     * fobOOɂāAsynchronizedubNgpēs[gɓƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter02() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        session.setId("AAAA");
        req.setSession(session);
        MockHttpServletResponse res = new MockHttpServletResponse();
        SessionLockControlFilter filter = new SessionLockControlFilter();
        UTUtil.setPrivateField(filter, "threshold", -1);
        FilterChain chain = new FilterChain() {
            public void doFilter(ServletRequest req, ServletResponse res)
                                                                           throws IOException,
                                                                           ServletException {
                // 
                // synchronizedubNŃbNĂȂ΁AOB
                "AAAA".intern().notify();
            }
        };

        // eXg{
        filter.doFilter(req, res, chain);

        // 
        assertTrue(LogUTUtil.checkDebug("use synchronized lock."));
    }

    /**
     * testDoFilter03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FB
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () threshold:0<br>
     *         
     * <br>
     * ҒlF(ԕω) ZbVIDpɗpӂꂽLimitedLockœAFilterChain#doFilters<br>
     *         (ԕω) doFilterÍALimitedLock̃bN<br>
     *         (ԕω) O:yfobOOz<br>
     *                    bZ[WF"use LimitedLock."<br>
     *         
     * <br>
     * threshold0ȏ(0)̏ꍇALimitedLockgpēsƂmFB<br>
     * ZbVIDpLimitedLockœĂ邱ƂmFB<br>
     * fobOOɂāALimitedLockgpēs[gɓƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter03() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        session.setId("AAAA");
        req.setSession(session);
        MockHttpServletResponse res = new MockHttpServletResponse();
        SessionLockControlFilter filter = new SessionLockControlFilter();
        UTUtil.setPrivateField(filter, "threshold", 0);
        final Map<String, SessionLockReference> limitedLockMapField = (Map<String, SessionLockReference>) UTUtil.getPrivateField(filter, "limitedLockMap");
        FilterChain chain = new FilterChain() {
            public void doFilter(ServletRequest req, ServletResponse res)
                                                                           throws IOException,
                                                                           ServletException {
                // (FilterChain#doFilters)
                LimitedLock limitedLock = limitedLockMapField.get("AAAA").get();
                assertNotNull(limitedLock);
                try {
                    assertSame(Thread.currentThread(), UTUtil.invokePrivate(limitedLock, "getOwner"));
                } catch (Exception e) {
                    // UTUtil.invokePrivatesꍇB
                    // ɂ͓BȂB
                    fail();
                }
                
                // {̔OɁAGCɂLimitedLockێQƂ؂Ă܂Ȃ悤A
                // LimitedLock̎QƂێԂŁAxGCsĂB
                System.gc();
            }
        };

        // eXg{
        filter.doFilter(req, res, chain);
        
        // 
        LimitedLock limitedLock = limitedLockMapField.get("AAAA").get();
        assertNull(UTUtil.invokePrivate(limitedLock, "getOwner"));
        assertTrue(LogUTUtil.checkDebug("use LimitedLock."));
    }

    /**
     * testDoFilter04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () threshold:2(ftHg)<br>
     *         () ZbVID AAAA, BBBB ŎsA\GČŁAZbVID CCCCŎs<br>
     *         
     * <br>
     * ҒlF(ԕω) limitedLockMap:ZbVID AAAA, BBBB ̃̕Gg[폜<br>
     *         
     * <br>
     * QƂŕێĂLimitedLockGCɉ邱ƂɂAsvɂȂlimitedLockMap̃Gg[폜邱ƂmFB<br>
     * (QƂReferenceQueueɓɂ́AGCKvƂB
     * ł́u\GCvƂ́AQƂReferenceQueueɓ܂GC𔭐邱ƂӖB)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter04() throws Exception {
        // O
        SessionLockControlFilter_ReferenceQueueStub01 queue = new SessionLockControlFilter_ReferenceQueueStub01();
        MockHttpServletRequest reqA = new MockHttpServletRequest();
        MockHttpSession sessionA = new MockHttpSession();
        sessionA.setId("AAAA");
        reqA.setSession(sessionA);
        MockHttpServletRequest reqB = new MockHttpServletRequest();
        MockHttpSession sessionB = new MockHttpSession();
        sessionB.setId("BBBB");
        reqB.setSession(sessionB);
        MockHttpServletRequest reqC = new MockHttpServletRequest();
        MockHttpSession sessionC = new MockHttpSession();
        sessionC.setId("CCCC");
        reqC.setSession(sessionC);
        MockHttpServletResponse res = new MockHttpServletResponse();
        SessionLockControlFilter filter = new SessionLockControlFilter();
        UTUtil.setPrivateField(filter, "sessionLockRefQueue", queue);
        Map<String, SessionLockReference> limitedLockMapField = (Map<String, SessionLockReference>) UTUtil.getPrivateField(filter, "limitedLockMap");
        MockFilterChain chain = new MockFilterChain();
        filter.doFilter(reqA, res, chain);
        filter.doFilter(reqB, res, chain);
        // QƂReferenceQueueɓ̂ɏ\GC
        queue.prePollWithGC(2);
        
        // eXg{
        filter.doFilter(reqC, res, chain);
        
        // 
        assertFalse(limitedLockMapField.containsKey("AAAA"));
        assertFalse(limitedLockMapField.containsKey("BBBB"));
    }

    /**
     * testDoFilter05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () threshold:2(ftHg)<br>
     *         () ZbVID AAAAŎsGC(ZbVID AAAApLimitedLock1ڂGCɉ)A
     *                ̌ĂсAZbVID AAAAŎs(ZbVID AAAApLimitedLock2ڂ)ɁA
     *                ZbVID AAAApLimitedLockQƂԂŁA
     *                \GČ(LimitedLock1ڂ̎QƂ݂̂ReferenceQueueɓ)AZbVID BBBBŎs<br>
     *         
     * <br>
     * ҒlF(ԕω) limitedLockMap:ZbVID AAAA ̃̕Gg[͍폜Ȃ<br>
     *         (ԕω) O:yfobOOz<br>
     *                    bZ[WF"LimitedLock is deallocated. sessionId = AAAA, SessionLockReference = " + 1ڂLimitedLocki[SessionLockReferencetoStrinǧ<br>
     *         
     * <br>
     * QƂŕێĂLimitedLockGCɉ邱ƂɂAsvɂȂlimitedLockMap̃Gg[폜邪A
     * limitedLockMapɑ݂Gg[AReferenceQueue瓾ꂽ̂ƈقȂ(VȎQƂŏ㏑Ă)ꍇA폜ȂƂmFB<br>
     * (QƂReferenceQueueɓɂ́AGCKvƂB
     * ł́u\GCvƂ́AQƂReferenceQueueɓ܂GC𔭐邱ƂӖB)<br>
     * fobOOɂāAGg[̍폜WbNɓƂmFB(폜WbNɓAAWbN̔ɂč폜ȂƂmF)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter05() throws Exception {
        // O
        SessionLockControlFilter_ReferenceQueueStub01 queue = new SessionLockControlFilter_ReferenceQueueStub01();
        MockHttpServletRequest reqA = new MockHttpServletRequest();
        MockHttpSession sessionA = new MockHttpSession();
        sessionA.setId("AAAA");
        reqA.setSession(sessionA);
        MockHttpServletRequest reqB = new MockHttpServletRequest();
        MockHttpSession sessionB = new MockHttpSession();
        sessionB.setId("BBBB");
        reqB.setSession(sessionB);
        MockHttpServletResponse res = new MockHttpServletResponse();
        final List<LimitedLock> limitedLockList = new ArrayList<LimitedLock>();
        SessionLockControlFilter filter = new SessionLockControlFilter() {
            int count = 0;
            @Override
            protected void lockLimitedLock(HttpServletRequest request,
                    LimitedLock lock) throws InterruptedException {
                super.lockLimitedLock(request, lock);
                if (count == 1) {
                    // 2ڎŝ݁ALimitedLock̎QƂێ
                    limitedLockList.add(lock);
                }
                count++;
            }
        };
        UTUtil.setPrivateField(filter, "sessionLockRefQueue", queue);
        Map<String, SessionLockReference> limitedLockMapField = (Map<String, SessionLockReference>) UTUtil.getPrivateField(filter, "limitedLockMap");
        MockFilterChain chain = new MockFilterChain();
        filter.doFilter(reqA, res, chain);
        String sessionLockReferenceStringForDeallocatedLog = limitedLockMapField.get("AAAA").toString();
        System.gc();
        filter.doFilter(reqA, res, chain);
        // QƂReferenceQueueɓ̂ɏ\GC
        queue.prePollWithGC(1);
        
        // eXg{
        filter.doFilter(reqB, res, chain);
        
        // 
        assertTrue(limitedLockMapField.containsKey("AAAA"));
        assertTrue(LogUTUtil.checkDebug("LimitedLock is deallocated. sessionId = AAAA, SessionLockReference = " + sessionLockReferenceStringForDeallocatedLog));
    }

    /**
     * testDoFilter06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () threshold:2(ftHg)<br>
     *         () ZbVID AAAApLimitedLockQƂĂ<br>
     *         () GC݂A5s<br>
     *         
     * <br>
     * ҒlF(ԕω) LimitedLockCX^XbN<br>
     *         
     * <br>
     * ꂩ̃XbhLimitedLockQƂĂԂ́ALimitedLock͉ꂸɁAZbVIDŋL邱ƂmFB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter06() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        session.setId("AAAA");
        req.setSession(session);
        MockHttpServletResponse res = new MockHttpServletResponse();
        final List<LimitedLock> limitedLockList = new ArrayList<LimitedLock>();
        SessionLockControlFilter filter = new SessionLockControlFilter() {
            @Override
            protected void lockLimitedLock(HttpServletRequest request,
                    LimitedLock lock) throws InterruptedException {
                super.lockLimitedLock(request, lock);
                limitedLockList.add(lock);
            }
        };
        MockFilterChain chain = new MockFilterChain();
        
        // eXg{
        filter.doFilter(req, res, chain);
        System.gc();
        filter.doFilter(req, res, chain);
        System.gc();
        filter.doFilter(req, res, chain);
        System.gc();
        filter.doFilter(req, res, chain);
        System.gc();
        filter.doFilter(req, res, chain);
        
        // 
        assertNotNull(limitedLockList.get(0));
        assertSame(limitedLockList.get(0), limitedLockList.get(1));
        assertSame(limitedLockList.get(0), limitedLockList.get(2));
        assertSame(limitedLockList.get(0), limitedLockList.get(3));
        assertSame(limitedLockList.get(0), limitedLockList.get(4));
    }

    /**
     * testDoFilter07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () ZbVID:AAAA
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () threshold:2(ftHg)<br>
     *         () LimitedLockQƂĂȂ<br>
     *         () GC݂A3s<br>
     *         
     * <br>
     * ҒlF(ԕω) s邽т(v3)ALimitedLockCX^X<br>
     *         
     * <br>
     * ̃XbhLimitedLockQƂĂȂԂGCꍇALimitedLockAVLimitedLockgp邱ƂmFB<br>
     * (ۂɃbNLimitedLockCX^X؂悤ƂƁAuLimitedLockQƂĂȂv̏Ȃ߁A
     *  LimitedLockCX^X̐񐔂ɂĊmFB)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter07() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        session.setId("AAAA");
        req.setSession(session);
        MockHttpServletResponse res = new MockHttpServletResponse();
        final AtomicInteger createCount = new AtomicInteger(0);
        SessionLockControlFilter filter = new SessionLockControlFilter() {
            @Override
            protected LimitedLock createLimitedLock() {
                createCount.addAndGet(1);
                return super.createLimitedLock();
            }
            
        };
        MockFilterChain chain = new MockFilterChain();
        
        // eXg{
        filter.doFilter(req, res, chain);
        System.gc();
        filter.doFilter(req, res, chain);
        System.gc();
        filter.doFilter(req, res, chain);
        
        // 
        assertEquals(3, createCount.get());
    }

    /**
     * testDoFilter08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () interruptResponseCode:500<br>
     *         () threshold:2(ftHg)<br>
     *         () LimitedLock̃bN擾\bhInterruptedExceptionX[<br>
     *         
     * <br>
     * ҒlF(ԕω) FilterChain#doFilter͎sȂ<br>
     *         (ԕω) res:X|XR[h:500<br>
     *         (ԕω) LimitedLock̃bN\bhs<br>
     *         
     * <br>
     * LimitedLock̃bN擾fꂽƂAFilterChain#doFilter͎sꂸAinterruptResponseCodeɐݒ肳ꂽX|XR[hgp邱ƂmFB<br>
     * LimitedLock̃bN擾fĂAbN\bh͎s邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter08() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        final AtomicBoolean unlockCalled = new AtomicBoolean(false);
        SessionLockControlFilter filter = new SessionLockControlFilter() {
            @Override
            protected void lockLimitedLock(HttpServletRequest request,
                    LimitedLock lock) throws InterruptedException {
                throw new InterruptedException();
            }

            @Override
            protected void unlockLimitedLock(HttpServletRequest request,
                    LimitedLock lock) {
                unlockCalled.getAndSet(true);
                super.unlockLimitedLock(request, lock);
            }
        };
        UTUtil.setPrivateField(filter, "interruptResponseCode", 500);
        MockFilterChain chain = new MockFilterChain();

        // eXg{
        filter.doFilter(req, res, chain);
        
        // 
        assertNull(chain.getRequest());
        assertEquals(500, res.getStatus());
        assertTrue(unlockCalled.get());
    }

    /**
     * testDoFilter09()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () threshold:2(ftHg)<br>
     *         () FilterChain#doFilterRuntimeExceptionX[<br>
     *         
     * <br>
     * ҒlF(ԕω) LimitedLock̃bN\bhs<br>
     *         (ԕω) O:RuntimeExceptionF<br>
     *         
     * <br>
     * FilterChain#doFilterOX[ꂽꍇAÔ܂܃X[邱ƂmFB<br>
     * bN\bh͎s邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter09() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        final RuntimeException ex = new RuntimeException();
        final AtomicBoolean unlockCalled = new AtomicBoolean(false);
        SessionLockControlFilter filter = new SessionLockControlFilter() {
            @Override
            protected void unlockLimitedLock(HttpServletRequest request,
                    LimitedLock lock) {
                unlockCalled.getAndSet(true);
                super.unlockLimitedLock(request, lock);
            }
        };
        FilterChain chain = new FilterChain() {
            public void doFilter(ServletRequest arg0, ServletResponse arg1)
                                                                           throws IOException,
                                                                           ServletException {
                throw ex;
            }
        };

        // eXg{
        RuntimeException actualThrown = null;
        try {
            filter.doFilter(req, res, chain);
            fail();
        } catch (RuntimeException e) {
            actualThrown = e;
        }
        
        // 
        assertSame(ex, actualThrown);
        assertTrue(unlockCalled.get());
    }

    /**
     * testCreateLimitedLock01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() threshold:1<br>
     *
     * <br>
     * ҒlF(߂l) LimitedLockCX^X[threshold=1]<br>
     *
     * <br>
     * tB[hthreshold̒lgpALimitedLockCX^X邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLimitedLock01() throws Exception {
        // O
        SessionLockControlFilter filter = new SessionLockControlFilter();
        UTUtil.setPrivateField(filter, "threshold", 1);
        
        // eXg{
        LimitedLock limitedLock = filter.createLimitedLock();
        
        // 
        assertNotNull(limitedLock);
        assertEquals(1, UTUtil.getPrivateField(limitedLock, "threshold"));
    }

    /**
     * testLockLimitedLock01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:not null<br>
     *         () lock:LimitedLock(bN)<br>
     *
     * <br>
     * ҒlF(ԕω) ݂̃XbhLimitedLockCX^X̃bN擾<br>
     *
     * <br>
     * ݂̃XbhLimitedLockCX^X̃bN擾邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLockLimitedLock01() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        SessionLockControlFilter filter = new SessionLockControlFilter();
        LimitedLock lock = new LimitedLock(1);
        
        // eXg{
        filter.lockLimitedLock(req, lock);
        
        // 
        assertEquals(Thread.currentThread(), UTUtil.invokePrivate(lock, "getOwner"));
    }

    /**
     * testUnlockLimitedLock01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:not null<br>
     *         () lock:LimitedLock(݂̃Xbh1񃍃bNꂽ)<br>
     *
     * <br>
     * ҒlF(ԕω) LimitedLockCX^X̃bN<br>
     *
     * <br>
     * LimitedLockCX^X̃bN邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testUnlockLimitedLock01() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        SessionLockControlFilter filter = new SessionLockControlFilter();
        LimitedLock lock = new LimitedLock(1);
        lock.lockInterruptibly();
        
        // eXg{
        filter.unlockLimitedLock(req, lock);
        
        // 
        assertNull(UTUtil.invokePrivate(lock, "getOwner"));
    }

}
