/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.utlib.MockFilterConfig;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;

/**
 * {@link jp.terasoluna.fw.web.thin.ExtentionFilter} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * gq`FbNsB<br>
 * w肳ꂽ֎~gqpXւ̃ANZXvɑ΂ẮASC_NOT_FOUND(404)G[ԂBɂAt@Cւ̒ڃANZX֎~B֎~gqւ̃ANZXsꍇł̃`FbNΏۂ͂ʂȃpX΁AvpeBt@CrestrictionEscape.ƂvtBNXL[ƂĒ`邱ƂŃ`FbNΏۂ̃pX1畡`łB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.thin.ExtensionFilter
 */
public class ExtensionFilterTest extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ExtensionFilterTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ExtensionFilterTest(String name) {
        super(name);
    }

    /**
     * testInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () vpeBt@C̊֘AvpeB:access.control.prohibited.extension.1=.test1<br>
     *                restrictedEscape.1=./test/test1<br>
     *         
     * <br>
     * ҒlF(ԕω) prohibitedExtensionList:".test1"<br>
     *         (ԕω) restrictionEscapePaths:"./test/test1"<br>
     *         
     * <br>
     * PjvpeBaccess.control.prohibited.extension.n1ɐݒ肳ĂꍇAprohibitedExtensionListɐݒlǉ邱ƂmFB<br>
     * QjvpeBrestrictionEscape.n1ɐݒ肳ĂꍇArestrictionEscapePathsɐݒlǉ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit01() throws Exception {
        // O
        addProperty("access.control.prohibited.extension.1", ".test1");
        addProperty("restrictionEscape.1", "./test/test1");

        // eXg{
        ExtensionFilter filter = new ExtensionFilter();
        MockFilterConfig config = new MockFilterConfig();
        filter.init(config);
        
        // 
        List prohibitedExtensionList = (List) UTUtil.getPrivateField(
                filter, 
                "prohibitedExtensionList");
        
        List restrictionEscapePaths = (List) UTUtil.getPrivateField(
                filter, 
                "restrictionEscapePaths");
        
        // prohibitedExtensionListmF
        assertEquals(1, prohibitedExtensionList.size());
        assertEquals(".test1", prohibitedExtensionList.get(0));
        // restrictionEscapePathsmF
        assertEquals(1, restrictionEscapePaths.size());
        assertEquals("./test/test1", restrictionEscapePaths.get(0));        
        
        
    }

    /**
     * testInit02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () vpeBt@C̊֘AvpeB:access.control.prohibited.extension.1=.test1<br>
     *                access.control.prohibited.extension.2=.test2<br>
     *                access.control.prohibited.extension.3=.test3<br>
     *                restrictedEscape.1=./test/test1<br>
     *                restrictedEscape.2=./test/test2<br>
     *                restrictedEscape.3=./test/test3<br>
     *         
     * <br>
     * ҒlF(ԕω) prohibitedExtensionList:".test1"<br>
     *                    ".test2"<br>
     *                    ".test3<br>
     *         (ԕω) restrictionEscapePaths:"./test/test1"<br>
     *                    "./test/test2"<br>
     *                    "./test/test3"<br>
     *         
     * <br>
     * PjvpeBaccess.control.prohibited.extension.nɐݒ肳ĂꍇAprohibitedExtensionListɐݒlǉ邱ƂmFB<br>
     * QjvpeBaccess.control.prohibited.extension.n"."n܂Ȃݒ肳ĂꍇAprohibitedExtensionList"." + ݒlǉ邱ƂmFB<br>
     * RjvpeBrestrictionEscape.nɐݒ肳ĂꍇArestrictionEscapePathsɐݒlǉ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit02() throws Exception {
        // O
        addProperty("access.control.prohibited.extension.1", ".test1");
        addProperty("access.control.prohibited.extension.2", "test2");
        addProperty("access.control.prohibited.extension.3", ".test3");
        addProperty("restrictionEscape.1", "./test/test1");
        addProperty("restrictionEscape.2", "./test/test2");
        addProperty("restrictionEscape.3", "./test/test3");

        // eXg{
        ExtensionFilter filter = new ExtensionFilter();
        MockFilterConfig config = new MockFilterConfig();
        filter.init(config);
        
        // 
        List prohibitedExtensionList = (List) UTUtil.getPrivateField(filter, "prohibitedExtensionList");
        List restrictionEscapePaths = (List) UTUtil.getPrivateField(filter, "restrictionEscapePaths");
        // prohibitedExtensionListmF
        assertEquals(3, prohibitedExtensionList.size());
        for (int i = 0; i < 3; i++) {
            assertEquals(".test" + (i + 1), prohibitedExtensionList.get(i));
        }
        
        // restrictionEscapePathsmF
        assertEquals(3, restrictionEscapePaths.size());
        for (int i = 0; i < 3; i++) {
            assertEquals("./test/test" + (i + 1), restrictionEscapePaths.get(i));
        }
    }

    /**
     * testInit03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () vpeBt@C̊֘AvpeB:access.control.prohibited.extension.1=<br>
     *                restrictedEscape.1=<br>
     *         
     * <br>
     * ҒlF(ԕω) prohibitedExtensionList:"."<br>
     *         (ԕω) restrictionEscapePaths:""<br>
     *         
     * <br>
     * PjvpeBaccess.control.prohibited.extension.nɋ󕶎񂪐ݒ肳ĂꍇAprohibitedExtensionList"."ǉ邱ƂmFB<br>
     * QjvpeBrestrictionEscape.nɋ󕶎񂪐ݒ肳ĂꍇArestrictionEscapePathsɋ󕶎񂪒ǉ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit03() throws Exception {
        // O
        addProperty("access.control.prohibited.extension.1", "");
        addProperty("restrictionEscape.1", "");

        // eXg{
        ExtensionFilter filter = new ExtensionFilter();
        MockFilterConfig config = new MockFilterConfig();
        filter.init(config);
        
        // 
        List prohibitedExtensionList = (List) UTUtil.getPrivateField(filter, "prohibitedExtensionList");
        List restrictionEscapePaths = (List) UTUtil.getPrivateField(filter, "restrictionEscapePaths");
        // prohibitedExtensionListmF
        assertEquals(1, prohibitedExtensionList.size());
        assertEquals(".", prohibitedExtensionList.get(0));
        // restrictionEscapePathsmF
        assertEquals(1, restrictionEscapePaths.size());
        assertEquals("", restrictionEscapePaths.get(0));    
    }

    /**
     * testInit04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () vpeBt@C̊֘AvpeB:iaccess.control.prohibited.extension.n݂Ȃj<br>
     *                irestrictedEscape.n݂Ȃj<br>
     *         
     * <br>
     * ҒlF(ԕω) prohibitedExtensionList:List<br>
     *         (ԕω) restrictionEscapePaths:List<br>
     *         
     * <br>
     * PjvpeBaccess.control.prohibited.extension.n݂ȂꍇAprohibitedExtensionListɉݒ肳ĂȂƂmFB<br>
     * QjvpeBrestrictedEscape.n݂ȂꍇArestrictedEscapePathsɉݒ肳ĂȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit04() throws Exception {
        // O
        // iaccess.control.prohibited.extension.n݂Ȃj
        // irestrictionEscapePaths.n݂Ȃj

        // eXg{
        ExtensionFilter filter = new ExtensionFilter();
        MockFilterConfig config = new MockFilterConfig();
        filter.init(config);
        
        // 
        List prohibitedExtensionList = (List) UTUtil.getPrivateField(filter, "prohibitedExtensionList");
        List restrictionEscapePaths = (List) UTUtil.getPrivateField(filter, "restrictionEscapePaths");
        // prohibitedExtensionListmF
        assertEquals(0, prohibitedExtensionList.size());
        // restrictionEscapePathsmF
        assertEquals(0, restrictionEscapePaths.size());
    }

    /**
     * testInit05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () vpeBt@C̊֘AvpeB:access.control.prohibited.extension.1=.test1<br>
     *                access.control.prohibited.extension.3=.test3<br>
     *                restrictedEscape.1=./test/test1<br>
     *                restrictedEscape.3=./test/test3<br>
     *         
     * <br>
     * ҒlF(ԕω) prohibitedExtensionList:".test1"<br>
     *         (ԕω) restrictionEscapePaths:"./test/test1"<br>
     *         
     * <br>
     * PjvpeBaccess.control.prohibited.extension.nnɔꍇAprohibitedExtensionListɔCfbNX܂ł̒lǉ邱ƂmFB<br>
     * QjvpeBrestrictedEscape.nnɔꍇArestrictedEscapePathsɔCfbNX܂ł̒lǉ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit05() throws Exception {
        // O
        addProperty("access.control.prohibited.extension.1", ".test1");
        addProperty("access.control.prohibited.extension.3", ".test3");
        addProperty("restrictionEscape.1", "./test/test1");
        addProperty("restrictionEscape.3", "./test/test3");

        // eXg{
        ExtensionFilter filter = new ExtensionFilter();
        MockFilterConfig config = new MockFilterConfig();
        filter.init(config);
        
        // 
        List prohibitedExtensionList = (List) UTUtil.getPrivateField(filter, "prohibitedExtensionList");
        List restrictionEscapePaths = (List) UTUtil.getPrivateField(filter, "restrictionEscapePaths");
        // prohibitedExtensionListmF
        assertEquals(1, prohibitedExtensionList.size());
        assertEquals(".test1", prohibitedExtensionList.get(0));
        // restrictionEscapePathsmF
        assertEquals(1, restrictionEscapePaths.size());
        assertEquals("./test/test1", restrictionEscapePaths.get(0));    
    }

    /**
     * testInit06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () vpeBt@C̊֘AvpeB:access.control.prohibited.extension.0=.test0<br>
     *                access.control.prohibited.extension.1=.test1<br>
     *                access.control.prohibited.extension.2=.test2<br>
     *                restrictedEscape.0=./test/test0<br>
     *                restrictedEscape.1=./test/test1<br>
     *                restrictedEscape.2=./test/test2<br>
     *         
     * <br>
     * ҒlF(ԕω) prohibitedExtensionList:".test1"<br>
     *                    ".test2"<br>
     *         (ԕω) restrictionEscapePaths:"./test/test1"<br>
     *                    "./test/test2"<br>
     *         
     * <br>
     * PjvpeBaccess.control.prohibited.extension.nn0n܂ꍇAprohibitedExtensionListn0̒l͒ǉȂƂmFB<br>
     * QjvpeBrestrictedEscapenn0n܂ꍇArestrictedEscapePathsn0̒l͒ǉȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit06() throws Exception {
        // O
        addProperty("access.control.prohibited.extension.0", ".test0");
        addProperty("access.control.prohibited.extension.1", ".test1");
        addProperty("access.control.prohibited.extension.2", ".test2");
        addProperty("restrictionEscape.0", "./test/test0");
        addProperty("restrictionEscape.1", "./test/test1");
        addProperty("restrictionEscape.2", "./test/test2");

        // eXg{
        ExtensionFilter filter = new ExtensionFilter();
        MockFilterConfig config = new MockFilterConfig();
        filter.init(config);
        
        // 
        List prohibitedExtensionList = (List) UTUtil.getPrivateField(filter, "prohibitedExtensionList");
        List restrictionEscapePaths = (List) UTUtil.getPrivateField(filter, "restrictionEscapePaths");
        // prohibitedExtensionListmF
        assertEquals(2, prohibitedExtensionList.size());
        for (int i = 0; i < 2; i++) {
            assertEquals(".test" + (i + 1), prohibitedExtensionList.get(i));
        }
        
        // restrictionEscapePathsmF
        assertEquals(2, restrictionEscapePaths.size());
        for (int i = 0; i < 2; i++) {
            assertEquals("./test/test" + (i + 1), restrictionEscapePaths.get(i));
        }
    }

    /**
     * testInit07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () vpeBt@C̊֘AvpeB:access.control.prohibited.extension.1=.test1<br>
     *                access.control.prohibited.extension.a=.testA<br>
     *                restrictedEscape.1=./test/test1<br>
     *                restrictedEscape.A=./test/testA<br>
     *         
     * <br>
     * ҒlF(ԕω) prohibitedExtensionList:".test1"<br>
     *         (ԕω) restrictionEscapePaths:"./test/test1"<br>
     *         
     * <br>
     * PjvpeBaccess.control.prohibited.extension.nnłȂꍇAprohibitedExtensionListnłȂl͒ǉȂƂmFB<br>
     * QjvpeBrestrictedEscape.nnłȂꍇArestrictedEscapePathsnłȂl͒ǉȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit07() throws Exception {
        // O
        addProperty("access.control.prohibited.extension.1", ".test1");
        addProperty("access.control.prohibited.extension.a", ".testA");
        addProperty("restrictionEscape.1", "./test/test1");
        addProperty("restrictionEscape.A", "./test/testA");

        // eXg{
        ExtensionFilter filter = new ExtensionFilter();
        MockFilterConfig config = new MockFilterConfig();
        filter.init(config);
        
        // 
        List prohibitedExtensionList = (List) UTUtil.getPrivateField(filter, "prohibitedExtensionList");
        List restrictionEscapePaths = (List) UTUtil.getPrivateField(filter, "restrictionEscapePaths");
        // prohibitedExtensionListmF
        assertEquals(1, prohibitedExtensionList.size());
        assertEquals(".test1", prohibitedExtensionList.get(0));
        // restrictionEscapePathsmF
        assertEquals(1, restrictionEscapePaths.size());
        assertEquals("./test/test1", restrictionEscapePaths.get(0));    
    }

    /**
     * testDoFilter01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () EXTENSION_THRU_KEY:"aaaaa"<br>
     *         
     * <br>
     * ҒlF(ԕω) EXTENSION_THRU_KEY:Oŗ^lƓ<br>
     *         (ԕω) sendError:Ă΂Ȃ<br>
     *         (ԕω) doFilter:s<br>
     *         
     * <br>
     * request̑lłEXTENSION_THRU_KEYnullłȂꍇAgq`FbNs킸ɏI邱ƁB<br>
     * FilterChain#doFilter()\bhs邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter01() throws Exception {
        // O
        ExtensionFilter filter = new ExtensionFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        ExtensionFilter_ServletResponseStub01 response = new ExtensionFilter_ServletResponseStub01();
        // EXTENSION_THRU_KEY:"aaaaa"
        request.setAttribute("EXTENSION_THRU_KEY", "aaaaa");
        
        ExtensionFilter_FilterChainStub01 filterChain =
            new ExtensionFilter_FilterChainStub01();
        
        // eXg{
        filter.doFilter(request, response, filterChain);
        // 
        assertEquals("aaaaa", request.getAttribute("EXTENSION_THRU_KEY"));
        assertEquals(-1, UTUtil.getPrivateField(response, "errorCode"));
        assertTrue(filterChain.isCalled);
    }

    /**
     * testDoFilter02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () EXTENSION_THRU_KEY:null<br>
     *         () requestURI:null<br>
     *         () contextPath:null<br>
     *         
     * <br>
     * ҒlF(ԕω) EXTENSION_THRU_KEY:"true"<br>
     *         (ԕω) sendError:Ă΂Ȃ<br>
     *         (ԕω) doFilter:s<br>
     *         
     * <br>
     * requestURInull̏ꍇANullPointerException邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter02() throws Exception {
        // O
        ExtensionFilter filter = new ExtensionFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath(null);
        request.setRequestURI(null);
        
        ExtensionFilter_ServletResponseStub01 response =
            new ExtensionFilter_ServletResponseStub01();
        ExtensionFilter_FilterChainStub01 filterChain =
            new ExtensionFilter_FilterChainStub01();
        
        try {
            // eXg{
            filter.doFilter(request, response, filterChain);
            fail();
        } catch (NullPointerException e) {
            // 
            assertEquals(NullPointerException.class.getName(),
                         e.getClass().getName());
        }
    }

    /**
     * testDoFilter03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () EXTENSION_THRU_KEY:null<br>
     *         () requestURI:"/test/test"<br>
     *         () contextPath:"/test"<br>
     *         () restrictionEscapePaths:"/test"<br>
     *         () prohibitedExtensionList:""<br>
     *         
     * <br>
     * ҒlF(ԕω) EXTENSION_THRU_KEY:"true"<br>
     *         (ԕω) sendError:Ă΂Ȃ<br>
     *         (ԕω) doFilter:s<br>
     *         
     * <br>
     * gq`FbNΏۊOXgrequestURI̒l܂܂ꍇAgq֎~XgrequestURI擾gqi󕶎j܂܂ĂĂAgq`FbNs킸Arequest̑lEXTENSION_THRU_KEYtrueݒ肵ďI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter03() throws Exception {
        // O
        ExtensionFilter filter = new ExtensionFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        ExtensionFilter_ServletResponseStub01 response =
            new ExtensionFilter_ServletResponseStub01();
        
        ExtensionFilter_FilterChainStub01 filterChain =
            new ExtensionFilter_FilterChainStub01();
       
        // prohibitedExtensionList:"" 
        ArrayList<String> prohibitedExtensionList = new ArrayList<String>();
        prohibitedExtensionList.add("");
        // restrictionEscapePaths:"/test/test"
        ArrayList<String> restrictionEscapePaths = new ArrayList<String>();
        restrictionEscapePaths.add("/test");
        
        // prohibitedExtensionListݒ
        UTUtil.setPrivateField(filter,
                "prohibitedExtensionList", 
                prohibitedExtensionList);
        // restrictionEscapePathsݒ
        UTUtil.setPrivateField(filter, 
                "restrictionEscapePaths",
                restrictionEscapePaths); 
        // requestURIݒ
        request.setRequestURI("/test/test");
        request.setContextPath("/test");
        request.setServletPath("/test");

        
        // eXg{
        filter.doFilter(request, response, filterChain);
        // 
        assertEquals("true", request.getAttribute("EXTENSION_THRU_KEY"));
        assertEquals(-1, UTUtil.getPrivateField(response, "errorCode"));
        assertTrue(filterChain.isCalled);
    }

    /**
     * testDoFilter04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () EXTENSION_THRU_KEY:null<br>
     *         () requestURI:"/test/test"<br>
     *         () contextPath:"/test"<br>
     *         () restrictionEscapePaths:List<br>
     *         () prohibitedExtensionList:List<br>
     *         
     * <br>
     * ҒlF(ԕω) EXTENSION_THRU_KEY:"true"<br>
     *         (ԕω) sendError:Ă΂Ȃ<br>
     *         (ԕω) doFilter:s<br>
     *         
     * <br>
     * gq`FbNΏۊOXgrequestURI̒l܂܂ꂸAgq֎~XgrequestURI擾gqi󕶎j܂܂ȂꍇArequest̑lEXTENSION_THRU_KEYtrueݒ肵ďI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter04() throws Exception {
        // O
        ExtensionFilter filter = new ExtensionFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        ExtensionFilter_ServletResponseStub01 response =
            new ExtensionFilter_ServletResponseStub01();
        
        ExtensionFilter_FilterChainStub01 filterChain =
            new ExtensionFilter_FilterChainStub01();
       
        // prohibitedExtensionList:List 
        ArrayList prohibitedExtensionList = new ArrayList();
        // restrictionEscapePaths:List
        ArrayList restrictionEscapePaths = new ArrayList();
        
        // prohibitedExtensionListݒ
        UTUtil.setPrivateField(filter,
                                "prohibitedExtensionList", 
                                prohibitedExtensionList);
        
        // restrictionEscapePathsݒ
        UTUtil.setPrivateField(filter, 
                                "restrictionEscapePaths",
                                restrictionEscapePaths); 
        // requestURIݒ
        request.setRequestURI("/test/test");
        request.setContextPath("/test");
        
        // eXg{
        filter.doFilter(request, response, filterChain);
        // 
        assertEquals("true", request.getAttribute("EXTENSION_THRU_KEY"));
        assertEquals(-1, UTUtil.getPrivateField(response, "errorCode"));
        assertTrue(filterChain.isCalled);
    }

    /**
     * testDoFilter05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () EXTENSION_THRU_KEY:null<br>
     *         () requestURI:"/test/test"<br>
     *         () contextPath:"/test"<br>
     *         () restrictionEscapePaths:List<br>
     *         () prohibitedExtensionList:""<br>
     *         
     * <br>
     * ҒlF(ԕω) EXTENSION_THRU_KEY:"true"<br>
     *         (ԕω) sendError:HttpServletResponse.SC_NOT_FOUND^<br>
     *         (ԕω) doFilter:sȂ<br>
     *         
     * <br>
     * gq`FbNΏۊOXgrequestURI̒l܂܂ꂸAgq֎~XgrequestURI擾gqi󕶎j܂܂ꍇArequest̑lEXTENSION_THRU_KEYtrueݒ肵Arequest̏ԃR[h"404"ݒ肵ďI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter05() throws Exception {
           // O
        ExtensionFilter filter = new ExtensionFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        ExtensionFilter_ServletResponseStub01 response =
            new ExtensionFilter_ServletResponseStub01();
        
        ExtensionFilter_FilterChainStub01 filterChain =
            new ExtensionFilter_FilterChainStub01();
       
        // prohibitedExtensionList:List 
        ArrayList<String> prohibitedExtensionList = new ArrayList<String>();
        prohibitedExtensionList.add("");
        // restrictionEscapePaths:List
        ArrayList restrictionEscapePaths = new ArrayList();
        
        // prohibitedExtensionListݒ
        UTUtil.setPrivateField(filter,
                "prohibitedExtensionList", 
                prohibitedExtensionList);
        // restrictionEscapePathsݒ
        UTUtil.setPrivateField(filter, 
                "restrictionEscapePaths",
                restrictionEscapePaths); 
        // requestURIݒ
        request.setRequestURI("/test/test");
        request.setContextPath("/test");
        
        // eXg{
        filter.doFilter(request, response, filterChain);
        // 
        assertEquals("true", request.getAttribute("EXTENSION_THRU_KEY"));
        assertEquals(HttpServletResponse.SC_NOT_FOUND, UTUtil.getPrivateField(response, "errorCode"));
        assertFalse(filterChain.isCalled);
    }

    /**
     * testDoFilter06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () EXTENSION_THRU_KEY:null<br>
     *         () requestURI:"/test/test.ext2"<br>
     *         () contextPath:"/test"<br>
     *         () restrictionEscapePaths:"/test.ext2"<br>
     *                "/test.ext3"<br>
     *         () prohibitedExtensionList:".ext1"<br>
     *                ".ext2"<br>
     *                ".ext3"<br>
     *         
     * <br>
     * ҒlF(ԕω) EXTENSION_THRU_KEY:"true"<br>
     *         (ԕω) sendError:Ă΂Ȃ<br>
     *         (ԕω) doFilter:s<br>
     *         
     * <br>
     * o^Ăgq`FbNΏۊOXgrequestURI̒l܂܂ꍇAo^Ăgq֎~XgrequestURI擾gqi".ext2"j܂܂ĂĂAgq`FbNs킸Arequest̑lEXTENSION_THRU_KEYtrueݒ肵ďI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter06() throws Exception {
        // O
        ExtensionFilter filter = new ExtensionFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        ExtensionFilter_ServletResponseStub01 response =
            new ExtensionFilter_ServletResponseStub01();
        
        ExtensionFilter_FilterChainStub01 filterChain =
            new ExtensionFilter_FilterChainStub01();
       
        // prohibitedExtensionList:"" 
        ArrayList<String> prohibitedExtensionList = new ArrayList<String>();
        prohibitedExtensionList.add(".ext1");
        prohibitedExtensionList.add(".ext2");
        prohibitedExtensionList.add(".ext3");
        // restrictionEscapePaths:"/test/test"
        ArrayList<String> restrictionEscapePaths = new ArrayList<String>();
        restrictionEscapePaths.add("/test.ext2");
        restrictionEscapePaths.add("/test.ext3");
        
        // prohibitedExtensionListݒ
        UTUtil.setPrivateField(filter,
                "prohibitedExtensionList", 
                prohibitedExtensionList);
        // restrictionEscapePathsݒ
        UTUtil.setPrivateField(filter, 
                "restrictionEscapePaths",
                restrictionEscapePaths); 
        
        // requestURIݒ
        request.setRequestURI("/test/test.ext2");
        request.setContextPath("/test");
        
        // eXg{
        filter.doFilter(request, response, filterChain);
        // 
        assertEquals("true", request.getAttribute("EXTENSION_THRU_KEY"));
        assertEquals(-1, UTUtil.getPrivateField(response, "errorCode"));
        assertTrue(filterChain.isCalled);
    }

    /**
     * testDoFilter07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () EXTENSION_THRU_KEY:null<br>
     *         () requestURI:"/test/test.ext"<br>
     *         () contextPath:"/test"<br>
     *         () restrictionEscapePaths:List<br>
     *         () prohibitedExtensionList:List<br>
     *         
     * <br>
     * ҒlF(ԕω) EXTENSION_THRU_KEY:"true"<br>
     *         (ԕω) sendError:Ă΂Ȃ<br>
     *         (ԕω) doFilter:s<br>
     *         
     * <br>
     * gq`FbNΏۊOXgrequestURI̒l܂܂ꂸAgq֎~XgrequestURI擾gqi".ext"j܂܂ȂꍇArequest̑lEXTENSION_THRU_KEYtrueݒ肵ďI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter07() throws Exception {
        // O
        ExtensionFilter filter = new ExtensionFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        ExtensionFilter_ServletResponseStub01 response =
            new ExtensionFilter_ServletResponseStub01();
        
        ExtensionFilter_FilterChainStub01 filterChain =
            new ExtensionFilter_FilterChainStub01();
       
        // prohibitedExtensionList:List 
        ArrayList prohibitedExtensionList = new ArrayList();
        // restrictionEscapePaths:List
        ArrayList restrictionEscapePaths = new ArrayList();
        
        // prohibitedExtensionListݒ
        UTUtil.setPrivateField(filter,
                "prohibitedExtensionList", 
                prohibitedExtensionList);
        // restrictionEscapePathsݒ
        UTUtil.setPrivateField(filter, 
                "restrictionEscapePaths",
                restrictionEscapePaths); 
        // requestURIݒ
        request.setRequestURI("/test/test.ext");
        request.setContextPath("/test");
        
        // eXg{
        filter.doFilter(request, response, filterChain);
        // 
        assertEquals("true", request.getAttribute("EXTENSION_THRU_KEY"));
        assertEquals(-1, UTUtil.getPrivateField(response, "errorCode"));
        assertTrue(filterChain.isCalled);
    }

    /**
     * testDoFilter08()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () EXTENSION_THRU_KEY:null<br>
     *         () requestURI:"/test/test.ext1"<br>
     *         () contextPath:"/test"<br>
     *         () restrictionEscapePaths:List<br>
     *         () prohibitedExtensionList:".ext1"<br>
     *                ".ext2"<br>
     *                ".ext3"<br>
     *         
     * <br>
     * ҒlF(ԕω) EXTENSION_THRU_KEY:"true"<br>
     *         (ԕω) sendError:HttpServletResponse.SC_NOT_FOUND^<br>
     *         (ԕω) doFilter:sȂ<br>
     *         
     * <br>
     * gq`FbNΏۊOXgrequestURI̒l܂܂ꂸAo^Ăgq֎~XgrequestURI擾gqi".ext1"j܂܂ꍇArequest̑lEXTENSION_THRU_KEYtrueݒ肵Arequest̏ԃR[h"404"ݒ肵ďI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter08() throws Exception {
           // O
        ExtensionFilter filter = new ExtensionFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        ExtensionFilter_ServletResponseStub01 response =
            new ExtensionFilter_ServletResponseStub01();
        
        ExtensionFilter_FilterChainStub01 filterChain =
            new ExtensionFilter_FilterChainStub01();
       
        // prohibitedExtensionList:List 
        ArrayList<String> prohibitedExtensionList = new ArrayList<String>();
        prohibitedExtensionList.add(".ext1");
        prohibitedExtensionList.add(".ext2");
        prohibitedExtensionList.add(".ext3");
        // restrictionEscapePaths:List
        ArrayList restrictionEscapePaths = new ArrayList();
        
        // prohibitedExtensionListݒ
        UTUtil.setPrivateField(filter,
                "prohibitedExtensionList", 
                prohibitedExtensionList);
        // restrictionEscapePathsݒ
        UTUtil.setPrivateField(filter, 
                "restrictionEscapePaths",
                restrictionEscapePaths); 
        // requestURIݒ
        request.setRequestURI("/test/test.ext1");
        request.setContextPath("/test");
        request.setServletPath("/test.ext1");
        
        // eXg{
        filter.doFilter(request, response, filterChain);
        // 
        assertEquals("true", request.getAttribute("EXTENSION_THRU_KEY"));
        assertEquals(HttpServletResponse.SC_NOT_FOUND, UTUtil.getPrivateField(response, "errorCode"));
        assertFalse(filterChain.isCalled);
    }

}
