/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.web.struts.reset.Resetter;
import jp.terasoluna.fw.web.struts.reset.ResetterImpl;
import jp.terasoluna.utlib.DynaActionFormCreator;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpSession;
import jp.terasoluna.utlib.MockServletContext;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.commons.beanutils.DynaProperty;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionFormClass;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;

/**
 * {@link jp.terasoluna.fw.web.struts.form.DynaValidatorActionFormEx} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * IANVtH[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.form.DynaValidatorActionFormEx
 */
public class DynaValidatorActionFormExTest extends TestCase {

    /**
     * DynaValidatorActionFormEx̃vpeBݒt@C
     */
    private static final String CONFIG_FILE_PATH =
        DynaValidatorActionFormExTest.class.getResource(
                "DynaValidatorActionFormExTest.xml").getPath();

    /**
     * DynaValidatorActionFormEx[ݒt@C
     */
    private final static String RULES_FILE_PATH =
        DynaValidatorActionFormExTest.class.getResource(
                "DynaValidatorActionFormExTest-rules.xml").getPath();
    /**
     * DynaValidatorActionFormEx𐶐NXB
     */
    private static final DynaActionFormCreator creator
        = new DynaActionFormCreator(RULES_FILE_PATH);

    /**
     * eXgΏۂ̃CX^X
     */
    private DynaValidatorActionFormEx formEx = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DynaValidatorActionFormExTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @SuppressWarnings("unchecked")
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        // create formEx
        // Ώۂłset\bhĂяoȂ悤ɁAvpeBݒ̋LqȂt@Cw
        this.formEx = (DynaValidatorActionFormEx) creator
                .create(CONFIG_FILE_PATH);

        // i[l̍쐬
        int hogeInt = 123;
        String hogeString = "data1";
        int[] hogeIntArray = {-100, 0, 10, 111};
        String[] hogeStringArray = new String[4];
        Object[] hogeObjectArray = new Object[4];
        List<Object> hogeList = new ArrayList<Object>();
        Map<String, Object> hogeMap = new HashMap<String, Object>();
        Runnable hogeRunnable = new Runnable() {
            public void run() {
            }
        };
        boolean hogeBoolean = true;
        byte hogeByte = 1;
        char hogeChar = 'A';
        double hogeDouble = 999.9;
        float hogeFloat = 999;
        short hogeShort = 9;
        long hogeLong = 9;

        for (int i = 0; i < 4; i++) {
            hogeStringArray[i] = "data" + (i + 1);
            hogeObjectArray[i] = new Integer(i + 1);
            hogeList.add(i, "data" + (i + 1));
            hogeMap.put("field" + (i + 1), "data" + (i + 1));
        }

        String[] fields = {
                "hogeInt",
                "hogeString",
                "hogeIntArray",
                "hogeStringArray",
                "hogeObjectArray",
                "hogeList",
                "hogeMap",
                "hogeRunnable",
                "hogeBoolean",
                "hogeByte",
                "hogeChar",
                "hogeDouble",
                "hogeFloat",
                "hogeShort",
                "hogeLong"
                };
        Class[] fieldClasses = {
                int.class,
                hogeString.getClass(),
                hogeIntArray.getClass(),
                hogeStringArray.getClass(),
                hogeObjectArray.getClass(),
                hogeList.getClass(),
                hogeMap.getClass(),
                hogeRunnable.getClass(),
                boolean.class,
                byte.class,
                char.class,
                double.class,
                float.class,
                short.class,
                long.class
                };
        DynaProperty[] props = new DynaProperty[fields.length];
        HashMap<String, DynaProperty> propsMap = new HashMap<String, DynaProperty>();
        for (int i = 0;i < fields.length; i++) {
            props[i] = new DynaProperty(fields[i], fieldClasses[i]);
            propsMap.put(props[i].getName(), props[i]);
        }
        DynaActionFormClass dynaActionFormClass = (DynaActionFormClass) UTUtil
                .getPrivateField(this.formEx, "dynaClass");
        UTUtil.setPrivateField(dynaActionFormClass, "properties", props);
        UTUtil.setPrivateField(dynaActionFormClass, "propertiesMap", propsMap);

        Map<String, Object> map = (Map) UTUtil.getPrivateField(this.formEx,
                "dynaValues");
        map.put("hogeInt", hogeInt);
        map.put("hogeString", hogeString);
        map.put("hogeIntArray", hogeIntArray);
        map.put("hogeStringArray", hogeStringArray);
        map.put("hogeObjectArray", hogeObjectArray);
        map.put("hogeList", hogeList);
        map.put("hogeMap", hogeMap);
        map.put("hogeRunnable", hogeRunnable);
        map.put("hogeBoolean", hogeBoolean);
        map.put("hogeByte", hogeByte);
        map.put("hogeChar", hogeChar);
        map.put("hogeDouble", hogeDouble);
        map.put("hogeFloat", hogeFloat);
        map.put("hogeShort", hogeShort);
        map.put("hogeLong", hogeLong);
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public DynaValidatorActionFormExTest(String name) {
        super(name);
    }

    /**
     * testGet01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:null<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerExceptionF<br>
     *                    bZ[WF"No indexed value for 'null[0]'"<br>
     *
     * <br>
     * namenullݒ肵ANullPointerExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet01() throws Exception {
        // eXgs
        try {
            this.formEx.get(null, 0);
            fail();
        } catch (NullPointerException e) {
            // eXgʊmF
            assertEquals("No indexed value for 'null[0]'", e.getMessage());
        }
    }

    /**
     * testGet02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:󕶎<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerExceptionF<br>
     *                    bZ[WF"No indexed value for '[0]'"<br>
     *
     * <br>
     * nameɋ󕶎ݒ肵ANullPointerExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet02() throws Exception {
        // eXgs
        try {
            this.formEx.get("", 0);
            fail();
        } catch (NullPointerException e) {
            // eXgʊmF
            assertEquals("No indexed value for '[0]'", e.getMessage());
        }
    }

    /**
     * testGet03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"foo"i݂ȂtB[hj<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerExceptionF<br>
     *                    bZ[WF"No indexed value for 'foo[0]'"<br>
     *
     * <br>
     * nameɑ݂ȂtB[hݒ肵ANullPointerExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet03() throws Exception {
        // eXgs
        try {
            this.formEx.get("foo", 0);
            fail();
        } catch (NullPointerException e) {
            // eXgʊmF
            assertEquals("No indexed value for 'foo[0]'", e.getMessage());
        }
    }

    /**
     * testGet04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeString"<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentExceptionF<br>
     *                    bZ[WF"Non-indexed property for 'hogeString[0]'"<br>
     *
     * <br>
     * fieldNameɔzłListtB[hݒ肵AIllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet04() throws Exception {
        // eXgs
        try {
            this.formEx.get("hogeString", 0);
            fail();
        } catch (IllegalArgumentException e) {
            // eXgʊmF
            assertEquals("Non-indexed property for 'hogeString[0]'", e
                    .getMessage());
        }
    }

    /**
     * testGet05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:-1<br>
     *         () fieldNameŎw肳ꂽtB[h:Stringz^:["data1", "data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(߂l) Object:null<br>
     *
     * <br>
     * nameɔz^̃tB[hݒ肵AIndex-1ݒ肵AnullԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet05() throws Exception {
        // eXgs
        Object object = this.formEx.get("hogeStringArray", -1);

        // eXgʊmF
        assertNull(object);
    }

    /**
     * testGet06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:0<br>
     *         () fieldNameŎw肳ꂽtB[h:Stringz^:["data1", "data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(߂l) Object:"data1"<br>
     *
     * <br>
     * nameɔz^̃tB[hݒ肵AIndex0ݒ肵AlԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet06() throws Exception {
        // eXgs
        Object object = this.formEx.get("hogeStringArray", 0);

        // eXgʊmF
        assertEquals("data1", object);
    }

    /**
     * testGet07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:10<br>
     *         () fieldNameŎw肳ꂽtB[h:Stringz^:["data1", "data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(߂l) Object:null<br>
     *
     * <br>
     * nameɔz^̃tB[hݒ肵AIndex10ݒ肵AnullԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet07() throws Exception {
        // eXgs
        Object object = this.formEx.get("hogeStringArray", 10);

        // eXgʊmF
        assertNull(object);
    }

    /**
     * testGet08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:-1<br>
     *         () fieldNameŎw肳ꂽtB[h:List^:["data1","data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(߂l) Object:null<br>
     *
     * <br>
     * nameList^̃tB[hݒ肵AIndex-1ݒ肵AnullԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet08() throws Exception {
        // eXgs
        Object object = this.formEx.get("hogeList", -1);

        // eXgʊmF
        assertNull(object);
    }

    /**
     * testGet09() <br>
     * <br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:0<br>
     *         () fieldNameŎw肳ꂽtB[h:List^:["data1","data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(߂l) Object:"data1"<br>
     *
     * <br>
     * nameList^̃tB[hݒ肵AIndex0ݒ肵AlԂ鎖mFB <br>
     *
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGet09() throws Exception {
        // eXgs
        Object object = this.formEx.get("hogeList", 0);

        // eXgʊmF
        assertEquals("data1", object);
    }

    /**
     * testGet10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:10<br>
     *         () fieldNameŎw肳ꂽtB[h:List^:["data1","data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(߂l) Object:null<br>
     *
     * <br>
     * nameList^̃tB[hݒ肵AIndex10ݒ肵AnullԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet10() throws Exception {
        // eXgs
        Object object = this.formEx.get("hogeList", 10);

        // eXgʊmF
        assertNull(object);
    }

    /**
     * testGet11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:-1<br>
     *         () fieldNameŎw肳ꂽtB[h:intz^:[-100, 0, 10, 111]<br>
     *
     * <br>
     * ҒlF(߂l) Object:null<br>
     *
     * <br>
     * nameɔz^̃tB[hݒ肵AIndex-1ݒ肵AnullԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet11() throws Exception {
        // eXgs
        Object object = this.formEx.get("hogeIntArray", -1);

        // eXgʊmF
        assertNull(object);
    }

    /**
     * testGet12()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:0<br>
     *         () fieldNameŎw肳ꂽtB[h:intz^:[-100, 0, 10, 111]<br>
     *
     * <br>
     * ҒlF(߂l) Object:-100<br>
     *
     * <br>
     * nameɔz^̃tB[hݒ肵AIndex0ݒ肵AlԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet12() throws Exception {
        // eXgs
        Object object = this.formEx.get("hogeIntArray", 0);

        // eXgʊmF
        assertEquals(-100, object);
    }

    /**
     * testGet13()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:10<br>
     *         () fieldNameŎw肳ꂽtB[h:intz^:[-100, 0, 10, 111]<br>
     *
     * <br>
     * ҒlF(߂l) Object:null<br>
     *
     * <br>
     * nameɔz^̃tB[hݒ肵AIndex10ݒ肵AnullԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet13() throws Exception {
        // eXgs
        Object object = this.formEx.get("hogeIntArray", 10);

        // eXgʊmF
        assertNull(object);
    }

    /**
     * testGetIndexCount01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:null<br>
     *
     * <br>
     * ҒlF(߂l) int:0<br>
     *
     * <br>
     * fieldNamenullݒ肵A0Ԃ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount01() throws Exception {
        // eXgs
        int i = this.formEx.getIndexCount(null);

        // eXgʊmF
        assertEquals(0, i);
    }

    /**
     * testGetIndexCount02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:󕶎<br>
     *
     * <br>
     * ҒlF(߂l) int:0<br>
     *
     * <br>
     * fieldNameɋ󕶎ݒ肵A0Ԃ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount02() throws Exception {
        // eXgs
        int i = this.formEx.getIndexCount("");

        // eXgʊmF
        assertEquals(0, i);
    }

    /**
     * testGetIndexCount03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"foo"i݂ȂtB[hj<br>
     *
     * <br>
     * ҒlF(߂l) int:0<br>
     *
     * <br>
     * fieldNmaeɑ݂ȂtB[hݒ肵A0Ԃ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount03() throws Exception {
        // eXgs
        int i = this.formEx.getIndexCount("foo");

        // eXgʊmF
        assertEquals(0, i);
    }

    /**
     * testGetIndexCount04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeString"<br>
     *         () fieldNameŎw肳ꂽtB[h:String^:"data0"<br>
     *
     * <br>
     * ҒlF(߂l) int:1<br>
     *
     * <br>
     * fieldNameɔzłListtB[hݒ肵A1Ԃ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount04() throws Exception {
        // eXgs
        int i = this.formEx.getIndexCount("hogeString");

        // eXgʊmF
        assertEquals(1, i);
    }

    /**
     * testGetIndexCount05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeStringArray"<br>
     *         () fieldNameŎw肳ꂽtB[h:Stringz^:["data1", "data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(߂l) int:4<br>
     *
     * <br>
     * fieldNameɔz^̃tB[hݒ肵AlԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount05() throws Exception {
        // eXgs
        int i = this.formEx.getIndexCount("hogeStringArray");

        // eXgʊmF
        assertEquals(4, i);
    }

    /**
     * testGetIndexCount06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeList"<br>
     *         () fieldNameŎw肳ꂽtB[h:List^:["data1","data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(߂l) int:4<br>
     *
     * <br>
     * fieldNameList^̃tB[hݒ肵AlԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount06() throws Exception {
        // eXgs
        int i = this.formEx.getIndexCount("hogeList");

        // eXgʊmF
        assertEquals(4, i);
    }

    /**
     * testGetIndexCount07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeMap"<br>
     *         () fieldNameŎw肳ꂽtB[h:Map^:[field1="data1", field2="data2", field3="data3", field4=data4"]<br>
     *
     * <br>
     * ҒlF(߂l) int:4<br>
     *
     * <br>
     * fieldNameMap^̃tB[hݒ肵AlԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount07() throws Exception {
        // eXgs
        int i = this.formEx.getIndexCount("hogeMap");

        // eXgʊmF
        assertEquals(4, i);
    }

    /**
     * testReset01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:ftHgW[i[NGXgIuWFNg<br>
     *         () resetter:null<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) DynaValidatorActionFormEx_ResetterStub01#reset():s<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * ftHgW[i[NGXgIuWFNgݒ肵AResetternullꍇAωɏI邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testReset01() throws Exception {
        // NGXg̐
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ZbV̐
        MockHttpSession session = new MockHttpSession();
        // ReLXg̐
        MockServletContext context = new MockServletContext();
        // ANVT[ubg̐
        DynaValidatorActionFormEx_ActionServletStub01 servlet =
            new DynaValidatorActionFormEx_ActionServletStub01();
        // vtBbNX̐
        String prefix = "";
        // W[ݒ̐
        ModuleConfig moduleConfig = new ModuleConfigImpl(prefix);
        // }bsO̐
        ActionMapping mapping = new ActionMapping();

        // ݒ
        request.setSession(session);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        session.setServletContext(context);
        context.setAttribute(Resetter.RESETTER_KEY + prefix, null);
        context.setAttribute(Globals.MODULE_KEY, moduleConfig);
        this.formEx.setServlet(servlet);
        servlet.setContext(context);

        // eXgs
        this.formEx.reset(mapping, request);
    }

    /**
     * testReset02() <br>
     * <br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:ftHgW[i[NGXgIuWFNg<br>
     *         () resetter:ResetterȊÕIuWFNg<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) DynaValidatorActionFormEx_ResetterStub01#reset():s<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    O<br>
     *                    ClassCastException<br>
     *
     * <br>
     * ftHgW[i[NGXgIuWFNgݒ肵AResetterȊÕIuWFNg擾ꍇAOo͂AI邱ƂmFB
     * <br>
     *
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testReset02() throws Exception {
        // NGXg̐
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ZbV̐
        MockHttpSession session = new MockHttpSession();
        // ReLXg̐
        MockServletContext context = new MockServletContext();
        // ANVT[ubg̐
        DynaValidatorActionFormEx_ActionServletStub01 servlet = new DynaValidatorActionFormEx_ActionServletStub01();
        // vtBbNX̐
        String prefix = "";
        // W[ݒ̐
        ModuleConfig moduleConfig = new ModuleConfigImpl(prefix);
        // }bsO̐
        ActionMapping mapping = new ActionMapping();

        // ݒ
        request.setSession(session);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        session.setServletContext(context);
        context.setAttribute(Resetter.RESETTER_KEY + prefix, new Object());
        context.setAttribute(Globals.MODULE_KEY, moduleConfig);
        this.formEx.setServlet(servlet);
        servlet.setContext(context);

        // eXgs
        this.formEx.reset(mapping, request);

        // eXgʊmF
        assertTrue(LogUTUtil.checkError("", new ClassCastException()));
    }

    /**
     * testReset03() <br>
     * <br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:ftHgW[i[NGXgIuWFNg<br>
     *         () resetter:ResetterIuWFNgiDynaValidatorActionFormEx_ResetterStub01j<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) DynaValidatorActionFormEx_ResetterStub01#reset():s<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * ftHgW[i[NGXgIuWFNgݒ肵AresetterResetterIuWFNg̏ꍇAreset()\bhĂ΂邱ƂmFB
     * <br>
     *
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testReset03() throws Exception {
        // NGXg̐
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ZbV̐
        MockHttpSession session = new MockHttpSession();
        // ReLXg̐
        MockServletContext context = new MockServletContext();
        // ANVT[ubg̐
        DynaValidatorActionFormEx_ActionServletStub01 servlet = new DynaValidatorActionFormEx_ActionServletStub01();
        // vtBbNX̐
        String prefix = "";
        // W[ݒ̐
        ModuleConfig moduleConfig = new ModuleConfigImpl(prefix);
        // }bsO̐
        ActionMapping mapping = new ActionMapping();
        // Zb^[̐
        ResetterImpl resetter = new DynaValidatorActionFormEx_ResetterStub01();

        // ݒ
        request.setSession(session);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        session.setServletContext(context);
        context.setAttribute(Resetter.RESETTER_KEY + prefix, resetter);
        context.setAttribute(Globals.MODULE_KEY, moduleConfig);
        this.formEx.setServlet(servlet);
        servlet.setContext(context);

        // eXgs
        this.formEx.reset(mapping, request);

        // eXgʊmF
        assertNotNull(request.getAttribute("SUCCESS"));
    }

    /**
     * testReset04() <br>
     * <br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:TuW[i[NGXgIuWFNg<br>
     *         () resetter:null<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) DynaValidatorActionFormEx_ResetterStub01#reset():s<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * TuW[i[NGXgIuWFNgݒ肵AResetternullꍇAωɏI邱ƂmFB <br>
     *
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testReset04() throws Exception {
        // NGXg̐
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ZbV̐
        MockHttpSession session = new MockHttpSession();
        // ReLXg̐
        MockServletContext context = new MockServletContext();
        // ANVT[ubg̐
        DynaValidatorActionFormEx_ActionServletStub01 servlet = new DynaValidatorActionFormEx_ActionServletStub01();
        // vtBbNX̐
        String prefix = "sub1";
        // W[ݒ̐
        ModuleConfig moduleConfig = new ModuleConfigImpl(prefix);
        // }bsO̐
        ActionMapping mapping = new ActionMapping();

        // ݒ
        request.setSession(session);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        session.setServletContext(context);
        context.setAttribute(Resetter.RESETTER_KEY + prefix, null);
        context.setAttribute(Globals.MODULE_KEY, moduleConfig);
        this.formEx.setServlet(servlet);
        servlet.setContext(context);

        // eXgs
        this.formEx.reset(mapping, request);
    }

    /**
     * testReset05() <br>
     * <br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:TuW[i[NGXgIuWFNg<br>
     *         () resetter:ResetterȊÕIuWFNg<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) DynaValidatorActionFormEx_ResetterStub01#reset():s<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    O<br>
     *                    ClassCastException<br>
     *
     * <br>
     * TuW[i[NGXgIuWFNgݒ肵AResetterȊÕIuWFNg擾ꍇAOo͂AI邱ƂmFB
     * <br>
     *
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testReset05() throws Exception {
        // NGXg̐
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ZbV̐
        MockHttpSession session = new MockHttpSession();
        // ReLXg̐
        MockServletContext context = new MockServletContext();
        // ANVT[ubg̐
        DynaValidatorActionFormEx_ActionServletStub01 servlet = new DynaValidatorActionFormEx_ActionServletStub01();
        // vtBbNX̐
        String prefix = "sub1";
        // W[ݒ̐
        ModuleConfig moduleConfig = new ModuleConfigImpl(prefix);
        // }bsO̐
        ActionMapping mapping = new ActionMapping();

        // ݒ
        request.setSession(session);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        session.setServletContext(context);
        context.setAttribute(Resetter.RESETTER_KEY + prefix, new Object());
        context.setAttribute(Globals.MODULE_KEY, moduleConfig);
        this.formEx.setServlet(servlet);
        servlet.setContext(context);

        // eXgs
        this.formEx.reset(mapping, request);

        // eXgʊmF
        assertTrue(LogUTUtil.checkError("", new ClassCastException()));
    }

    /**
     * testReset06() <br>
     * <br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:TuW[i[NGXgIuWFNg<br>
     *         () resetter:ResetterIuWFNgiDynaValidatorActionFormEx_ResetterStub01j<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) DynaValidatorActionFormEx_ResetterStub01#reset():s<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * TuW[i[NGXgIuWFNgݒ肵AresetterResetterIuWFNg̏ꍇAreset()\bhĂ΂邱ƂmFBB
     * <br>
     *
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testReset06() throws Exception {
        // NGXg̐
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ZbV̐
        MockHttpSession session = new MockHttpSession();
        // ReLXg̐
        MockServletContext context = new MockServletContext();
        // ANVT[ubg̐
        DynaValidatorActionFormEx_ActionServletStub01 servlet = new DynaValidatorActionFormEx_ActionServletStub01();
        // vtBbNX̐
        String prefix = "sub1";
        // W[ݒ̐
        ModuleConfig moduleConfig = new ModuleConfigImpl(prefix);
        // }bsO̐
        ActionMapping mapping = new ActionMapping();
        // Zb^[̐
        ResetterImpl resetter = new DynaValidatorActionFormEx_ResetterStub01();

        // ݒ
        request.setSession(session);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        session.setServletContext(context);
        context.setAttribute(Resetter.RESETTER_KEY + prefix, resetter);
        context.setAttribute(Globals.MODULE_KEY, moduleConfig);
        this.formEx.setServlet(servlet);
        servlet.setContext(context);

        // eXgs
        this.formEx.reset(mapping, request);

        // eXgʊmF
        assertNotNull(request.getAttribute("SUCCESS"));
    }

    /**
     * testSetStringintObject01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:null<br>
     *         () index:0<br>
     *         () value:"hello"<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerExceptionF<br>
     *                    bZ[WF"No indexed value for 'null[0]'"<br>
     *         (ԕω) nameŎw肳ꂽtB[h:|<br>
     *
     * <br>
     * namenullݒ肵ANullPointerExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject01() throws Exception {
        //eXgs
        try {
            this.formEx.set(null, 0, "hello");
            fail();
        } catch (NullPointerException e) {
            //eXgʊmF
            assertEquals("No indexed value for 'null[0]'", e.getMessage());
        }
    }

    /**
     * testSetStringintObject02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:󕶎<br>
     *         () index:0<br>
     *         () value:"hello"<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerExceptionF<br>
     *                    bZ[WF"No indexed value for '[0]'"<br>
     *         (ԕω) nameŎw肳ꂽtB[h:|<br>
     *
     * <br>
     * nameɋ󕶎ݒ肵ANullPointerExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject02() throws Exception {
        //eXgs
        try {
            this.formEx.set("", 0, "hello");
            fail();
        } catch (NullPointerException e) {
            //eXgʊmF
            assertEquals("No indexed value for '[0]'", e.getMessage());
        }
    }

    /**
     * testSetStringintObject03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"foo"i݂ȂtB[hj<br>
     *         () index:0<br>
     *         () value:"hello"<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerExceptionF<br>
     *                    bZ[WF"No indexed value for 'foo[0]'"<br>
     *         (ԕω) nameŎw肳ꂽtB[h:|<br>
     *
     * <br>
     * nameɑ݂ȂtB[hݒ肵ANullPointerExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject03() throws Exception {
        //eXgs
        try {
            this.formEx.set("foo", 0, "hello");
            fail();
        } catch (NullPointerException e) {
            //eXgʊmF
            assertEquals("No indexed value for 'foo[0]'", e.getMessage());
        }
    }

    /**
     * testSetStringintObject04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeString"<br>
     *         () index:0<br>
     *         () value:"hello"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentExceptionF<br>
     *                    bZ[WF"Non-indexed property for 'hogeString[0]'"<br>
     *         (ԕω) nameŎw肳ꂽtB[h:|<br>
     *
     * <br>
     * nameString^̃tB[hݒ肵AIllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject04() throws Exception {
        //eXgs
        try {
            this.formEx.set("hogeString", 0, "hello");
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
            assertEquals("Non-indexed property for 'hogeString[0]'", e
                    .getMessage());
        }
    }

    /**
     * testSetStringintObject05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:-1<br>
     *         () value:"hello"<br>
     *         () nameŎw肳ꂽtB[h:Stringz^:["data1", "data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) O:ArrayIndexOutOfBoundsException<br>
     *         (ԕω) nameŎw肳ꂽtB[h:|<br>
     *
     * <br>
     * nameString[]^̃tB[hݒ肵AIndex-1ݒ肵AArrayIndexOutOfBoundsExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject05() throws Exception {
        //eXgs
        try {
            this.formEx.set("hogeStringArray", -1, "hello");
            fail();
        } catch (ArrayIndexOutOfBoundsException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetStringintObject06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:0<br>
     *         () value:null<br>
     *         () nameŎw肳ꂽtB[h:Stringz^:["data1", "data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:hogeStringArray[0] = null<br>
     *
     * <br>
     * nameString[]^̃tB[hݒ肵AIndex0ݒ肵AY0Ɉvaluei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject06() throws Exception {

        //eXgs
        this.formEx.set("hogeStringArray", 0, null);

        //eXgʊmF
        String[] resultArray = (String[]) ((HashMap) UTUtil.getPrivateField(
                this.formEx, "dynaValues")).get("hogeStringArray");
        assertNull(resultArray[0]);
    }

    /**
     * testSetStringintObject07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:1<br>
     *         () value:"hello"<br>
     *         () nameŎw肳ꂽtB[h:Stringz^:["data1", "data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:hogeStringArray[1] = "hello"<br>
     *
     * <br>
     * nameString[]^̃tB[hݒ肵AIndex1ݒ肵AY1Ɉvaluei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject07() throws Exception {
        //eXgs
        this.formEx.set("hogeStringArray", 1, "hello");

        //eXgʊmF
        String[] resultArray = (String[]) ((HashMap) UTUtil.getPrivateField(
                this.formEx, "dynaValues")).get("hogeStringArray");
        assertEquals("hello", resultArray[1]);
    }

    /**
     * testSetStringintObject08()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:2<br>
     *         () value:Integer(5)<br>
     *         () nameŎw肳ꂽtB[h:Stringz^:["data1", "data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *         (ԕω) nameŎw肳ꂽtB[h:|<br>
     *
     * <br>
     * nameString[]^̃tB[hݒ肵AIndex2ݒ肵AvaluesK؂Ȍ^̏ꍇAIllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject08() throws Exception {
        //eXgs
        try {
            this.formEx.set("hogeStringArray", 2, new Integer(5));
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF;
        }
    }

    /**
     * testSetStringintObject09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:10<br>
     *         () value:null<br>
     *         () nameŎw肳ꂽtB[h:Stringz^:["data1", "data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:hogeStringArray[10] = null<br>
     *
     * <br>
     * nameɃTCY4String[]^̃tB[hݒ肵AIndex10ݒ肵AY10Ɉvaluei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject09() throws Exception {
        //eXgs
        this.formEx.set("hogeStringArray", 10, null);

        //eXgʊmF
        String[] resultArray = (String[]) ((HashMap) UTUtil.getPrivateField(
                this.formEx, "dynaValues")).get("hogeStringArray");
        assertNull(resultArray[10]);
    }

    /**
     * testSetStringintObject10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:11<br>
     *         () value:"hello"<br>
     *         () nameŎw肳ꂽtB[h:Stringz^:["data1", "data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:hogeStringArray[11] = "hello"<br>
     *
     * <br>
     * nameɃTCY4String[]^̃tB[hݒ肵AIndex11ݒ肵AY11Ɉvaluei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject10() throws Exception {
        //eXgs
        this.formEx.set("hogeStringArray", 11, "hello");

        //eXgʊmF
        String[] resultArray = (String[]) ((HashMap) UTUtil.getPrivateField(
                this.formEx, "dynaValues")).get("hogeStringArray");
        assertEquals("hello", resultArray[11]);
    }

    /**
     * testSetStringintObject11()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:12<br>
     *         () value:Integer(5)<br>
     *         () nameŎw肳ꂽtB[h:Stringz^:["data1", "data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *         (ԕω) nameŎw肳ꂽtB[h:|<br>
     *
     * <br>
     * nameɃTCY4String[]^̃tB[hݒ肵AIndex12ݒ肵AvaluesK؂Ȍ^̏ꍇAIllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject11() throws Exception {
        //eXgs
        try {
            this.formEx.set("hogeStringArray", 12, new Integer(5));
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetStringintObject12()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:-1<br>
     *         () value:"hello"<br>
     *         () nameŎw肳ꂽtB[h:List^:["data1","data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) O:IndexOutOfBoundsException<br>
     *         (ԕω) nameŎw肳ꂽtB[h:|<br>
     *
     * <br>
     * nameList^̃tB[hݒ肵AIndex-1ݒ肵AIndexOutOfBoundsExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject12() throws Exception {
        //eXgs
        try {
            this.formEx.set("hogeList", -1, "hello");
            fail();
        } catch (IndexOutOfBoundsException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetStringintObject13()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:0<br>
     *         () value:null<br>
     *         () nameŎw肳ꂽtB[h:List^:["data1","data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:hogeList.get(0) = null<br>
     *
     * <br>
     * nameList^̃tB[hݒ肵AIndex0ݒ肵AY0Ɉvaluei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject13() throws Exception {
        // O̊mF
        assertNotNull(this.formEx.get("hogeList", 0));

        //eXgs
        this.formEx.set("hogeList", 0, null);

        //eXgʊmF
        List resultList = (List) ((HashMap) UTUtil.getPrivateField(
                this.formEx, "dynaValues")).get("hogeList");
        assertNull(resultList.get(0));
    }

    /**
     * testSetStringintObject14()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:1<br>
     *         () value:"hello"<br>
     *         () nameŎw肳ꂽtB[h:List^:["data1","data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:hogeList.get(1) = "hello"<br>
     *
     * <br>
     * nameList^̃tB[hݒ肵AIndex1ݒ肵AY1Ɉvaluei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject14() throws Exception {
        //eXgs
        this.formEx.set("hogeList", 1, "hello");

        //eXgʊmF
        List resultList = (List) ((HashMap) UTUtil.getPrivateField(
                this.formEx, "dynaValues")).get("hogeList");
        assertEquals("hello", resultList.get(1));
    }

    /**
     * testSetStringintObject15()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:2<br>
     *         () value:Integer(5)<br>
     *         () nameŎw肳ꂽtB[h:List^:["data1","data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:hogeList.get(2) = Integer(5)<br>
     *
     * <br>
     * nameList^̃tB[hݒ肵AIndex2ݒ肵AY2Ɉvaluei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject15() throws Exception {
        //eXgs
        this.formEx.set("hogeList", 2, new Integer(5));

        //eXgʊmF
        List resultList = (List) ((HashMap) UTUtil.getPrivateField(
                this.formEx, "dynaValues")).get("hogeList");
        assertEquals(new Integer(5), resultList.get(2));
    }

    /**
     * testSetStringintObject16()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:10<br>
     *         () value:null<br>
     *         () nameŎw肳ꂽtB[h:List^:["data1","data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:hogeList.get(10) = null<br>
     *
     * <br>
     * nameɃTCY4List^̃tB[hݒ肵AIndex10ݒ肵AY10Ɉvaluei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject16() throws Exception {
        //eXgs
        this.formEx.set("hogeList", 10, null);

        //eXgʊmF
        List resultList = (List) ((HashMap) UTUtil.getPrivateField(
                this.formEx, "dynaValues")).get("hogeList");
        assertNull(resultList.get(10));
    }

    /**
     * testSetStringintObject17()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:11<br>
     *         () value:"hello"<br>
     *         () nameŎw肳ꂽtB[h:List^:["data1","data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:hogeList.get(11) = "hello"<br>
     *
     * <br>
     * nameɃTCY4List^̃tB[hݒ肵AIndex11ݒ肵AY11Ɉvaluei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject17() throws Exception {
        //eXgs
        this.formEx.set("hogeList", 11, "hello");

        //eXgʊmF
        List resultList = (List) ((HashMap) UTUtil.getPrivateField(
                this.formEx, "dynaValues")).get("hogeList");
        assertEquals("hello", resultList.get(11));
    }

    /**
     * testSetStringintObject18()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:12<br>
     *         () value:Integer(5)<br>
     *         () nameŎw肳ꂽtB[h:List^:["data1","data2", "data3", "data4"]<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:hogeList.get(12) = Integer(5)<br>
     *
     * <br>
     * nameɃTCY4List^̃tB[hݒ肵AIndex12ݒ肵AY12Ɉvaluei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject18() throws Exception {
        //eXgs
        this.formEx.set("hogeList", 12, new Integer(5));

        //eXgʊmF
        List resultList = (List) ((HashMap) UTUtil.getPrivateField(
                this.formEx, "dynaValues")).get("hogeList");
        assertEquals(new Integer(5), resultList.get(12));
    }

    /**
     * testSetStringintObject19()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:-1<br>
     *         () value:"hello"<br>
     *         () nameŎw肳ꂽtB[h:intz^:[-100, 0, 10, 111]<br>
     *
     * <br>
     * ҒlF(ԕω) O:ArrayIndexOutOfBoundsException<br>
     *         (ԕω) nameŎw肳ꂽtB[h:|<br>
     *
     * <br>
     * nameint[]^̃tB[hݒ肵AArrayIndexOutOfBoundsExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject19() throws Exception {
        //eXgs
        try {
            this.formEx.set("hogeIntArray", -1, "hello");
            fail();
        } catch (ArrayIndexOutOfBoundsException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetStringintObject20()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:0<br>
     *         () value:null<br>
     *         () nameŎw肳ꂽtB[h:intz^:[-100, 0, 10, 111]<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *         (ԕω) nameŎw肳ꂽtB[h:|<br>
     *
     * <br>
     * nameint[]^̃tB[hݒ肵AIllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject20() throws Exception {
        //eXgs
        try {
            this.formEx.set("hogeIntArray", 0, null);
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetStringintObject21()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:1<br>
     *         () value:Integer(5)<br>
     *         () nameŎw肳ꂽtB[h:intz^:[-100, 0, 10, 111]<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:hogeStringArray[1] = Integer(5)<br>
     *
     * <br>
     * nameint[]^̃tB[hݒ肵AIndex"1"ݒ肵AY"1"valuei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject21() throws Exception {
        //eXgs
        this.formEx.set("hogeIntArray", 1, new Integer(5));

        //eXgʊmF
        int[] resultArray = (int[]) ((HashMap) UTUtil.getPrivateField(
                this.formEx, "dynaValues")).get("hogeIntArray");
        assertEquals(new Integer(5), (Integer) resultArray[1]);
    }

    /**
     * testSetStringintObject22()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:2<br>
     *         () value:"hello"<br>
     *         () nameŎw肳ꂽtB[h:intz^:[-100, 0, 10, 111]<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *         (ԕω) nameŎw肳ꂽtB[h:|<br>
     *
     * <br>
     * nameint[]^̃tB[hݒ肵AIndex"2"ݒ肵AvaluesK؂Ȍ^̏ꍇAIllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject22() throws Exception {
        //eXgs
        try {
            this.formEx.set("hogeIntArray", 2, "hello");
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetStringintObject23()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:10<br>
     *         () value:null<br>
     *         () nameŎw肳ꂽtB[h:intz^:[-100, 0, 10, 111]<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *         (ԕω) nameŎw肳ꂽtB[h:|<br>
     *
     * <br>
     * nameɃTCY"4"int[]^̃tB[hݒ肵AIndex"10"ݒ肵AIllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject23() throws Exception {
        //eXgs
        try {
            this.formEx.set("hogeIntArray", 10, null);
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetStringintObject24()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:11<br>
     *         () value:Integer(5)<br>
     *         () nameŎw肳ꂽtB[h:intz^:[-100, 0, 10, 111]<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:hogeStringArray[11] = Integer(5)<br>
     *
     * <br>
     * nameɃTCY"4"int[]^̃tB[hݒ肵AIndex"11"ݒ肵Avaluei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject24() throws Exception {
        //eXgs
        this.formEx.set("hogeIntArray", 11, new Integer(5));

        //eXgʊmF
        int[] resultArray = (int[]) ((HashMap) UTUtil.getPrivateField(
                this.formEx, "dynaValues")).get("hogeIntArray");
        assertEquals(new Integer(5), (Integer) resultArray[11]);
    }

    /**
     * testSetStringintObject25()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:12<br>
     *         () value:"hello"<br>
     *         () nameŎw肳ꂽtB[h:intz^:[-100, 0, 10, 111]<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *         (ԕω) nameŎw肳ꂽtB[h:|<br>
     *
     * <br>
     * nameɃTCY"4"int[]^̃tB[hݒ肵AIndex"12"ݒ肵AvaluesK؂Ȍ^̏ꍇAIllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject25() throws Exception {
        //eXgs
        try {
            this.formEx.set("hogeIntArray", 12, "hello");
        } catch (IllegalArgumentException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetStringintObject26()
     * 
     * z񒷃`FbNőlȏ̃CfbNXݒ肵IllegalArgumentException邱ƁB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject26() throws Exception {
        //eXgs
        try {
            this.formEx.set("hogeIntArray", 10000, "hello");
            fail();
        } catch (Exception e) {
            //eXgʊmF
            assertEquals(IllegalArgumentException.class, e.getClass());
            assertEquals("index size is too long. : 10000", e.getMessage());
        }
    }
    
    /**
     * testSetStringintObject27()
     * 
     * Xg`FbNőlȏ̃CfbNXݒ肵IllegalArgumentException邱ƁB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetStringintObject27() throws Exception {
        //eXgs
        try {
            this.formEx.set("hogeList", 10000, "hello");
            fail();
        } catch (Exception e) {
            //eXgʊmF
            assertEquals(IllegalArgumentException.class, e.getClass());
            assertEquals("index size is too long. : 10000", e.getMessage());
        }
    }
    
    
    /**
     * testIsModified01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () modified:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * i[Ămodified𐳏Ɏ擾邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsModified01() throws Exception {
        // O
        UTUtil.setPrivateField(this.formEx, "modified", true);

        // eXg{E
        assertTrue(this.formEx.isModified());
    }

    /**
     * testSetModified01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() modified:true<br>
     *         () modified:false<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) modified:true<br>
     *
     * <br>
     * Ɏw肵lmodifiedɐɊi[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetModified01() throws Exception {
        // eXgs
        this.formEx.setModified(true);

        // eXg
        assertTrue((Boolean) UTUtil.getPrivateField(formEx, "modified"));
    }

    /**
     * testSetIndexedValue01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:hoge<br>
     *                index:100<br>
     *                value:hoge<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) w肵set\bhĂяo邱<br>
     *
     * <br>
     * Ɏw肵lset\bhĂяoƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue01() throws Exception {
        DynaValidatorActionFormExStub01 stub =
            new DynaValidatorActionFormExStub01();
        stub.setIndexedValue("hoge", 100, "hoge");

        assertEquals("hoge", stub.name);
        assertEquals(100, stub.index);
        assertEquals("hoge", stub.value);
    }

    /**
     * testGetIndexedValue01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:hoge<br>
     *                index:100<br>
     *
     * <br>
     * ҒlF(߂l) Object:"hoge"<br>
     *         (ԕω) w肵get\bhĂяo邱<br>
     *
     * <br>
     * Ɏw肵lget\bhĂяoƂmFBB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue01() throws Exception {
        DynaValidatorActionFormExStub01 stub =
            new DynaValidatorActionFormExStub01();
        Object result = stub.getIndexedValue("hoge", 100);

        assertEquals("hoge", stub.name);
        assertEquals(100, stub.index);
        assertEquals("called", result);
    }

}
