/*
 * Copyright (c) 2016 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web;

import jp.terasoluna.utlib.MockHttpServletRequest;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.DefaultAccessControlPathResolver} NX ubN{bNXeXgB
 * <p>
 * <h4>yNX̊Tvz</h4> AccessControlPathResolver̃ftHgNXB
 * <p>
 * @see jp.terasoluna.fw.web.DefaultAccessControlPathResolver
 */
public class DefaultAccessControlPathResolverTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DefaultAccessControlPathResolverTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public DefaultAccessControlPathResolverTest(String name) {
        super(name);
    }

    /**
     * testResolveAccessControlPath01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample1"<br>
     * () request.getContextPath:"/sample1"<br>
     * () request.getServletPath:"/index.jsp"<br>
     * () request.getPathInfo:null<br>
     * <br>
     * ҒlF(߂l) String:""<br>
     * <br>
     * RequestURI̐擪ContextPathʂ󕶎̏ꍇA󕶎񂪎擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testResolveAccessControlPath01() throws Exception {
        // eXgf[^ݒ
        DefaultAccessControlPathResolver accessControlPathResolver = new DefaultAccessControlPathResolver();

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI("/sample1");
        req.setContextPath("/sample1");
        req.setServletPath("/index.jsp");
        req.setPathInfo(null);

        // eXgs
        String path = accessControlPathResolver.resolveAccessControlPath(req);

        // eXgʊmF
        // 󕶎񂪎擾ł邱
        assertEquals("", path);
    }

    /**
     * testResolveAccessControlPath02() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample1/"<br>
     * () request.getContextPath:"/sample1"<br>
     * () request.getServletPath:"/index.jsp"<br>
     * () request.getPathInfo:null<br>
     * <br>
     * ҒlF(߂l) String:"/"<br>
     * <br>
     * RequestURI̐擪ContextPathʂ"/"̏ꍇA"/"擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testResolveAccessControlPath02() throws Exception {
        // eXgf[^ݒ
        DefaultAccessControlPathResolver accessControlPathResolver = new DefaultAccessControlPathResolver();

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI("/sample1/");
        req.setContextPath("/sample1");
        req.setServletPath("/index.jsp");
        req.setPathInfo(null);

        // eXgs
        String path = accessControlPathResolver.resolveAccessControlPath(req);

        // eXgʊmF
        // "/"擾ł邱
        assertEquals("/", path);
    }

    /**
     * testResolveAccessControlPath03() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample1/sample.d%6F;jsessionid=xxx"<br>
     * () request.getContextPath:"/sample1"<br>
     * () request.getServletPath:"/sample.do"<br>
     * () request.getPathInfo:null<br>
     * <br>
     * ҒlF(߂l) String:"/sample.do"<br>
     * <br>
     * RequestURI̐擪ContextPathʂ"/"ł󕶎łȂꍇA
     * APathInfonull̏ꍇAServletPath擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testResolveAccessControlPath03() throws Exception {
        // eXgf[^ݒ
        DefaultAccessControlPathResolver accessControlPathResolver = new DefaultAccessControlPathResolver();

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI("/sample1/sample.d%6F;jsessionid=xxx");
        req.setContextPath("/sample1");
        req.setServletPath("/sample.do");
        req.setPathInfo(null);

        // eXgs
        String path = accessControlPathResolver.resolveAccessControlPath(req);

        // eXgʊmF
        // ServletPath擾ł邱
        assertEquals("/sample.do", path);
    }

    /**
     * testResolveAccessControlPath04() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample1/sample.jsp@@@"<br>
     * () request.getContextPath:"/sample1"<br>
     * () request.getServletPath:"/sample.jsp"<br>
     * () request.getPathInfo:"@@@"<br>
     * <br>
     * ҒlF(߂l) String:"/sample.jsp"<br>
     * <br>
     * RequestURI̐擪ContextPathʂ"/"ł󕶎łȂꍇA
     * APathInfo"/"Ŏn܂Ȃ̏ꍇAServletPath擾ł邱ƂmFB
     * (LɂAPathInfoȂpX΂sPathInfop^[)<br>
     * @throws Exception ̃\bhŔO
     */
    public void testResolveAccessControlPath04() throws Exception {
        // eXgf[^ݒ
        DefaultAccessControlPathResolver accessControlPathResolver = new DefaultAccessControlPathResolver();

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI("/sample1/sample.jsp@@@");
        req.setContextPath("/sample1");
        req.setServletPath("/sample.jsp");
        req.setPathInfo("@@@");

        // eXgs
        String path = accessControlPathResolver.resolveAccessControlPath(req);

        // eXgʊmF
        // ServletPath擾ł邱
        assertEquals("/sample.jsp", path);
    }

    /**
     * testResolveAccessControlPath05() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample1/servletPath/pathInf%6F;jsessionid=xxx<br>
     * () request.getContextPath:"/sample1"<br>
     * () request.getServletPath:"/servletPath"<br>
     * () request.getPathInfo:"/pathInfo"<br>
     * <br>
     * ҒlF(߂l) String:"/servletPath/pathInfo"<br>
     * <br>
     * RequestURI̐擪ContextPathʂ"/"ł󕶎łȂꍇA
     * APathInfo"/"Ŏn܂ꍇAServletPath{PathInfo擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testResolveAccessControlPath05() throws Exception {
        // eXgf[^ݒ
        DefaultAccessControlPathResolver accessControlPathResolver = new DefaultAccessControlPathResolver();

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI("/sample1/servletPath/pathInf%6F;jsessionid=xxx");
        req.setContextPath("/sample1");
        req.setServletPath("/servletPath");
        req.setPathInfo("/pathInfo");

        // eXgs
        String path = accessControlPathResolver.resolveAccessControlPath(req);

        // eXgʊmF
        // ServletPath{PathInfo擾ł邱
        assertEquals("/servletPath/pathInfo", path);
    }

    /**
     * testResolveAccessControlPath06() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample1/sample.html"<br>
     * () request.getContextPath:"/sample1"<br>
     * () request.getServletPath:null<br>
     * () request.getPathInfo:"/sample.html"<br>
     * <br>
     * ҒlF(߂l) String:"/sample.html"<br>
     * <br>
     * RequestURI̐擪ContextPathʂ"/"ł󕶎łȂꍇA
     * AServletPathnull̏ꍇAServletPath󕶎ƂĈ邱ƂmFB
     * PathInfo"/"Ŏn܂ꍇServletPath{PathInfo(ServletPath󕶎ƂĈ̂PathInfo)擾ł邱ƂmFB
     * (ServletPathnullɂȂ邩ƂP[Xł͒ʏ󕶎ɂȂ邪AnullԂT[oꍇƂp^[)<br>
     * @throws Exception ̃\bhŔO
     */
    public void testResolveAccessControlPath06() throws Exception {
        // eXgf[^ݒ
        DefaultAccessControlPathResolver accessControlPathResolver = new DefaultAccessControlPathResolver();

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI("/sample1/sample.html");
        req.setContextPath("/sample1");
        req.setServletPath(null);
        req.setPathInfo("/sample.html");

        // eXgs
        String path = accessControlPathResolver.resolveAccessControlPath(req);

        // eXgʊmF
        // ServletPath{PathInfo(ServletPath󕶎ƂĈ̂PathInfo)擾ł邱
        assertEquals("/sample.html", path);
    }

    /**
     * testResolveAccessControlPath07() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample1;jsessionid=xxx"<br>
     * () request.getContextPath:"/sample1"<br>
     * () request.getServletPath:null<br>
     * () request.getPathInfo:null<br>
     * <br>
     * ҒlF(߂l) String:""<br>
     * <br>
     * RequestURI̐擪ContextPathʂ"/"ł󕶎łȂꍇA
     * AServletPathnull̏ꍇAServletPath󕶎ƂĈ邱ƂmFB
     * PathInfonull̏ꍇServletPath(ServletPath󕶎ƂĈ̂ŋ󕶎)擾ł邱ƂmFB
     * (ServletPathnullɂȂ邩ƂP[Xł͒ʏ󕶎ɂȂ邪AnullԂT[oꍇƂp^[)<br>
     * @throws Exception ̃\bhŔO
     */
    public void testResolveAccessControlPath07() throws Exception {
        // eXgf[^ݒ
        DefaultAccessControlPathResolver accessControlPathResolver = new DefaultAccessControlPathResolver();

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI("/sample1;jsessionid=xxx");
        req.setContextPath("/sample1");
        req.setServletPath(null);
        req.setPathInfo(null);

        // eXgs
        String path = accessControlPathResolver.resolveAccessControlPath(req);

        // eXgʊmF
        // ServletPath(ServletPath󕶎ƂĈ̂ŋ󕶎)擾ł邱
        assertEquals("", path);
    }

    /**
     * testResolveAccessControlPath08() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:null<br>
     * <br>
     * ҒlF(߂l) null<br>
     * <br>
     * requestnull̏ꍇAnull擾ł邱ƂmFB<br>
     * @throws Exception ̃\bhŔO
     */
    public void testResolveAccessControlPath08() throws Exception {
        // eXgf[^ݒ
        DefaultAccessControlPathResolver accessControlPathResolver = new DefaultAccessControlPathResolver();

        // eXgs
        String path = accessControlPathResolver.resolveAccessControlPath(null);

        // eXgʊmF
        // null擾ł邱
        assertNull(path);
    }

}