/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.testcase;

import static jp.terasoluna.fw.ex.unit.common.PropertyKeys.WEBAPP_PATH;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.ex.unit.common.DefaultProperties;
import jp.terasoluna.fw.ex.unit.mock.MockQueryDao;
import jp.terasoluna.fw.ex.unit.mock.MockQueryRowHandleDao;
import jp.terasoluna.fw.ex.unit.mock.MockStoredProcedureDao;
import jp.terasoluna.fw.ex.unit.mock.MockUpdateDao;
import jp.terasoluna.fw.ex.unit.util.AssertUtils;
import jp.terasoluna.fw.ex.unit.util.ClassLoaderUtils;

import org.springframework.context.ApplicationContext;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;
import org.springframework.util.Assert;

/**
 * ƖWbNxeXgP[XB
 * 
 * <pre>
 * {ł͑OSpring{@link org.springframework.context.ApplicationContext}쐬܂B
 * 쐬ɂ͎̐ݒt@Cǂݍ݂܂B
 * </pre>
 * <table border=1>
 * <tr>
 * <th>ݒt@C</th>
 * <th>ftHgl</th>
 * <th>ύX|Cg</th>
 * <th>l</th>
 * </tr>
 * <tr>
 * <td>bNDAO`t@C</td>
 * <td>mockDaoBeans.xml(jarɓĂ)</td>
 * <td>terasoluna-unit-override.properties̈ȉɃL[ɑ΂lݒ肷邱ƂŁAύX\łB<br>
 * mockDaoBeans.xml-&gt; mockdaobeans.file<br>
 * ebNDAOBeanIDFQCNύXꍇmock-dao-beans-override.propertiesNXpXɔzuA
 * ㏑ݒsB<br>
 * </td>
 * <td>t@C݂ȂꍇA܂BRXgN^ɂ{@link #setLoadDefaultConfig(boolean)}
 * falseݒ肵ꍇ܂{@link #isLoadDefaultConfig()}falseԂ悤ɃI[oChꍇAǂݍ݂܂B
 * </td>
 * </tr>
 * <tr>
 * <td>W[Bean`t@C</td>
 * <td>WEB-INF/moduleContext.xml</td>
 * <td>terasoluna-unit-override.properties̈ȉɃL[ɑ΂lݒ肷邱ƂŁAύX\łB<br>
 * WEB-INF -&gt; webinf.dir<br>
 * moduleContext.xml -&gt; modulecontext.file<br>
 * </td>
 * <td>t@C݂ȂꍇA܂BRXgN^ɂ{@link #setLoadDefaultConfig(boolean)}
 * falseݒ肵ꍇ܂{@link #isLoadDefaultConfig()}falseԂ悤ɃI[oChꍇAǂݍ݂܂B
 * </td>
 * </tr>
 * <tr>
 * <td>Bean`t@C</td>
 * <td>Ȃ</td>
 * <td>
 * {@link #addConfigLocations(List)}
 * \bhœǂݍBean`t@CpX(NXpX)ǉ܂B̃Xgɒǉt@C̃pXaddĂB</td>
 * <td>t@C݂ȂꍇA
 * {@link org.springframework.beans.factory.BeanDefinitionStoreException}
 * X[܂B</td>
 * </tr>
 * </table>
 * 
 * <pre>
 * ǂݍBean`t@Cɒ`BeanR[hŎgpꍇAȉ̓ނBean擾@܂B
 * 
 * 1. {@link org.springframework.context.ApplicationContext#getBean(String)}ɂĎ擾@
 * 2. setter`autowire(by type)@
 * 
 * ȉ̂悤Ȓ`ꍇɂƂĐ܂B
 * 
 * WEB-INF/foo/fooContext.xml
 * 
 * &lt;!-- O㗪 --&gt;
 * &lt;bean id=&quot;foo&quot; class=&quot;com.example.Foo&quot; /&gt;
 * &lt;bean name=&quot;/foo&quot; class=&quot;com.example.FooBLogic&quot; /&gt;
 * 
 * 1. {@link org.springframework.context.ApplicationContext#getBean(String)}ɂĎ擾@
 * 
 * public FooTest extends {@link MockDaoInjectedTestCase} {
 *   public void testDoSomething() throws Exception {
 *     Foo foo = getBean(&quot;foo&quot;);
 *     // 邢 Foo foo = (Foo) applicationContext.getBean(&quot;foo&quot;);
 *     int result = foo.doSomething();
 *     assertEquals(1, result);
 *   }
 * }
 * 
 * public FooBLogicTest extends {@link MockDaoInjectedTestCase} {
 *   public void testFoo()  throws Exception {
 *     FooBLogic foo = getBean(&quot;/foo&quot;);
 *     // 邢 FooBLogic foo = (FooBLogic) applicationContext.getBean(&quot;/foo&quot;);
 *     BLogicResult result = foo.execute(null);
 *     {@link AssertUtils}.assertBLogicSuccess(result);
 *   }
 * }
 * 
 * 擾BeañC^[tFCXAOPݒ肵Ăꍇ́Aϐ̌^AOPΏۂ̃C^[tFCXɂKv܂B
 * 
 * 2. setter`autowire(by type)@
 * 擾BeañZb^[`ĂB
 * 
 * public FooTest extends {@link MockDaoInjectedTestCase} {
 *   private Foo foo;
 *   
 *   public void setFoo(Foo foo) {
 *     this.foo = foo;
 *   }
 *  
 *   public void testDoSomething()  throws Exception {
 *     int result = foo.doSomething();
 *     assertEquals(1, result);
 *   }
 * }
 * 
 * public FooBLogicTest extends {@link MockDaoInjectedTestCase} {
 *   private FooBLogic foo;
 *   
 *   public void setFoo(FooBLogic foo) {
 *     this.foo = foo;
 *   }
 *   
 *   public void testFoo() throws Exception {
 *     BLogicResult result = foo.execute(null);
 *     {@link AssertUtils}.assertBLogicSuccess(result);
 *   }
 * }
 * </pre>
 * 
 * <strong>̕@͈ȉ̏ꍇɂ͗pł܂B</strong>
 * 
 * <pre>
 * EBean`t@Cɓ^Bean`Ăꍇ
 * EAOPɂ{@link ApplicationContext}{@link java.lang.reflect.Proxy}NXƂĎ擾ꍇ
 * 
 * QueryDAO/UpdateDAO/StoredProcedureDAO/QueryRowHandleDAOݒ肳ꂽBean
 * MockDaoInjectedTestCasȇOō쐬ꂽDIRei擾ꍇAꂼ̃bNCWFNV܂B
 * CWFNVꂽebNgetMockXxxDAO()\bh܂protectedȃtB[hmockXxxDAOɂ擾ł܂B
 * (XxxɂQueryAUpdateAQueryRowHandleAStoredProcedureĂ͂܂܂)
 * 
 * MockUpdateDAO
 * 
 * public FooTest extends {@link MockDaoInjectedTestCase} { 
 *   
 *   public void testFoo()  throws Exception {
 *     FooBLogic foo = getBean(&quot;/foo&quot;);
 *     mockUpdateDAO.addResult(1);
 *         
 *     BLogicResult result = foo.execute(null);
 *     {@link AssertUtils}.assertBLogicSuccess(result);
 *   }
 * }
 * 
 * mock-dao-beans-override.propertiesōs㏑ݒ
 * </pre>
 * <table border=1>
 * <tr>
 * <th>L[</th>
 * <th>㏑łݒ</th>
 * <tr>
 * <td>queryDAO.id</td>
 * <td>MockQueryDAOBeanID</td>
 * </tr>
 * <tr>
 * <td>updateDAO.id</td>
 * <td>MockUpdateDAOBeanID</td>
 * </tr>
 * <tr>
 * <td>queryRowHandleDAO.id</td>
 * <td>MockQueryRowHandleDAOBeanID</td>
 * </tr>
 * <tr>
 * <td>spDAO.id</td>
 * <td>MockStoredProcedureDAOBeanID</td>
 * </tr>
 * </table>
 * 
 * <pre>
 * {NXpeXg͈ȉ̗lɏs܂
 * 
 * - O
 * -- WEBAPfBNg(ReLXg[g)̃NXpXւ̒ǉ({@link TestCaseUtils#getConfigLocationsForDaoTestCase(String[])})
 * -- Bean`t@CǂݍݑO({@link #beforeGetConfig()})
 * -- ftHgŎgpBean`t@Cǉ
 * -- ǂݍBean`t@Cǉ({@link #addConfigLocations(List)})
 * -- {@link ApplicationContext}쐬
 *  
 * - s
 * 
 * - ㏈
 * -- ebNDAȌ
 * 
 * </pre>
 */
public abstract class MockDaoInjectedTestCase extends
        AbstractDependencyInjectionSpringContextTests {

    /**
     * ftHgBean`t@Cǂݍނǂ
     */
    private boolean loadDefaultConfig = true;

    /**
     * bNQƌnDAOB
     */
    protected MockQueryDao mockQueryDAO;

    /**
     * bNXVnDAOB
     */
    protected MockUpdateDao mockUpdateDAO;

    /**
     * bNsf[^nhDAOB
     */
    protected MockQueryRowHandleDao mockQueryRowHandleDAO;

    /**
     * bNXgAhvV[WDAOB
     */
    protected MockStoredProcedureDao mockStoredProcedureDAO;

    @Override
    protected final String getConfigPath() {
        // WEBAPfBNgNXpXɒǉ܂
        String contextRoot = DefaultProperties.getValue(WEBAPP_PATH);
        if (logger.isInfoEnabled()) {
            logger.info("add " + contextRoot + " to classpath");
        }
        ClassLoaderUtils.addClassPath(contextRoot);
        beforeGetConfig();
        return super.getConfigPath();
    }

    /**
     * Bean`t@CpX擾OB
     * 
     * <pre>
     * DIRei쐬OɎs͂̃\bhI[oChĎsĂB
     * FJNDIANeBx[g铙
     * </pre>
     */
    protected void beforeGetConfig() {
        // ftHgł͉܂
    }

    /**
     * ǂݍBean`t@CpXǉ܂B
     * 
     * <pre>
     * Bean`t@CpXXgɒǉt@C̃pXadd悤I[o[ChĂB
     * </pre>
     * 
     * @param configLocations
     *            ǂݍBean`t@CXg
     */
    protected void addConfigLocations(List<String> configLocations) {
    }

    /**
     * Bean擾܂B
     * 
     * @param <T>
     *            擾Beaň^
     * @param name
     *            beanid܂name
     * @return 擾Bean
     */
    @SuppressWarnings("unchecked")
    public <T> T getBean(String name) {
        Assert.notNull(applicationContext, "applicationContext is null!");
        return (T) applicationContext.getBean(name);
    }

    @Override
    protected final String[] getConfigLocations() {
        List<String> configLocations = null;
        if (isLoadDefaultConfig()) {
            configLocations = TestCaseUtils
                    .getConfigLocationsForMockDaoInjectedTestCase(super
                            .getConfigLocations());
        } else {
            configLocations = new ArrayList<String>();
        }

        // qNXŒǉꍇ
        addConfigLocations(configLocations);

        if (logger.isInfoEnabled()) {
            logger.info("load configLocations = " + configLocations);
        }

        return configLocations.toArray(new String[configLocations.size()]);
    }

    @Override
    protected void onTearDown() throws Exception {
        super.onTearDown();
        if (mockQueryDAO != null) {
            mockQueryDAO.clear();
        }
        if (mockUpdateDAO != null) {
            mockUpdateDAO.clear();
        }
        if (mockQueryRowHandleDAO != null) {
            mockQueryRowHandleDAO.clear();
        }
        if (mockStoredProcedureDAO != null) {
            mockStoredProcedureDAO.clear();
        }
        ClassLoaderUtils.resetClassLoader();
    }

    /**
     * ftHgBean`t@Cǂݍނǂݒ肵܂B
     * 
     * @param loadDefaultConfig
     *            ftHgBean`t@Cǂݍނǂ
     */
    public void setLoadDefaultConfig(boolean loadDefaultConfig) {
        this.loadDefaultConfig = loadDefaultConfig;
    }

    /**
     * ftHgBean`t@Cǂݍނǂ擾܂B
     * 
     * @return ftHgBean`t@Cǂݍނǂ
     */
    public boolean isLoadDefaultConfig() {
        return loadDefaultConfig;
    }

    /**
     * bNQƌnDAOݒ肵܂B
     * 
     * @param mockQueryDAO
     *            bNQƌnDAO
     */
    public void setMockQueryDAO(MockQueryDao mockQueryDAO) {
        this.mockQueryDAO = mockQueryDAO;
    }

    /**
     * bNQƌnDAOԋp܂B
     * 
     * @return bNQƌnDAO
     */
    public MockQueryDao getMockQueryDAO() {
        return mockQueryDAO;
    }

    /**
     * bNXVnDAOԋp܂B
     * 
     * @return bNXVnDAO
     */
    public MockUpdateDao getMockUpdateDAO() {
        return mockUpdateDAO;
    }

    /**
     * bNXVnDAOݒ肵܂B
     * 
     * @param mockUpdateDAO
     *            bNXVnDAO
     */
    public void setMockUpdateDAO(MockUpdateDao mockUpdateDAO) {
        this.mockUpdateDAO = mockUpdateDAO;
    }

    /**
     * bNsf[^nhDAOԋp܂B
     * 
     * @return bNsf[^nhDAO
     */
    public MockQueryRowHandleDao getMockQueryRowHandleDAO() {
        return mockQueryRowHandleDAO;
    }

    /**
     * bNsf[^nhDAOݒ肵܂B
     * 
     * @param mockQueryRowHandleDAO
     *            bNsf[^nhDAO
     */
    public void setMockQueryRowHandleDAO(
            MockQueryRowHandleDao mockQueryRowHandleDAO) {
        this.mockQueryRowHandleDAO = mockQueryRowHandleDAO;
    }

    /**
     * bNXgAhvV[WDAOԋp܂B
     * 
     * @return bNXgAhvV[WDAO
     */
    public MockStoredProcedureDao getMockStoredProcedureDAO() {
        return mockStoredProcedureDAO;
    }

    /**
     * bNXgAhvV[WDAOݒ肵܂B
     * 
     * @param mockStoredProcedureDAO
     *            bNXgAhvV[WDAO
     */
    public void setMockStoredProcedureDAO(
            MockStoredProcedureDao mockStoredProcedureDAO) {
        this.mockStoredProcedureDAO = mockStoredProcedureDAO;
    }
}
