/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.util;

import org.springframework.util.Assert;

/**
 * ؂蕶ŕ񕪊sA{@link jp.terasoluna.fw.ex.unit.util.LineSplitter}̎NXłB<br>
 * RX^N^ŋ؂蕶w肵܂B
 */
public class DefaultLineSplitter implements LineSplitter {

    /**
     * ؂蕶
     */
    private final String delimiter;

    /**
     * RXgN^
     * 
     * @param delimiter
     *            ؂蕶
     */
    public DefaultLineSplitter(String delimiter) {
        super();
        this.delimiter = delimiter;
    }

    /**
     * sf[^𕪊ĔzԂ܂B<br>
     * RXgN^Ŏw肵؂蕶gpĕ񕪊sAzŕԋp܂B<br>
     * vf؂Ăꍇ͋󕶎ݒ肵܂B
     * 
     * @param line
     *            sf[^
     * @return z
     * @throws IllegalArgumentException
     *             null̏ꍇ
     */
    public String[] split(String line) {
        Assert.notNull(line);
        return line.split(delimiter, -1);
    }

}
