/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

/**
 * t@CANZX֘Ã[eBeBNXB
 * 
 */
class FileAccessUtil {
    
    private static final String FOLDER_KEY="unittest.folder.testdata";

    /**
     * w肳ꂽNXƓtH_ɒuĂt@C
     * FileIuWFNg擾B
     * 
     * @param cls ClassIuWFNg
     * @param fileName t@C
     * @return w肳ꂽt@CFileIuWFNgB
     * t@C݂ȂꍇnullԂB
     */
    public static File getResourceFile(Object obj, String fileName) {
        
        // IuWFNgk̏ꍇ͕ԂB
        if (obj == null) {
            return null;
        }
        
        // t@CkA󕶎̏ꍇ̓kԂB
        if ((fileName == null) || ("".equals(fileName))) {
            return null;
        }
        
        // w肳ꂽt@CURL擾B
        // "file://c:/folder/filename"̂悤URLB
        URL url = obj.getClass().getResource(fileName);

        // URLkȂ΃kԂB
        if (url == null) {
            return null;
        }
        
        // URLURI𐶐B
        // URISyntaxException邱Ƃ͎゠蓾Ȃ̂ŁAcatchȉ
        // R[h̓kԂɂĂB
        URI uri = null;
        try {
            uri = new URI(url.toString());
        } catch (URISyntaxException e) {
            return null;
        }
        
        // FileIuWFNg𐶐ĕԂB
        return new File(uri);
    }

    /**
     * eXgf[^tH_ɒuꂽt@CFileIuWFNg擾B
     * 
     * @param fileName t@C
     * @return w肳ꂽt@CFileIuWFNgB
     */
    public static File getFile(String fileName) {

        // t@CkA󕶎̏ꍇ̓kԂB
        if ((fileName == null) || ("".equals(fileName))) {
            return null;
        }

        // wt@CFileIuWFNgԂB                        
        String folderName = UTLibConfig.getProperty(FOLDER_KEY);
        if (folderName == null || "".equals(folderName)) {
            folderName = ".";
        }
        return new File(folderName + "/" + fileName);
    }


}
