/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import jp.terasoluna.fw.ex.unit.exception.PopulationFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateConvertUtils {
    public static Date convertDateValue(Date d, Class<? extends Date> propertyType) throws PopulationFailedException {
        Date value = null;
        if (d != null) {
            if (d.getClass() == propertyType) {
                value = d;
            } else if (Date.class == propertyType) {
                value = new Date(d.getTime());
            } else if (java.sql.Date.class == propertyType) {
                value = DateConvertUtils.utilDateToSqlDate(d);
            } else if (Timestamp.class == propertyType) {
                value = new Timestamp(d.getTime());
            } else if (Time.class == propertyType) {
                value = new Time(d.getTime());
            } else {
                throw new PopulationFailedException(propertyType + " is not supported to populate");
            }
        }
        return value;
    }

    public static java.sql.Date utilDateToSqlDate(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        java.sql.Date sqlDate = new java.sql.Date(cal.getTimeInMillis());
        return sqlDate;
    }
}

