/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.action;

import static org.junit.Assert.assertEquals;

import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.ex.exception.ApplicationException;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ModuleConfig;
import org.easymock.classextension.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ApplicationExceptionHandlerTest {

    private ApplicationExceptionHandler applicationExceptionHandler;

    @Before
    public void setUp() throws Exception {
        applicationExceptionHandler = new ApplicationExceptionHandler();
    }

    @After
    public void tearDown() throws Exception {
        applicationExceptionHandler = null;
    }

    @Test
    public final void testGetLocalActionForward() {
        String forwardName = "forwardName";
        ApplicationException applicationException = new ApplicationException(
                null, forwardName);
        ActionMapping actionMappingMock = EasyMock
                .createMock(ActionMapping.class);
        ActionForward expectedActionForward = new ActionForward();
        EasyMock.expect(actionMappingMock.findForward(forwardName)).andReturn(
                expectedActionForward);
        EasyMock.replay(actionMappingMock);
        ActionForward actualActionForward = applicationExceptionHandler
                .getActionForward(applicationException, null,
                        actionMappingMock, null);
        assertEquals(expectedActionForward, actualActionForward);
        EasyMock.verify(actionMappingMock);
    }

    @Test
    public final void testGetGlobalActionForward() {
        String forwardName = "forwardName";
        ApplicationException applicationException = new ApplicationException(
                null, forwardName);
        ActionMapping actionMappingMock = EasyMock
                .createMock(ActionMapping.class);
        EasyMock.expect(actionMappingMock.findForward(forwardName)).andReturn(
                null);
        HttpServletRequest httpServletRequestMock = EasyMock
                .createMock(HttpServletRequest.class);
        ModuleConfig moduleConfigMock = EasyMock.createMock(ModuleConfig.class);
        EasyMock
                .expect(httpServletRequestMock.getAttribute(Globals.MODULE_KEY))
                .andReturn(moduleConfigMock);
        ActionForward expectedActionForward = new ActionForward();
        EasyMock.expect(moduleConfigMock.findForwardConfig(forwardName))
                .andReturn(expectedActionForward);
        EasyMock.replay(actionMappingMock, httpServletRequestMock,
                moduleConfigMock);
        ActionForward actualActionForward = applicationExceptionHandler
                .getActionForward(applicationException, null,
                        actionMappingMock, httpServletRequestMock);
        assertEquals(expectedActionForward, actualActionForward);
        EasyMock.verify(actionMappingMock, httpServletRequestMock,
                moduleConfigMock);
    }

    @Test
    public final void testGetActionForwardNotApplicationException() {
        Exception exception = new Exception();
        ExceptionConfig exceptionConfig = EasyMock
                .createMock(ExceptionConfig.class);
        String forwardPath = "forwardPath";
        EasyMock.expect(exceptionConfig.getPath()).andReturn(forwardPath)
                .times(2);
        EasyMock.replay(exceptionConfig);
        ActionForward actionForward = applicationExceptionHandler
                .getActionForward(exception, exceptionConfig, null, null);
        assertEquals(forwardPath, actionForward.getPath());
        EasyMock.verify(exceptionConfig);
    }

    @Test
    public final void testCannotFindForward() {
        String forwardName = "forwardName";
        ApplicationException applicationException = new ApplicationException(
                null, forwardName);
        ActionMapping actionMappingMock = EasyMock
                .createMock(ActionMapping.class);
        EasyMock.expect(actionMappingMock.findForward(forwardName)).andReturn(
                null);
        ActionForward expectedActionForward = new ActionForward();
        EasyMock.expect(actionMappingMock.getInputForward()).andReturn(
                expectedActionForward);
        HttpServletRequest httpServletRequestMock = EasyMock
                .createMock(HttpServletRequest.class);
        ModuleConfig moduleConfigMock = EasyMock.createMock(ModuleConfig.class);
        EasyMock
                .expect(httpServletRequestMock.getAttribute(Globals.MODULE_KEY))
                .andReturn(moduleConfigMock);
        EasyMock.expect(moduleConfigMock.findForwardConfig(forwardName))
                .andReturn(null);

        ExceptionConfig exceptionConfigMock = EasyMock
                .createMock(ExceptionConfig.class);
        EasyMock.expect(exceptionConfigMock.getPath()).andReturn(null);

        EasyMock.replay(actionMappingMock, httpServletRequestMock,
                moduleConfigMock, exceptionConfigMock);
        ActionForward actualActionForward = applicationExceptionHandler
                .getActionForward(applicationException, exceptionConfigMock,
                        actionMappingMock, httpServletRequestMock);
        assertEquals(expectedActionForward, actualActionForward);
        EasyMock.verify(actionMappingMock, httpServletRequestMock,
                moduleConfigMock, exceptionConfigMock);
    }
}
