/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.io.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;
import jp.terasoluna.fw.ex.unit.io.OutputTarget;
import jp.terasoluna.fw.ex.unit.util.DefaultLineJoiner;
import jp.terasoluna.fw.ex.unit.util.LineJoiner;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;

/**
 * ̓\[XIuWFNgCSVt@Cɏo͂܂B
 * 
 * <br>
 * RXgN^܂setterɂĈȉ̃p[^w肵܂B<br>
 * <table border=1>
 * <tr>
 * <th>p[^</th>
 * <th></th>
 * <th>ݒӏ</th>
 * <th>K{</th>
 * </tr>
 * <tr>
 * <td>path</td>
 * <td>o͂CSVt@C</td>
 * <td>RXgN^</td>
 * <td></td>
 * </tr>
 * <tr>
 * <td>encoding</td>
 * <td>o͂CSVt@C̃GR[fBOBftHgMS932łB</td>
 * <td>RXgN^܂setter</td>
 * <td>&nbsp;</td>
 * </tr>
 * <tr>
 * <td>dateFormat</td>
 * <td>o͂sIuWFNg{@link java.util.Date}
 * NX(gNX܂)̃tB[hꍇA̒lo͂ttH[}bgBftHǵuyyyy-MM-dd HH:mm:ssvłB</td>
 * <td>setter</td>
 * <td>&nbsp;</td>
 * </tr>
 * <tr>
 * <td>lineJoiner</td>
 * <td>sIuWFNg̊etB[h̒lCSVt@Cs̕Ɍ鏈BftHgł{@link DefaultLineJoiner}
 * gpApJ}؂蕶ɂČ܂B</td>
 * <td>setter</td>
 * <td>&nbsp;</td>
 * </tr>
 * </table>
 */
public class CsvTarget<T> implements OutputTarget<T> {
    private PrintWriter writer;
    private String[] header;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private SimpleDateFormat format = new SimpleDateFormat(dateFormat);
    private LineJoiner lineJoiner = new DefaultLineJoiner(",");

    /**
     * RXgN^BiGR[fBOMS932j
     * 
     * @param path
     *            o͂CSVt@C
     * @throws UTRuntimeException
     *             t@CރC^[̐IOOꍇ
     */
    public CsvTarget(String path) throws UTRuntimeException {
        this(path, "MS932");
    }

    /**
     * RXgN^B
     * 
     * @param path
     *            o͂CSVt@C
     * @param encoding
     *            o͂CSVt@C̃GR[fBO
     * @throws UTRuntimeException
     *             t@CރC^[̐IOOꍇ
     */
    public CsvTarget(String path, String encoding) throws UTRuntimeException {
        try {
            writer = new PrintWriter(new File(path), encoding);
        } catch (IOException e) {
            throw new UTRuntimeException(e);
        }
    }

    public void writeHeader(String[] header) {
        this.header = header;
        writer.println(lineJoiner.join(header));
    }

    public void write(T obj) {
        Assert.notNull(header);
        BeanWrapper beanWrapper = new BeanWrapperImpl(obj);
        try {
            List<String> lineData = new ArrayList<String>();
            for (int i = 0; i < header.length; i++) {
                String propertyName = header[i];
                if (beanWrapper.isReadableProperty(propertyName)) {
                    Object o = beanWrapper.getPropertyValue(propertyName);
                    if (o instanceof Date) {
                        // t^̏ꍇ̓tH[}bgď
                        lineData.add(format.format((Date) o));
                    } else if (o == null) {
                        // null̏ꍇ͋󕶎Ŗ߂
                        lineData.add("");
                    } else {
                        lineData.add(String.valueOf(o));
                    }
                } else {
                    // ݂ȂtB[h͋󕶎Ŗ߂
                    lineData.add("");
                }
            }
            String[] line = lineData.toArray(new String[lineData.size()]);
            writer.println(lineJoiner.join(line));
            writer.flush();
        } catch (Exception e) {
            throw new UTRuntimeException(e);
        }
    }

    public void close() {
        writer.close();
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        this.format = new SimpleDateFormat(dateFormat);
    }

    public String getDateFormat() {
        return dateFormat;
    }

    /**
     * @return lineJoiner
     */
    public LineJoiner getLineJoiner() {
        return lineJoiner;
    }

    /**
     * @param lineJoiner
     *            Zbg lineJoiner
     */
    public void setLineJoiner(LineJoiner lineJoiner) {
        this.lineJoiner = lineJoiner;
    }

}
