/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.codelist;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.sql.DataSource;

import jp.terasoluna.utlib.MockDataSource;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;

/**
 * {@link jp.terasoluna.fw.web.codelist.DBCodeListLoader} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * R[hXg̏f[^x[XpčsNX<br>
 * EO<br>
 * Eutlib.confpӂDBڑLq邱ƁB<br>
 * Ecreate_dbcodetest.sqlŐݒ肳DB񂪂炩ߐݒ肳ĂKvB<br>
 * ̃t@C̒ł͈ȉ̂悤DB쐬AeXgp^[ɉL̗vfDBɐݒ肷B<br>
 * DB̖OFDBCODETEST<br>
 * JFKEY, VALUE<br>
 * vfF <br>
 * iPjKEY = '1' , VALUE = 'abc'<br>
 * iQjKEY = '2' , VALUE = 'xyz'<br>
 * iRjKEY = '3' , VALUE = ''
 * <p>
 * 
 * @see jp.terasoluna.fw.web.codelist.DBCodeListLoader
 */
public class DBCodeListLoaderTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DBCodeListLoaderTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        
        // DBf[^ݒ       
        UTUtil.deleteAll("DBCODETEST");
        String[][] data = { {"KEY", "VALUE","LANGUAGE","COUNTRY","VARIANT"},
                {"001", "val_1",null,null,null},
                {"002", "val_2","ja",null,null},
                {"003", "val_3","ja",null,null},
                {"004", "val_4","en",null,null},
                {"005", "val_5","en",null,null},
                {"006", "val_6","en","GB",null},
                {"007", "val_7","en","GB",null},
                {"008", "val_8","en","US",null},
                {"009", "val_9","en","US",null},
                {"010", "val_10","en","US","us01"},
                {"011", "val_11","en","US","us01"},
                {"012", "val_12","en","US","us02"},
                {"013", "val_13","en","US","us02"}};
        UTUtil.setData("DBCODETEST", data);
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        
        // DBf[^폜       
        UTUtil.deleteAll("DBCODETEST");
        
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DBCodeListLoaderTest(String name) {
        super(name);
    }

    /**
     * testLoad01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() localeMap:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) loadCodeList():sȂB<br>
     *         
     * <br>
     * codeLists݂ꍇ͉I邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoad01() throws Exception {
        // O
        DBCodeListLoaderImpl01 loader = new DBCodeListLoaderImpl01();
        
        loader.localeMap = new HashMap<Locale, List<CodeBean>>();
        
        // eXg{
        loader.load();

        // 
        assertFalse(loader.isLoadCodeListIsCalled());
    }

    /**
     * testLoad02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() localeMap:null<br>
     *         
     * <br>
     * ҒlF(ԕω) loadCodeList():sB<br>
     *         
     * <br>
     * codeLists݂ȂꍇloadCodeList()Ăяo邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoad02() throws Exception {
        // O
        DBCodeListLoaderImpl01 loader = new DBCodeListLoaderImpl01();
        loader.localeMap = null;
        
        // eXg{
        loader.load();

        // 
        assertTrue(loader.isLoadCodeListIsCalled());
    }

    /**
     * testReload01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() localeMap:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) loadCodeList():sB<br>
     *         
     * <br>
     * ̃\bhĂ΂loadCodeList()Ă΂邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testReload01() throws Exception {
        // O
        DBCodeListLoaderImpl01 loader = new DBCodeListLoaderImpl01();
        loader.localeMap = new HashMap<Locale, List<CodeBean>>();
        
        // eXg{
        loader.reload();

        // 
        assertTrue(loader.isLoadCodeListIsCalled());
    }

    /**
     * testReload02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() localeMap:null<br>
     *         
     * <br>
     * ҒlF(ԕω) loadCodeList():sB<br>
     *         
     * <br>
     * codeListsnull̏ꍇłloadCodeList()Ă΂邱ƂmFBisynchronizedɌĂԁj
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testReload02() throws Exception {
        // O
        DBCodeListLoaderImpl01 loader = new DBCodeListLoaderImpl01();
        loader.localeMap = null;
        
        // eXg{
        loader.reload();

        // 
        assertTrue(loader.isLoadCodeListIsCalled());
    }

    /**
     * testLoadCodeList01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:null<br>
     *         () sql:SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '1' AND KEY = '3'<br>
     *         
     * <br>
     * ҒlF(ԕω) O:InvalidDataAccessApiUsageException<br>
     *                    bZ[WFProperty 'dataSource' is required<br>
     *         
     * <br>
     * dataSourcenull̏ꍇInvalidDataAccessApiUsageException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList01() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        UTUtil.setPrivateField(loader, "sql",
            "SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '1' AND KEY = '3'");
        loader.localeMap = null;
        UTUtil.setPrivateField(loader, "dataSource", null);
        
        // eXg{
        try {
            loader.loadCodeList();
        } catch (InvalidDataAccessApiUsageException e) {
            // 
            assertEquals("Property 'dataSource' is required", e.getMessage());
            return;
        }
        fail();
    }
   
    /**
     * testLoadCodeList02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * Ғl: ͒lF() localeMap:null<br>
     *         () dataSource:not null<br>
     *         () sql:SELECT KEY,VALUE FROM DBCODETEST ORDER BY KEY ASC<br>
     *         
     * <br>
     * ȉ̃R[hXgݒ肳邱
     * EP[: ja (ftHgP[)
     * 001 val_1
     * 002 val_2
     * 003 val_3
     * 004 val_4
     * 005 val_5
     * 006 val_6
     * 007 val_7
     * 008 val_8
     * 009 val_9
     * 010 val_10
     * 011 val_11
     * 012 val_12
     * 013 val_13
     *         
     * <br>
     * sqlŃP[擾ȂꍇAftHgP[ɃR[hXg
     * ݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList02() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql",
            "SELECT KEY,VALUE FROM DBCODETEST ORDER BY KEY ASC");
        
        // eXg{
        loader.loadCodeList();
        
        // 
        Map<Locale, List<CodeBean>> result = loader.localeMap;
        // ftHgP[̃R[hXgQ
        List<CodeBean> codeList = result.get(loader.defaultLocale);
        assertEquals(13, codeList.size());
        
        assertEquals("001", codeList.get(0).getId());
        assertEquals("val_1", codeList.get(0).getName());
        
        assertEquals("002", codeList.get(1).getId());
        assertEquals("val_2", codeList.get(1).getName());
        
        assertEquals("003", codeList.get(2).getId());
        assertEquals("val_3", codeList.get(2).getName());
        
        assertEquals("004", codeList.get(3).getId());
        assertEquals("val_4", codeList.get(3).getName());
        
        assertEquals("005", codeList.get(4).getId());
        assertEquals("val_5", codeList.get(4).getName());
        
        assertEquals("006", codeList.get(5).getId());
        assertEquals("val_6", codeList.get(5).getName());
        
        assertEquals("007", codeList.get(6).getId());
        assertEquals("val_7", codeList.get(6).getName());
        
        assertEquals("008", codeList.get(7).getId());
        assertEquals("val_8", codeList.get(7).getName());
        
        assertEquals("009", codeList.get(8).getId());
        assertEquals("val_9", codeList.get(8).getName());
        
        assertEquals("010", codeList.get(9).getId());
        assertEquals("val_10", codeList.get(9).getName());
        
        assertEquals("011", codeList.get(10).getId());
        assertEquals("val_11", codeList.get(10).getName());
        
        assertEquals("012", codeList.get(11).getId());
        assertEquals("val_12", codeList.get(11).getName());
        
        assertEquals("013", codeList.get(12).getId());
        assertEquals("val_13", codeList.get(12).getName());
    }
    
    /**
     * testLoadCodeList03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lF() localeMap:null<br>
     *         () dataSource:not null<br>
     *         () sql:SELECT KEY,VALUE,LANGUAGE 
     *                                    FROM DBCODETEST ORDER BY KEY ASC<br>
     *         
     * <br>
     * Ғl: ȉ̃R[hXgݒ肳邱
     * EP[: ja (ftHgP[)
     * 001 val_1
     * 002 val_2
     * 003 val_3
     * EP[: en
     * 004 val_4
     * 005 val_5
     * 006 val_6
     * 007 val_7
     * 008 val_8
     * 009 val_9
     * 010 val_10
     * 011 val_11
     * 012 val_12
     * 013 val_13    
     * <br>
     * sqlŃP[擾ȂꍇAftHgP[ɃR[hXg
     * ݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList03() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql",
            "SELECT KEY,VALUE,LANGUAGE FROM DBCODETEST ORDER BY KEY ASC");
        
        // eXg{
        loader.loadCodeList();
        
        // 
        Map<Locale, List<CodeBean>> result = loader.localeMap;
        // P[: ja
        List<CodeBean> codeList = result.get(new Locale("ja"));
        assertEquals(3, codeList.size());
        
        assertEquals("001", codeList.get(0).getId());
        assertEquals("val_1", codeList.get(0).getName());
        
        assertEquals("002", codeList.get(1).getId());
        assertEquals("val_2", codeList.get(1).getName());
        
        assertEquals("003", codeList.get(2).getId());
        assertEquals("val_3", codeList.get(2).getName());
        
        // P[: en
        codeList = result.get(new Locale("en"));
        assertEquals(10, codeList.size());
        
        assertEquals("004", codeList.get(0).getId());
        assertEquals("val_4", codeList.get(0).getName());
        
        assertEquals("005", codeList.get(1).getId());
        assertEquals("val_5", codeList.get(1).getName());
        
        assertEquals("006", codeList.get(2).getId());
        assertEquals("val_6", codeList.get(2).getName());
        
        assertEquals("007", codeList.get(3).getId());
        assertEquals("val_7", codeList.get(3).getName());
        
        assertEquals("008", codeList.get(4).getId());
        assertEquals("val_8", codeList.get(4).getName());
        
        assertEquals("009", codeList.get(5).getId());
        assertEquals("val_9", codeList.get(5).getName());
        
        assertEquals("010", codeList.get(6).getId());
        assertEquals("val_10", codeList.get(6).getName());
        
        assertEquals("011", codeList.get(7).getId());
        assertEquals("val_11", codeList.get(7).getName());
        
        assertEquals("012", codeList.get(8).getId());
        assertEquals("val_12", codeList.get(8).getName());
        
        assertEquals("013", codeList.get(9).getId());
        assertEquals("val_13", codeList.get(9).getName());
    }
    
    /**
     * testLoadCodeList04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lF() localeMap:null<br>
     *         () dataSource:not null<br>
     *         () sql:SELECT KEY,VALUE,LANGUAGE,COUNTRY
     *                                    FROM DBCODETEST ORDER BY KEY ASC<br>
     *         
     * <br>
     * Ғl: ȉ̃R[hXgݒ肳邱
     * EP[: ja (ftHgP[)
     * 001 val_1
     * 002 val_2
     * 003 val_3
     * 
     * EP[: en
     * 004 val_4
     * 005 val_5
     * 
     * EP[: en_GB
     * 006 val_6
     * 007 val_7
     * 
     * EP[: en_US
     * 008 val_8
     * 009 val_9
     * 010 val_10
     * 011 val_11
     * 012 val_12
     * 013 val_13         
     * <br>
     * sqlŃP[擾ȂꍇAftHgP[ɃR[hXg
     * ݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList04() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql",
            "SELECT KEY,VALUE,LANGUAGE,COUNTRY FROM DBCODETEST ORDER BY KEY ASC");
        
        // eXg{
        loader.loadCodeList();
        
        // 
        Map<Locale, List<CodeBean>> result = loader.localeMap;
        // P[: ja
        List<CodeBean> codeList = result.get(new Locale("ja"));
        assertEquals(3, codeList.size());
        
        assertEquals("001", codeList.get(0).getId());
        assertEquals("val_1", codeList.get(0).getName());
        
        assertEquals("002", codeList.get(1).getId());
        assertEquals("val_2", codeList.get(1).getName());
        
        assertEquals("003", codeList.get(2).getId());
        assertEquals("val_3", codeList.get(2).getName());
        
        // P[: en
        codeList = result.get(new Locale("en"));
        assertEquals(2, codeList.size());
        
        assertEquals("004", codeList.get(0).getId());
        assertEquals("val_4", codeList.get(0).getName());
        
        assertEquals("005", codeList.get(1).getId());
        assertEquals("val_5", codeList.get(1).getName());
        
        // P[: en_GB
        codeList = result.get(new Locale("en", "GB"));
        assertEquals(2, codeList.size());
        
        assertEquals("006", codeList.get(0).getId());
        assertEquals("val_6", codeList.get(0).getName());
        
        assertEquals("007", codeList.get(1).getId());
        assertEquals("val_7", codeList.get(1).getName());
        
        // P[: en_US
        codeList = result.get(new Locale("en", "US"));
        assertEquals(6, codeList.size());
        
        assertEquals("008", codeList.get(0).getId());
        assertEquals("val_8", codeList.get(0).getName());
        
        assertEquals("009", codeList.get(1).getId());
        assertEquals("val_9", codeList.get(1).getName());
        
        assertEquals("010", codeList.get(2).getId());
        assertEquals("val_10", codeList.get(2).getName());
        
        assertEquals("011", codeList.get(3).getId());
        assertEquals("val_11", codeList.get(3).getName());
        
        assertEquals("012", codeList.get(4).getId());
        assertEquals("val_12", codeList.get(4).getName());
        
        assertEquals("013", codeList.get(5).getId());
        assertEquals("val_13", codeList.get(5).getName());
    }
    
    /**
     * testLoadCodeList05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lF() localeMap:null<br>
     *         () dataSource:not null<br>
     *         () sql:SELECT KEY,VALUE,LANGUAGE,COUNTRY,VARIANT
     *                                    FROM DBCODETEST ORDER BY KEY ASC<br>
     *         
     * <br>
     * Ғl: ȉ̃R[hXgݒ肳邱
     * EP[: ja (ftHgP[)
     * 001 val_1
     * 002 val_2
     * 003 val_3
     * 
     * EP[: en
     * 004 val_4
     * 005 val_5
     * 
     * EP[: en_GB
     * 006 val_6
     * 007 val_7
     * 
     * EP[: en_US
     * 008 val_8
     * 009 val_9
     * 
     * EP[: en_US_us01

     * 010 val_10
     * 011 val_11
     * 
     * EP[: en_US_us02
     * 012 val_12
     * 013 val_13         
     * <br>
     * sqlŃP[擾ȂꍇAftHgP[ɃR[hXg
     * ݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList05() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql",
            "SELECT KEY,VALUE,LANGUAGE,COUNTRY,VARIANT FROM DBCODETEST ORDER BY KEY ASC");
        
        // eXg{
        loader.loadCodeList();
        
        // 
        Map<Locale, List<CodeBean>> result = loader.localeMap;
        // P[: ja
        List<CodeBean> codeList = result.get(new Locale("ja"));
        assertEquals(3, codeList.size());
        
        assertEquals("001", codeList.get(0).getId());
        assertEquals("val_1", codeList.get(0).getName());
        
        assertEquals("002", codeList.get(1).getId());
        assertEquals("val_2", codeList.get(1).getName());
        
        assertEquals("003", codeList.get(2).getId());
        assertEquals("val_3", codeList.get(2).getName());
        
        // P[: en
        codeList = result.get(new Locale("en"));
        assertEquals(2, codeList.size());
        
        assertEquals("004", codeList.get(0).getId());
        assertEquals("val_4", codeList.get(0).getName());
        
        assertEquals("005", codeList.get(1).getId());
        assertEquals("val_5", codeList.get(1).getName());
        
        // P[: en_GB
        codeList = result.get(new Locale("en", "GB"));
        assertEquals(2, codeList.size());
        
        assertEquals("006", codeList.get(0).getId());
        assertEquals("val_6", codeList.get(0).getName());
        
        assertEquals("007", codeList.get(1).getId());
        assertEquals("val_7", codeList.get(1).getName());
        
        // P[: en_US
        codeList = result.get(new Locale("en", "US"));
        assertEquals(2, codeList.size());
        
        assertEquals("008", codeList.get(0).getId());
        assertEquals("val_8", codeList.get(0).getName());
        
        assertEquals("009", codeList.get(1).getId());
        assertEquals("val_9", codeList.get(1).getName());
        
        // P[: en_US_us01
        codeList = result.get(new Locale("en", "US", "us01"));
        assertEquals(2, codeList.size());
        
        assertEquals("010", codeList.get(0).getId());
        assertEquals("val_10", codeList.get(0).getName());
        
        assertEquals("011", codeList.get(1).getId());
        assertEquals("val_11", codeList.get(1).getName());
        
        // P[: en_US_us02
        codeList = result.get(new Locale("en", "US", "us02"));
        assertEquals(2, codeList.size());
        
        assertEquals("012", codeList.get(0).getId());
        assertEquals("val_12", codeList.get(0).getName());
        
        assertEquals("013", codeList.get(1).getId());
        assertEquals("val_13", codeList.get(1).getName());
    }

    /**
     * testLoadCodeList06()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() localeMap:null<br>
     *         () dataSource:not null<br>
     *         () sql:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:InvalidDataAccessApiUsageException<br>
     *                    bZ[WFProperty 'sql' is required<br>
     *         
     * <br>
     * SQL݂ȂꍇAInvalidDataAccessApiUsageException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList06() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        loader.localeMap = null;
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", null);

        // eXg{
        try {
            loader.loadCodeList();
        } catch (InvalidDataAccessApiUsageException e) {
            // 
            assertEquals("Property 'sql' is required", e.getMessage());
            return;
        }
        fail();
    }

    /**
     * testLoadCodeList07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() localeMap:null<br>
     *         () dataSource:not null<br>
     *         () sql:SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '200' ORDER BY KEY ASC<br>
     *         () sqlł̎擾:ʂ0<br>
     *         
     * <br>
     * ҒlF(ԕω) codeLists:List<br>
     *         
     * <br>
     * ʂ0̏ꍇAListo^邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList07() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        loader.localeMap = null;
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '200' ORDER BY KEY ASC");

        // eXg{
        loader.loadCodeList();

        // 
        assertTrue(loader.localeMap.isEmpty());
    }

    /**
     * testLoadCodeList08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() localeMap<br>
     *         () defaultLocale:Locale.JAPANESE;
     *         () dataSource:not null<br>
     *         () sql:SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '001'<br>
     *         () sqlł̎擾:ʂ1<br>
     *         
     * <br>
     * ҒlF(ԕω) codeLists:ʂ1ݒ肳B<br>
     *                    codeLists0ԖځFid = 001,name = 'val_1'<br>
     *         
     * <br>
     * ʂP̏ꍇɐɓo^邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList08() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '001'");

        // eXg{
        loader.loadCodeList();

        // 
        Map<Locale, List<CodeBean>> result = loader.localeMap;
        List<CodeBean> codeList = result.get(Locale.JAPANESE);
        assertEquals(1, result.size());
        assertEquals("001", codeList.get(0).getId());
        assertEquals("val_1", codeList.get(0).getName());
    }

    /**
     * testLoadCodeList09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:not null<br>
     *         () sql:SELECT KEY,VALUE FROM DBCODETEST WHERE KEY <= '3' ORDER BY KEY ASC<br>
     *         () sqlł̎擾:ʂ3<br>
     *         
     * <br>
     * ҒlF(ԕω) codeLists:ʂ3ݒ肳B<br>
     *                    codeLists0ԖځFid = 1,name = 'abc'<br>
     *                    codeLists1ԖځFid = 2,name = 'xyz'<br>
     *                    codeLists2ԖځFid = 3,name = ''<br>
     *         
     * <br>
     * ʂȐꍇɐɓo^邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList09() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "SELECT KEY,VALUE FROM DBCODETEST WHERE KEY IN ('001', '002' , '003') ORDER BY KEY ASC");

        // eXg{
        loader.loadCodeList();

        // 
        Map<Locale, List<CodeBean>> result = loader.localeMap;
        List<CodeBean> codeList = result.get(Locale.JAPANESE);
        assertEquals(3, codeList.size());
        assertEquals("001", codeList.get(0).getId());
        assertEquals("val_1", codeList.get(0).getName());
        assertEquals("002", codeList.get(1).getId());
        assertEquals("val_2", codeList.get(1).getName());
        assertEquals("003", codeList.get(2).getId());
        assertEquals("val_3", codeList.get(2).getName());
    }

    /**
     * testLoadCodeList10()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() localeMap<br>
     *         () dataSource:not null<br>
     *         () sql:SELECT KEY,VALUE FROM NODB<br>
     *         () sqlł̎擾:e[u݂Ȃ<br>
     *         
     * <br>
     * ҒlF(ԕω) O:BadSqlGrammarException<br>
     *                    bvꂽOFSQLException<br>
     *         
     * <br>
     * SQLŎw肵e[u݂ȂꍇBadSqlGrammarException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList10() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        loader.localeMap = null;
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "SELECT KEY,VALUE FROM NODB");

        // eXg{
        try {
            loader.loadCodeList();
        } catch (BadSqlGrammarException e) {
            // 
            assertTrue(e.getCause() instanceof SQLException);
            return;
        } finally {
            // PostgreSQL̏ꍇABadSqlGrammarExceptionꍇA
            // [obNsȂƁAȍ~̃eXgɉe^
        	UTUtil.getConnection().rollback();
        }
        fail();
    }

    /**
     * testLoadCodeList11()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() localeMap:null<br>
     *         () dataSource:not null<br>
     *         () sql:""<br>
     *         
     * <br>
     * ҒlF(ԕω) O:UncategorizedSQLException<br>
     *         
     * <br>
     * SQL󕶎̏ꍇUncategorizedSQLException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList11() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        loader.localeMap = null;
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "");

        // eXg{
        try {
            loader.loadCodeList();
        } catch (UncategorizedSQLException e) {
            // 
            // Oraclȅꍇ
            assertTrue(e.getCause() instanceof SQLException);
            return;
        } catch (DataIntegrityViolationException e) {
            // 
            // Postgres̏ꍇ
            assertTrue(e.getCause() instanceof SQLException);
            return;
        } 
        fail();
    }

    /**
     * testLoadCodeList12()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:not null<br>
     *         () sql:UPDATE DBCODETEST SET VALUE = 'test'<br>
     *         
     * <br>
     * ҒlF(ԕω) O:DataAccessException<br>
     *
     * <br>
     * SQLSELECTł͂ȂUPDATEsꂽꍇDataAccessException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList12() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        loader.localeMap = null;
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "UPDATE DBCODETEST SET VALUE = 'test'");

        // eXg{
        try {
            loader.loadCodeList();

        } catch (DataAccessException e) {
            // 
            assertTrue(e.getCause() instanceof SQLException); 
            return;
        }
        fail();
    }

    /**
     * testLoadCodeList13()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:not null<br>
     *         () sql:aaaaa<br>
     *         
     * <br>
     * ҒlF(ԕω) O:BadSqlGrammarException<br>
     *                    bvꂽOFSQLException<br>
     *         
     * <br>
     * SQL̕@ԈĂꍇABadSqlGrammarException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList13() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        loader.localeMap = null;
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "aaaaa");

        // eXg{
        try {
            loader.loadCodeList();
        } catch (BadSqlGrammarException e) {
            // 
            assertTrue(e.getCause() instanceof SQLException);
            return;
        } finally {
        	// PostgreSQL̏ꍇABadSqlGrammarExceptionꍇA
            // [obNsȂƁAȍ~̃eXgɉe^
        	UTUtil.getConnection().rollback();
        }
        fail();
    }
    
    /**
     * testCreateLocale01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lFLocaleCodeBean
     *         language = ""
     *         country = ""
     *         variant = ""
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: LOCALE.JAPANESE
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale01() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        
        LocaleCodeBean lcb = new LocaleCodeBean();
        lcb.setLanguage(null);
        lcb.setCountry(null);
        lcb.setVariant(null);
        
        // eXg{
        Locale result = loader.createLocale(lcb);
        
        // 
        assertEquals(Locale.JAPANESE, result);
    }
    
    /**
     * testCreateLocale02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lFLocaleCodeBean
     *         language = ""
     *         country = ""
     *         variant = "us01"
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: LOCALE.JAPANESE
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale02() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        
        LocaleCodeBean lcb = new LocaleCodeBean();
        lcb.setLanguage(null);
        lcb.setCountry(null);
        lcb.setVariant("us01");
        
        // eXg{
        Locale result = loader.createLocale(lcb);
        
        // 
        assertEquals(Locale.JAPANESE, result);
    }
    
    /**
     * testCreateLocale03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lFLocaleCodeBean
     *         language = ""
     *         country = "US"
     *         variant = ""
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: LOCALE.JAPANESE
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale03() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        
        LocaleCodeBean lcb = new LocaleCodeBean();
        lcb.setLanguage(null);
        lcb.setCountry("US");
        lcb.setVariant(null);
        
        // eXg{
        Locale result = loader.createLocale(lcb);
        
        // 
        assertEquals(Locale.JAPANESE, result);
    }
    /**
     * testCreateLocale04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lFLocaleCodeBean
     *         language = ""
     *         country = "US"
     *         variant = "us01"
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: LOCALE.JAPANESE
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale04() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        
        LocaleCodeBean lcb = new LocaleCodeBean();
        lcb.setLanguage(null);
        lcb.setCountry("US");
        lcb.setVariant("us01");
        
        // eXg{
        Locale result = loader.createLocale(lcb);
        
        // 
        assertEquals(Locale.JAPANESE, result);
    }
    /**
     * testCreateLocale05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lFLocaleCodeBean
     *         language = "en"
     *         country = ""
     *         variant = ""
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: en
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale05() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        
        LocaleCodeBean lcb = new LocaleCodeBean();
        lcb.setLanguage("en");
        lcb.setCountry(null);
        lcb.setVariant(null);
        
        // eXg{
        Locale result = loader.createLocale(lcb);
        
        // 
        assertEquals(new Locale("en"), result);
    }
    /**
     * testCreateLocale06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lFLocaleCodeBean
     *         language = "en"
     *         country = ""
     *         variant = "us01"
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: en
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale06() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        
        LocaleCodeBean lcb = new LocaleCodeBean();
        lcb.setLanguage("en");
        lcb.setCountry(null);
        lcb.setVariant("us01");
        
        // eXg{
        Locale result = loader.createLocale(lcb);
        
        // 
        assertEquals(new Locale("en"), result);
    }
    /**
     * testCreateLocale07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lFLocaleCodeBean
     *         language = "en"
     *         country = "US"
     *         variant = ""
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: en_US
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale07() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        
        LocaleCodeBean lcb = new LocaleCodeBean();
        lcb.setLanguage("en");
        lcb.setCountry("US");
        lcb.setVariant(null);
        
        // eXg{
        Locale result = loader.createLocale(lcb);
        
        // 
        assertEquals(new Locale("en", "US"), result);
    }
    /**
     * testCreateLocale08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lFLocaleCodeBean
     *         language = "en"
     *         country = "US"
     *         variant = "us01"
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: en_US_us01
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale08() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        loader.localeMap = null;
        loader.defaultLocale = Locale.JAPANESE;
        
        LocaleCodeBean lcb = new LocaleCodeBean();
        lcb.setLanguage("en");
        lcb.setCountry("US");
        lcb.setVariant("us01");
        
        // eXg{
        Locale result = loader.createLocale(lcb);
        
        // 
        assertEquals(new Locale("en", "US", "us01"), result);
    }

    /**
     * testGetDataSource01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.dataSource:not null<br>
     *         
     * <br>
     * ҒlF(߂l) DataSource:not null<br>
     *         
     * <br>
     * nꌏ̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetDataSource01() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        UTUtil.setPrivateField(loader, "dataSource", ds);
        
        // eXg{E
        assertSame(ds, loader.getDataSource());
    }

    /**
     * testSetDataSource01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() dataSource:not null<br>
     *         () this.dataSource:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.dataSource:not null<br>
     *         
     * <br>
     * nꌏ̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetDataSource01() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        
        // eXg{
        loader.setDataSource(ds);

        // 
        assertSame(ds, UTUtil.getPrivateField(loader, "dataSource"));
    }

    /**
     * testGetSQL01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sql:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"abc"<br>
     *         
     * <br>
     * nꌏ̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSql01() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        UTUtil.setPrivateField(loader, "sql", "abc");
        
        // eXg{E
        assertEquals("abc", loader.getSql());
    }

    /**
     * testSetSql01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sql:"abc"<br>
     *         () this.sql:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.sql:"abc"<br>
     *         
     * <br>
     * nꌏ̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetSql01() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        
        // eXg{
        loader.setSql("abc");

        // 
        assertEquals("abc", UTUtil.getPrivateField(loader, "sql"));
    }

}
