/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.PropertyTestCase;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

/**
 * {@link jp.terasoluna.fw.web.struts.form.FieldChecksEx} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Validatorǉ[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.form.FieldChecksEx
 */
public class FieldChecksExTest03 extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksExTest03.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        LogUTUtil.flush();
        deleteProperty("validation.hankaku.kana.list");
        deleteProperty("validation.zenkaku.kana.list");
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksExTest03(String name) {
        super(name);
    }

    /**
     * testValidateHankakuString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxF<br>
     *                    G[<br>
     *                    bZ[WF<br>
     *                    bean is null.<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beannull̂ƂAG[Oo͂
     * trueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuString01() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[OmF
        assertTrue(LogUTUtil.checkError("bean is null."));
    }

    /**
     * testValidateHankakuString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * bean󕶎̂ƂAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuString02() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateHankakuString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"1a"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanp݂̂ō\ĂƂA
     * trueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuString03() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "1a";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateHankakuString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"SpA"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *                    ActionMessage("message")<br>
     *
     * <br>
     * beanɔpȊO̕񂪊܂܂ĂꍇAG[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuString04() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "SpA";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[iActionMessage1ݒj
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNg2o^Ă邱ƁB
        assertEquals(2, errors.size());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        // ActionMessage㏑ȂƁB
        Iterator it = errors.get();
        List<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage retError = (ActionMessage) it.next();
            list.add(retError.getKey());
        }
        assertTrue(list.contains("testMessage"));
        assertTrue(list.contains("message"));
    }

    /**
     * testValidateHankakuString05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"ݶA"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanɔpȊO̕񂪊܂܂ĂꍇA
     * G[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuString05() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "ݶA";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNgo^Ă邱ƁB
        assertEquals(1, errors.size());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        Iterator it = errors.get();
        ActionMessage error = (ActionMessage) it.next();
        assertEquals("message", error.getKey());
    }

    /**
     * testValidateHankakuString06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"="0a"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                property="field1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂꍇA
     * field擾ÕvpeBɑ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuString06() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "0a");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateHankakuString07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"=""]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                property="field1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanString^ł͂ȂꍇAfield擾ÕvpeB
     * ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuString07() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNgo^Ă邱ƁB
        assertEquals(1, errors.size());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        Iterator it = errors.get();
        ActionMessage error = (ActionMessage) it.next();
        assertEquals("message", error.getKey());
    }

    /**
     * testValidateHankakuString08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"=""]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                property="field2"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂAfield擾ÕvpeB
     * ݂ȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuString08() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field2");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateZenkakuString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxF<br>
     *                    G[<br>
     *                    bZ[WF<br>
     *                    bean is null.<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beannull̂ƂAG[Oo͂
     * trueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuString01() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateZenkakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[OmF
        assertTrue(LogUTUtil.checkError("bean is null."));
    }

    /**
     * testValidateZenkakuString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * bean󕶎̂ƂAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuString02() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateZenkakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateZenkakuString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"SpA"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanSp݂̂ō\ĂƂA
     * trueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuString03() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "SpA";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateZenkakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateZenkakuString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"1a"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *                    ActionMessage("message")<br>
     *
     * <br>
     * beanɑSpȊO̕񂪊܂܂ĂꍇA
     * G[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuString04() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "1a";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[iActionMessage1ݒj
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateZenkakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNg2o^Ă邱ƁB
        assertEquals(2, errors.size());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        // ActionMessage㏑ȂƁB
        Iterator it = errors.get();
        List<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage retError = (ActionMessage) it.next();
            list.add(retError.getKey());
        }
        assertTrue(list.contains("testMessage"));
        assertTrue(list.contains("message"));
    }

    /**
     * testValidateZenkakuString05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"Aݶ"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanɑSpȊO̕񂪊܂܂ĂꍇA
     * G[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuString05() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "Aݶ";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateZenkakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNgo^Ă邱ƁB
        assertEquals(1, errors.size());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        Iterator it = errors.get();
        ActionMessage error = (ActionMessage) it.next();
        assertEquals("message", error.getKey());
    }

    /**
     * testValidateZenkakuString06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"="SpA"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                property="field1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂꍇAfield擾ÕvpeB
     * ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuString06() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "SpA");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateZenkakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateZenkakuString07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"="1a"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                property="field1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanString^ł͂ȂꍇAfield擾ÕvpeB
     * ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuString07() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "1a");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateZenkakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNgo^Ă邱ƁB
        assertEquals(1, errors.size());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        Iterator it = errors.get();
        ActionMessage error = (ActionMessage) it.next();
        assertEquals("message", error.getKey());
    }

    /**
     * testValidateZenkakuString08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"="1a"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                property="field2"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂAfield擾ÕvpeB
     * ݂ȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuString08() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "1a");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field2");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateZenkakuString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

}
