/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.resolver;

import static org.junit.Assert.*;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.action.MockWebApplicationContext;
import jp.terasoluna.fw.web.struts.actions.AbstractAnnotationBLogicAction;
import jp.terasoluna.fw.web.struts.actions.ActionEx;
import jp.terasoluna.fw.web.struts.actions.AnnotationBLogicAction;
import jp.terasoluna.fw.web.struts.actions.BLogicAction;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;

/**
 * BLogicActionResolverTest
 */
public class BLogicActionResolverTest {

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*BL"</li>
     * <li>beanName : "/hogehogeBL"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : MockWebApplicationContext (containsBean(beanName) : Boolean.TRUE)</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction001() throws Exception {
        Action result = null;

        // p[^
        String actionName = null;
        String pathPattern = null;
        String beanName = null;
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = null;

        // 
        BLogicActionResolver resolver = new BLogicActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);
        resolver.setApplicationContext(applicationContext);
        resolver.afterPropertiesSet();

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*BL"</li>
     * <li>beanName : "/hogehogeBL"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : MockWebApplicationContext (containsBean(beanName) : Boolean.TRUE)</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction002() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*BL";
        String beanName = "/hogehogeBL";
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.TRUE);

        // 
        BLogicActionResolver resolver = new BLogicActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);
        resolver.setApplicationContext(applicationContext);
        resolver.afterPropertiesSet();

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*BL"</li>
     * <li>beanName : "/hogehogeBL"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : MockWebApplicationContext(<br>
     * containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.FALSE)</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>null</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction003() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*BL";
        String beanName = "/hogehogeBL";
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.FALSE);

        // 
        BLogicActionResolver resolver = new BLogicActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);
        resolver.setApplicationContext(applicationContext);
        resolver.afterPropertiesSet();

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*BL"</li>
     * <li>beanName : "/hogehogeBL"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : MockWebApplicationContext(<br>
     * containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(beanName) : new BLogic(), <br>
     * getBean(actionName) : new BLogicAction(), <br>
     * addBeanNamesForType() : )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>null</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction004() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*BL";
        String beanName = "/hogehogeBL";
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        MockWebApplicationContext applicationContext2 = new MockWebApplicationContext();

        applicationContext2.addBeanNamesForType(Object.class,
                new String[] { beanName });
        applicationContext.setParent(applicationContext2);

        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        BLogic blogic = new BLogic() {
            public BLogicResult execute(Object arg0) {
                return null;
            }
        };
        applicationContext.addBeanMap(beanName, blogic);
        applicationContext.addBeanMap(actionName, new BLogicAction());
        String[] values = { beanName };
        applicationContext.addBeanNamesForType(Object.class, values);

        // 
        BLogicActionResolver resolver = new BLogicActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);
        resolver.setApplicationContext(applicationContext);
        resolver.afterPropertiesSet();

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*BL"</li>
     * <li>beanName : "/hogehogeBL"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : MockWebApplicationContext(<br>
     * containsBean(beanName) : Boolean.TRUE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : new BLogicAction(), <br>
     * addBeanNamesForType() : )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>null</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction005() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*BL";
        String beanName = "/hogehogeBL";
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        BLogicAction action = new BLogicAction();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.TRUE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);

        // 
        BLogicActionResolver resolver = new BLogicActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);
        resolver.setApplicationContext(applicationContext);
        resolver.afterPropertiesSet();

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*BL"</li>
     * <li>beanName : "/hogehogeBL"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : MockWebApplicationContext(<br>
     * containsBean(beanName) : Boolean.TRUE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : new BLogicAction(), <br>
     * addBeanNamesForType() : )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>null</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction006() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*BL";
        String beanName = "/hogehogeBL";
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        BLogicAction action = new BLogicAction();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.TRUE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);

        // 
        BLogicActionResolver resolver = new BLogicActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);
        resolver.setApplicationContext(applicationContext);
        resolver.afterPropertiesSet();

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*BL"</li>
     * <li>beanName : "/hogehogeBL"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : MockWebApplicationContext(<br>
     * containsBean(beanName) : Boolean.TRUE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : new BLogicAction(), <br>
     * addBeanNamesForType() : )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>not null</li>
     * <li>getClass() : BLogicAction.class</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction007() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*BL";
        String beanName = "/hogehogeBL";
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        BLogicAction action = new BLogicAction();
        BLogic blogic = new BLogic() {
            public BLogicResult execute(Object arg0) {
                return null;
            }
        };
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.TRUE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);
        applicationContext.addBeanMap(beanName, blogic);

        // 
        BLogicActionResolver resolver = new BLogicActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);
        resolver.setApplicationContext(applicationContext);
        resolver.afterPropertiesSet();

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(BLogicAction.class, result.getClass());
        assertEquals(action, result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*BL"</li>
     * <li>beanName : "/hogehogeBL"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : MockWebApplicationContext(<br>
     * containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(beanName) : new AnnotationTestBLogic(), <br>
     * getBean(actionName) : new BLogicAction(), <br>
     * addBeanNamesForType(Object.class : new String[]( { beanName } )) : )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>not null</li>
     * <li>getClass() : BLogicAction.class</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction008() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*BL";
        String beanName = "/hogehogeBL";
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        BLogicAction action = new BLogicAction();
        BLogic blogic = new AnnotationTestBLogic();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);
        applicationContext.addBeanMap(beanName, blogic);
        String[] beanArray = { beanName };
        applicationContext.addBeanNamesForType(Object.class, beanArray);

        // 
        BLogicActionResolver resolver = new BLogicActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);
        resolver.setApplicationContext(applicationContext);
        resolver.afterPropertiesSet();

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(BLogicAction.class, result.getClass());
        assertEquals(action, result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*BL"</li>
     * <li>beanName : "/hogehogeNotFoundBL"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : MockWebApplicationContext(<br>
     * containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(beanName) : new AnnotationTestBLogic(), <br>
     * getBean(actionName) : new BLogicAction(), <br>
     * addBeanNamesForType(Object.class : new String[]( { beanName } )) : )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>not null</li>
     * <li>getClass() : BLogicAction.class</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction009() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*BL";
        String beanName = "/hogehogeNotFoundBL";
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        BLogicAction action = new BLogicAction();
        BLogic blogic = new AnnotationTestBLogic();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);
        applicationContext.addBeanMap(beanName, blogic);
        String[] beanArray = { beanName };
        applicationContext.addBeanNamesForType(Object.class, beanArray);

        // 
        BLogicActionResolver resolver = new BLogicActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);
        resolver.setApplicationContext(applicationContext);
        resolver.afterPropertiesSet();

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*BL"</li>
     * <li>beanName : "/hogehogeBL"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : MockWebApplicationContext(<br>
     * containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(beanName) : new AnnotationBLogicAction(), <br>
     * getBean(actionName) : new BLogicAction(), <br>
     * addBeanNamesForType(Object.class : new String[]( { beanName } )) : )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>not null</li>
     * <li>getClass() : AnnotationBLogicAction.class</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction010() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*BL";
        String beanName = "/hogehogeBL";
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        AnnotationBLogicAction action = new AnnotationBLogicAction();
        BLogic blogic = new AnnotationTestBLogic();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);
        applicationContext.addBeanMap(beanName, blogic);
        String[] beanArray = { beanName };
        applicationContext.addBeanNamesForType(Object.class, beanArray);

        // 
        BLogicActionResolver resolver = new BLogicActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);
        resolver.setApplicationContext(applicationContext);
        resolver.afterPropertiesSet();

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(AnnotationBLogicAction.class, result.getClass());
        assertEquals(action, result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*BL"</li>
     * <li>beanName : "/hogehogeBL"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : MockWebApplicationContext(<br>
     * containsBean(beanName) : Boolean.TRUE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(beanName) : new AnnotationTestAbstractAnnotationBLogicAction(), <br>
     * getBean(actionName) : new BLogicAction(), <br>
     * addBeanNamesForType(Object.class : new String[]( { beanName } )) : )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>not null</li>
     * <li>getClass() : AnnotationTestAbstractAnnotationBLogicAction.class</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction011() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*BL";
        String beanName = "/hogehogeBL";
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        BLogicAction action = new BLogicAction();
        AbstractAnnotationBLogicAction aabAction = new AnnotationTestAbstractAnnotationBLogicAction();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.TRUE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);
        applicationContext.addBeanMap(beanName, aabAction);
        String[] beanArray = { beanName };
        applicationContext.addBeanNamesForType(Object.class, beanArray);

        // 
        BLogicActionResolver resolver = new BLogicActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);
        resolver.setApplicationContext(applicationContext);
        resolver.afterPropertiesSet();

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(AnnotationTestAbstractAnnotationBLogicAction.class, result
                .getClass());
        assertEquals(aabAction, result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*BL"</li>
     * <li>beanName : "/hogehogeBL"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : MockWebApplicationContext(<br>
     * containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(beanName) : new AnnotationTestAbstractAnnotationBLogicAction(), <br>
     * getBean(actionName) : new BLogicAction(), <br>
     * addBeanNamesForType(Object.class : new String[]( { beanName } )) : )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>null</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction012() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*BL";
        String beanName = "/hogehogeBL";
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        BLogicAction action = new BLogicAction();
        AbstractAnnotationBLogicAction aabAction = new AnnotationTestAbstractAnnotationBLogicAction();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);
        applicationContext.addBeanMap(beanName, aabAction);
        String[] beanArray = { beanName };
        applicationContext.addBeanNamesForType(Object.class, beanArray);

        // 
        BLogicActionResolver resolver = new BLogicActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);
        resolver.setApplicationContext(applicationContext);
        resolver.afterPropertiesSet();

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*BL"</li>
     * <li>beanName : "/hogehogeBL"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : MockWebApplicationContext(<br>
     * containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(beanName) : new AnnotationBLogicAction(), <br>
     * getBean(actionName) : new BLogicAction(), <br>
     * addBeanNamesForType(Object.class : new String[]( { beanName } )) : )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>not null</li>
     * <li>getClass() : AnnotationBLogicAction.class</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction013() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*BL";
        String beanName = "/hogehogeBL";
        String beanName1 = "/hogehoge1BL";
        String beanName2 = "/hogehoge2BL";
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        AnnotationBLogicAction action = new AnnotationBLogicAction();
        BLogic blogic = new AnnotationTestBLogic();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName1, Boolean.FALSE);
        applicationContext.addContainsBeanMap(beanName2, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);
        applicationContext.addBeanMap(beanName1, blogic);
        applicationContext.addBeanMap(beanName2, blogic);
        String[] beanArray = { beanName1, beanName2 };
        applicationContext.addBeanNamesForType(Object.class, beanArray);

        // 
        BLogicActionResolver resolver = new BLogicActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);
        resolver.setApplicationContext(applicationContext);
        resolver.afterPropertiesSet();

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(AnnotationBLogicAction.class, result.getClass());
        assertEquals(action, result);
    }

    /**
     * getTargetClass\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>obj : AOPvLVIuWFNg(Object.class)</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>Object.class</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetTargetClass() throws Exception {
        BLogicActionResolver resolver = new BLogicActionResolver();
        Object obj = null;

        AdvisedSupport advised = new AdvisedSupport();
        Class[] proxiedInterfaces = AopProxyUtils
                .completeProxiedInterfaces(advised);
        InvocationHandler handler = new InvocationHandler() {
            public Object invoke(Object proxy, Method method, Object[] args)
                                                                            throws Throwable {
                return Object.class;
            }
        };
        // vLVIuWFNg
        obj = Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(),
                proxiedInterfaces, handler);

        // eXg
        Class<? extends Object> targetClass = resolver.getTargetClass(obj);

        // 
        assertNotNull(targetClass);
        assertEquals(Object.class, targetClass);
    }

    /**
     * putActionCache\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>cacheKey : new AnnotationTestBLogic()</li>
     * <li>action : new BLogicAction()</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>getActionCache(cacheKey) : BLogicActionCX^X擾ł邱</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPutActionCache001() throws Exception {
        BLogicActionResolver resolver = new BLogicActionResolver();

        BLogic cacheKey = new AnnotationTestBLogic();
        Action action = new BLogicAction();

        // eXg
        resolver.putActionCache(cacheKey, action);

        // 
        Action result = resolver.getActionCache(cacheKey);
        assertNotNull(result);
        assertEquals(action, result);
    }

    /**
     * putActionCache\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>cacheKey : new AnnotationTestBLogic()</li>
     * <li>action : new BLogicAction()</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>getActionCache(cacheKey) : BLogicActionCX^X擾ł邱</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @Test
    public void testPutActionCache002() throws Exception {
        BLogicActionResolver resolver = new BLogicActionResolver();

        String cacheKey = "/hogehogeAction";
        Action action = new ActionEx() {
            @Override
            public ActionForward doExecute(ActionMapping mapping,
                    ActionForm form, HttpServletRequest request,
                    HttpServletResponse response) throws Exception {
                return null;
            }
        };

        // eXg
        resolver.putActionCache(cacheKey, action);

        // 
        Action result = resolver.getActionCache(cacheKey);
        assertNotNull(result);
        assertEquals(action, result);
    }

    /**
     * isCacheEnabled\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>beanName : "hoge"</li>
     * <li>actionName : "hogeAction"</li>
     * <li>mapping : null"</li>
     * <li>servlet : null</li>
     * <li>wac : new MockWebApplicationContext( containsBean(beanName) : Boolean.TRUE, <br>
     * containsBean(actionName) : Boolean.TRUE,<br>
     * getBean(beanName) : new AnnotationTestBLogic(), <br>
     * getBean(actionName) : new BLogicAction(),<br>
     * getBeanNamesForType(Object.class) : new String[]{ beanName }, <br>
     * isSingleton(beanName) : Boolean.TRUE, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>true</li>
     * </p>
     * <br>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testIsCacheEnabled() throws Exception {
        BLogicActionResolver resolver = new BLogicActionResolver();

        Object key = new AnnotationTestBLogic();
        Action resultAction = new BLogicAction();
        String beanName = "hoge";
        String actionName = "hogeAction";
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext wac = new MockWebApplicationContext();
        wac.addContainsBeanMap(beanName, Boolean.TRUE);
        wac.addContainsBeanMap(actionName, Boolean.TRUE);
        wac.addBeanMap(actionName, resultAction);
        wac.addBeanMap(beanName, key);
        String[] beanArray = { beanName };
        wac.addBeanNamesForType(Object.class, beanArray);
        wac.addIsSingletonMap(beanName, Boolean.TRUE);

        // eXg
        boolean result = resolver.isCacheEnabled(key, resultAction, beanName,
                mapping, servlet, wac);

        // 
        assertTrue(result);
    }

    /**
     * testAfterPropertiesSet001.
     * @throws Exception
     */
    @Test
    public void testAfterPropertiesSet001() throws Exception {
        BLogicActionResolver resolver = new BLogicActionResolver();

        // eXg
        resolver.afterPropertiesSet();
    }

    /**
     * testAfterPropertiesSet002.
     * @throws Exception
     */
    @Test
    public void testAfterPropertiesSet002() throws Exception {
        BLogicActionResolver resolver = new BLogicActionResolver();
        ApplicationContext applicationContext = null;
        resolver.setApplicationContext(applicationContext);

        // eXg
        resolver.afterPropertiesSet();
    }

    /**
     * testAfterPropertiesSet003.
     * @throws Exception
     */
    @Test
    public void testAfterPropertiesSet003() throws Exception {
        BLogicActionResolver resolver = new BLogicActionResolver();
        ApplicationContext applicationContext = new MockWebApplicationContext();
        resolver.setApplicationContext(applicationContext);

        // eXg
        resolver.afterPropertiesSet();
    }

    /**
     * testGetBLogicComponentPath001
     * @throws Exception
     */
    @Test
    public void testGetBLogicComponentPath001() throws Exception {
        BLogicActionResolver resolver = new BLogicActionResolver();
        ApplicationContext applicationContext = new MockWebApplicationContext();
        resolver.setApplicationContext(applicationContext);

        // eXg
        String[] result = resolver.getBLogicComponentPath(this.getClass());

        assertNull(result);
    }

    /**
     * testGetBLogicComponentPath002
     * @throws Exception
     */
    @Test
    public void testGetBLogicComponentPath002() throws Exception {
        BLogicActionResolver resolver = new BLogicActionResolver();
        ApplicationContext applicationContext = new MockWebApplicationContext();
        resolver.setApplicationContext(applicationContext);

        // eXg
        String[] result = resolver
                .getBLogicComponentPath(AnnotationTestBLogic.class);

        assertNotNull(result);
        assertEquals(1, result.length);
        assertEquals("/hogehogeBL", result[0]);
    }
}
