/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import static org.junit.Assert.*;

import java.io.IOException;
import java.util.TreeMap;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.struts.action.handler.DefaultDelegateActionHandler;
import jp.terasoluna.fw.web.struts.action.handler.DefaultProcessActionFormHandler;
import jp.terasoluna.fw.web.struts.action.handler.DefaultProcessPopulateHandler;
import jp.terasoluna.fw.web.struts.action.handler.ProcessActionFormStub;
import jp.terasoluna.fw.web.struts.action.handler.ProcessMultipartHandler;
import jp.terasoluna.fw.web.struts.action.handler.ProcessPopulator;
import jp.terasoluna.fw.web.struts.action.handler.ProcessPopulatorStub;
import jp.terasoluna.fw.web.struts.action.handler.ProcessValidateHandler;
import jp.terasoluna.fw.web.struts.action.resolver.BLogicActionResolver;
import jp.terasoluna.fw.web.struts.action.resolver.ResolverActionMapping;
import jp.terasoluna.fw.web.struts.actions.BLogicAction;
import jp.terasoluna.fw.web.struts.actions.ForwardAction;
import jp.terasoluna.utlib.UTUtil;

import org.apache.struts.Globals;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.InvalidCancelException;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ModuleConfig;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.DelegatingRequestProcessor;

import com.mockrunner.mock.web.ActionMockObjectFactory;
import com.mockrunner.mock.web.MockActionServlet;
import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import com.mockrunner.mock.web.MockModuleConfig;

public class DelegatingRequestProcessorExTest {

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ActionMapping()</li>
     * <li>moduleConfig : new ActionMockObjectFactory()</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean("delegateActionHandler") : Boolean.TRUE, <br>
     * getBean("delegateActionHandler") : new DefaultDelegateActionHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction001() throws Exception {

        // p[^
        ActionMapping mapping = new ActionMapping();
        ModuleConfig moduleConfig = new ActionMockObjectFactory()
                .getMockModuleConfig();
        mapping.setModuleConfig(moduleConfig);
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        Action result = null;

        // DelegateActionHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        new DefaultDelegateActionHandler());

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setDelegateActionHandlerName(DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        result = proc.getDelegateAction(mapping);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ActionMapping()</li>
     * <li>moduleConfig : new ActionMockObjectFactory()</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeansOfType() : new BLogicActionResolver() <br>
     * containsBean("delegateActionHandler") : Boolean.TRUE, <br>
     * getBean("delegateActionHandler") : new DefaultDelegateActionHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction002() throws Exception {

        // p[^
        ActionMapping mapping = new ActionMapping();
        ModuleConfig moduleConfig = new ActionMockObjectFactory()
                .getMockModuleConfig();
        mapping.setModuleConfig(moduleConfig);
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext
                .addBeansOfTypeMap("hoge", new BLogicActionResolver());
        Action result = null;

        // DelegateActionHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        new DefaultDelegateActionHandler());

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setDelegateActionHandlerName(DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        result = proc.getDelegateAction(mapping);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ActionMapping()</li>
     * <li>moduleConfig : new ActionMockObjectFactory()</li>
     * <li>beanName : "testmodulenull"</li>
     * <li>actionName : "defaultBlogicAction"</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.TRUE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBeansOfType() : new BLogicActionResolver() pathPattern : ".*", actionName : actionName, <br>
     * getBean(beanName) : new BLogic(), <br>
     * getBean(actionName) : new ForwardAction(), <br>
     * containsBean("delegateActionHandler") : Boolean.TRUE, <br>
     * getBean("delegateActionHandler") : new DefaultDelegateActionHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction003() throws Exception {

        // p[^
        ActionMapping mapping = new ActionMapping();
        ModuleConfig moduleConfig = new ActionMockObjectFactory()
                .getMockModuleConfig();
        mapping.setModuleConfig(moduleConfig);

        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        String beanName = "testmodulenull";
        String actionName = "defaultBlogicAction";
        applicationContext.addContainsBeanMap(beanName, Boolean.TRUE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        BLogicActionResolver resolver = new BLogicActionResolver();
        resolver.setPathPattern(".*");
        resolver.setActionName(actionName);
        applicationContext.addBeansOfTypeMap("hoge", resolver);
        applicationContext.addBeanMap(beanName, new BLogic() {
            public BLogicResult execute(Object arg0) {
                return null;
            }
        });

        // DelegateActionHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        new DefaultDelegateActionHandler());

        applicationContext.addBeanMap(actionName, new BLogicAction());
        Action result = null;

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setDelegateActionHandlerName(DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        proc.initHandler();
        result = proc.getDelegateAction(mapping);

        // 
        assertNotNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ActionMapping()</li>
     * <li>moduleConfig : new ActionMockObjectFactory()</li>
     * <li>beanName : "testmodulenull"</li>
     * <li>actionName : "defaultBlogicAction"</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.TRUE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBeansOfType() : new BLogicActionResolver(), <br>
     * getBean(beanName) : new BLogic(), <br>
     * containsBean("delegateActionHandler") : Boolean.TRUE, <br>
     * getBean("delegateActionHandler") : new DefaultDelegateActionHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OFBeanNotOfRequiredTypeException</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction004() throws Exception {

        // p[^
        ActionMapping mapping = new ActionMapping();
        ModuleConfig moduleConfig = new ActionMockObjectFactory()
                .getMockModuleConfig();
        mapping.setModuleConfig(moduleConfig);

        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        String beanName = "testmodulenull";
        String actionName = "defaultBlogicAction";
        applicationContext.addContainsBeanMap(beanName, Boolean.TRUE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext
                .addBeansOfTypeMap("hoge", new BLogicActionResolver());
        applicationContext.addBeanMap(beanName, new BLogic() {
            public BLogicResult execute(Object arg0) {
                return null;
            }
        });
        Action result = null;

        // DelegateActionHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        new DefaultDelegateActionHandler());

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setDelegateActionHandlerName(DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        try {
            result = proc.getDelegateAction(mapping);
        } catch (Exception e) {
            // 
            assertNull(result);
            assertNotNull(e);
            assertEquals(BeanNotOfRequiredTypeException.class, e.getClass());
            return;
        }
        fail();
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ActionMapping()</li>
     * <li>moduleConfig : new ActionMockObjectFactory()</li>
     * <li>beanName : "testmodulenull"</li>
     * <li>actionName : "defaultBlogicAction"</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.TRUE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBeansOfType() : new BLogicActionResolver(), <br>
     * getBean(beanName) : new BLogic(), <br>
     * getBean(actionName) : new ForwardAction(), <br>
     * containsBean("delegateActionHandler") : Boolean.TRUE, <br>
     * getBean("delegateActionHandler") : new DefaultDelegateActionHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OFBeanNotOfRequiredTypeException</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction005() throws Exception {

        // p[^
        ActionMapping mapping = new ActionMapping();
        ModuleConfig moduleConfig = new ActionMockObjectFactory()
                .getMockModuleConfig();
        mapping.setModuleConfig(moduleConfig);

        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        String beanName = "testmodulenull";
        String actionName = "defaultBlogicAction";
        applicationContext.addContainsBeanMap(beanName, Boolean.TRUE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext
                .addBeansOfTypeMap("hoge", new BLogicActionResolver());
        applicationContext.addBeanMap(beanName, new BLogic() {
            public BLogicResult execute(Object arg0) {
                return null;
            }
        });
        applicationContext.addBeanMap(actionName, new ForwardAction());
        Action result = null;

        // DelegateActionHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        new DefaultDelegateActionHandler());

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setDelegateActionHandlerName(DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        try {
            result = proc.getDelegateAction(mapping);
        } catch (Exception e) {
            // 
            assertNull(result);
            assertNotNull(e);
            assertEquals(BeanNotOfRequiredTypeException.class, e.getClass());
            return;
        }
        fail();
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ActionMapping()</li>
     * <li>moduleConfig : new ActionMockObjectFactory()</li>
     * <li>beanName : "testmodulenull"</li>
     * <li>actionName : "defaultBlogicAction"</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.TRUE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBeansOfType() : new BLogicActionResolver() pathPattern : ".*", actionName : actionName, <br>
     * getBean(beanName) : new BLogic(), <br>
     * getBean(actionName) : new ForwardAction(), <br>
     * containsBean("delegateActionHandler") : Boolean.TRUE, <br>
     * getBean("delegateActionHandler") : new DefaultDelegateActionHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction006() throws Exception {

        // p[^
        ActionMapping mapping = new ActionMapping();
        ModuleConfig moduleConfig = new ActionMockObjectFactory()
                .getMockModuleConfig();
        mapping.setModuleConfig(moduleConfig);

        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        String beanName = "testmodulenull";
        String actionName = "defaultBlogicAction";
        applicationContext.addContainsBeanMap(beanName, Boolean.TRUE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        BLogicActionResolver resolver = new BLogicActionResolver();
        resolver.setPathPattern(".*");
        resolver.setActionName(actionName);
        applicationContext.addBeansOfTypeMap("hoge", resolver);
        applicationContext.addBeanMap(beanName, new Action());

        // DelegateActionHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        new DefaultDelegateActionHandler() {
                            @Override
                            public Action resolveAction(String beanName,
                                    Action action, ActionMapping mapping,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac) {
                                throw new BeansException("hoge") {
                                    private static final long serialVersionUID = -176630110671917455L;
                                };
                            }
                        });

        applicationContext.addBeanMap(actionName, new BLogicAction());
        Action result = null;

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setDelegateActionHandlerName(DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        proc.initHandler();
        result = proc.getDelegateAction(mapping);

        // 
        assertNotNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ActionMapping()</li>
     * <li>moduleConfig : new ActionMockObjectFactory()</li>
     * <li>beanName : "testmodulenull"</li>
     * <li>actionName : "defaultBlogicAction"</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.TRUE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBeansOfType() : new BLogicActionResolver() pathPattern : ".*", actionName : actionName, <br>
     * getBean(beanName) : new BLogic(), <br>
     * getBean(actionName) : new ForwardAction(), <br>
     * containsBean("delegateActionHandler") : Boolean.TRUE, <br>
     * getBean("delegateActionHandler") : new DefaultDelegateActionHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetDelegateAction007() throws Exception {

        // p[^
        ActionMapping mapping = new ActionMapping();
        ModuleConfig moduleConfig = new ActionMockObjectFactory()
                .getMockModuleConfig();
        mapping.setModuleConfig(moduleConfig);

        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        String beanName = "testmodulenull";
        String actionName = "defaultBlogicAction";
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        BLogicActionResolver resolver = new BLogicActionResolver();
        resolver.setPathPattern(".*");
        resolver.setActionName(actionName);
        applicationContext.addBeansOfTypeMap("hoge", resolver);
        // applicationContext.addBeanMap(beanName, new Action());

        // DelegateActionHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        new DefaultDelegateActionHandler() {
                            @Override
                            public Action resolveAction(String beanName,
                                    Action action, ActionMapping mapping,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac) {
                                throw new BeansException("hoge") {
                                    private static final long serialVersionUID = -176630110671917455L;
                                };
                            }
                        });

        applicationContext.addBeanMap(actionName, new BLogicAction());
        @SuppressWarnings("unused")
        Action result = null;

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setDelegateActionHandlerName(DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        proc.initHandler();
        try {
            result = proc.getDelegateAction(mapping);
            fail();
        } catch (BeansException e) {
            // 
            assertNotNull(e);
            assertTrue(BeansException.class.isAssignableFrom(e.getClass()));
            assertEquals("hoge", e.getMessage());
        }
    }

    /**
     * processActionForm\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>req : null</li>
     * <li>res : null</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean("processActionFormHandler") : Boolean.TRUE, <br>
     * getBean("processActionFormHandler") : new DefaultProcessActionFormHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessActionForm001() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        ResolverActionMapping mapping = new ResolverActionMapping();
        HttpServletRequest req = null;
        HttpServletResponse res = null;

        // ProcessActionFormHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSACTIONFORM_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSACTIONFORM_HANDLER_NAME,
                        new DefaultProcessActionFormHandler());

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setProcessActionFormHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSACTIONFORM_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        ActionForm result = proc.processActionForm(req, res, mapping);

        // 
        assertNull(result);
    }

    /**
     * processActionForm\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>req : null</li>
     * <li>res : null</li>
     * <li>processActionForm : new ProcessActionFormStub()</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeansOfType() : processActionForm, <br>
     * containsBean("processActionFormHandler") : Boolean.TRUE, <br>
     * getBean("processActionFormHandler") : new DefaultProcessActionFormHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>return : ValidatorActionFormEx</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessActionForm002() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        ResolverActionMapping mapping = new ResolverActionMapping();
        HttpServletRequest req = null;
        HttpServletResponse res = null;

        ProcessActionFormStub processActionForm = new ProcessActionFormStub();

        applicationContext.addBeansOfTypeMap("hoge", processActionForm);

        // ProcessActionFormHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSACTIONFORM_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSACTIONFORM_HANDLER_NAME,
                        new DefaultProcessActionFormHandler());

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setProcessActionFormHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSACTIONFORM_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        proc.initHandler();
        ActionForm result = proc.processActionForm(req, res, mapping);

        // 
        assertNotNull(result);
        assertEquals(processActionForm.getActionForm(), result);
    }

    /**
     * processPopulate\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>req : null</li>
     * <li>res : null</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean("processPopulateHandler") : Boolean.TRUE, <br>
     * getBean("processPopulateHandler") : new DefaultProcessPopulateHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OȂ</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessPopulate001() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        ResolverActionMapping mapping = new ResolverActionMapping();
        HttpServletRequest req = new MockHttpServletRequest();
        HttpServletResponse res = new MockHttpServletResponse();
        ActionForm form = null;

        // ProcessPopulateHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        new DefaultProcessPopulateHandler());

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setProcessPopulateHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);
        proc.initHandlerBeanName();
        proc.initHandler();

        // eXg
        proc.processPopulate(req, res, form, mapping);
    }

    /**
     * processPopulate\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>req : null</li>
     * <li>res : null</li>
     * <li>processPopulator : new ProcessPopulatorStub()</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeanOfType() : processPopulator, <br>
     * containsBean("processPopulateHandler") : Boolean.TRUE, <br>
     * getBean("processPopulateHandler") : new DefaultProcessPopulateHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OȂ</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessPopulate002() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        ResolverActionMapping mapping = new ResolverActionMapping();
        HttpServletRequest req = new MockHttpServletRequest();
        HttpServletResponse res = new MockHttpServletResponse();
        ActionForm form = null;

        // ProcessPopulateHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        new DefaultProcessPopulateHandler());

        ProcessPopulator processPopulator = new ProcessPopulatorStub();

        applicationContext.addBeansOfTypeMap("hoge", processPopulator);

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setProcessPopulateHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);
        proc.initHandlerBeanName();
        proc.initHandler();

        // eXg
        proc.processPopulate(req, res, form, mapping);
    }

    /**
     * processPopulate\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>req : MockHttpServletRequest()</li>
     * <li>res : MockHttpServletResponse()</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean("processPopulateHandler") : Boolean.TRUE, <br>
     * getBean("processPopulateHandler") : new DefaultProcessPopulateHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OnhOs邱</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessPopulate003() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        ResolverActionMapping mapping = new ResolverActionMapping();
        HttpServletRequest req = new MockHttpServletRequest();
        HttpServletResponse res = new MockHttpServletResponse();
        ActionForm form = null;

        MockModuleConfig moduleConfig = new MockModuleConfig(null);
        ExceptionConfig config = new ExceptionConfig();
        config.setType("jp.terasoluna.fw.exception.SystemException");
        config.setPath("/hoge");
        moduleConfig.setPrefix("prefix");
        mapping.addExceptionConfig(config);
        mapping.setModuleConfig(moduleConfig);
        mapping.setPrefix("prefix");

        req.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // ProcessPopulateHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        new DefaultProcessPopulateHandler() {
                            @Override
                            public boolean processPopulate(
                                    HttpServletRequest req,
                                    HttpServletResponse res, ActionForm form,
                                    ActionMapping mapping,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac)
                                                              throws ServletException {
                                throw new SystemException(new Exception("hoge"));
                            }
                        });

        MockActionServlet actionServlet = new MockActionServlet();
        ServletContext servletContext = new MockServletContextEx();
        servletContext.setAttribute(
                "org.springframework.web.context.WebApplicationContext.ROOT",
                applicationContext);
        actionServlet.setServletContext(servletContext);

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setProcessPopulateHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);
        proc.init(actionServlet, moduleConfig);

        // eXg
        proc.processPopulate(req, res, form, mapping);

        // 
        Object ehFlag = req
                .getAttribute(DelegatingRequestProcessorEx.EXCEPTION_HANDLED_FLAG);
        assertNotNull(ehFlag);
        assertEquals(String.class, ehFlag.getClass());
        assertEquals("true", (String) ehFlag);
    }

    /**
     * processPopulate\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>req : MockHttpServletRequest()</li>
     * <li>res : MockHttpServletResponse()</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean("processPopulateHandler") : Boolean.TRUE, <br>
     * getBean("processPopulateHandler") : new DefaultProcessPopulateHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OnhOs邱</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessPopulate004() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        ResolverActionMapping mapping = new ResolverActionMapping();
        HttpServletRequest req = new MockHttpServletRequest();
        HttpServletResponse res = new MockHttpServletResponse();
        ActionForm form = null;

        MockModuleConfig moduleConfig = new MockModuleConfig(null);
        ExceptionConfig config = new ExceptionConfig();
        config.setType("jp.terasoluna.fw.exception.SystemException");
        config.setPath("/hoge");
        moduleConfig.setPrefix("prefix");
        mapping.addExceptionConfig(config);
        mapping.setModuleConfig(moduleConfig);
        mapping.setPrefix("prefix");

        req.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // ProcessPopulateHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        new DefaultProcessPopulateHandler() {
                            @Override
                            public boolean processPopulate(
                                    HttpServletRequest req,
                                    HttpServletResponse res, ActionForm form,
                                    ActionMapping mapping,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac)
                                                              throws ServletException {
                                throw new SystemException(new Exception("hoge"));
                            }
                        });

        MockActionServlet actionServlet = new MockActionServlet();
        ServletContext servletContext = new MockServletContextEx();
        servletContext.setAttribute(
                "org.springframework.web.context.WebApplicationContext.ROOT",
                applicationContext);
        actionServlet.setServletContext(servletContext);

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx() {
            @Override
            protected ActionForward processException(
                    HttpServletRequest request, HttpServletResponse response,
                    Exception exception, ActionForm form, ActionMapping mapping)
                                                                                throws IOException,
                                                                                ServletException {
                throw new IOException("hoge");
            }
        };
        proc
                .setProcessPopulateHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);
        proc.init(actionServlet, moduleConfig);

        // eXg
        proc.processPopulate(req, res, form, mapping);

        // 
        Object ehFlag = req
                .getAttribute(DelegatingRequestProcessorEx.EXCEPTION_HANDLED_FLAG);
        assertNull(ehFlag);
    }

    /**
     * processPopulate\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>req : MockHttpServletRequest()</li>
     * <li>res : MockHttpServletResponse()</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean("processPopulateHandler") : Boolean.TRUE, <br>
     * getBean("processPopulateHandler") : new DefaultProcessPopulateHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OnhOs邱</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessPopulate005() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        ResolverActionMapping mapping = new ResolverActionMapping();
        HttpServletRequest req = new MockHttpServletRequest();
        HttpServletResponse res = new MockHttpServletResponse();
        ActionForm form = null;

        MockModuleConfig moduleConfig = new MockModuleConfig(null);
        ExceptionConfig config = new ExceptionConfig();
        config.setType("jp.terasoluna.fw.exception.SystemException");
        config.setPath("/hoge");
        moduleConfig.setPrefix("prefix");
        mapping.addExceptionConfig(config);
        mapping.setModuleConfig(moduleConfig);
        mapping.setPrefix("prefix");

        req.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // ProcessPopulateHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        new DefaultProcessPopulateHandler() {
                            @Override
                            public boolean processPopulate(
                                    HttpServletRequest req,
                                    HttpServletResponse res, ActionForm form,
                                    ActionMapping mapping,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac)
                                                              throws ServletException {
                                throw new SystemException(new Exception("hoge"));
                            }
                        });

        MockActionServlet actionServlet = new MockActionServlet();
        ServletContext servletContext = new MockServletContextEx();
        servletContext.setAttribute(
                "org.springframework.web.context.WebApplicationContext.ROOT",
                applicationContext);
        actionServlet.setServletContext(servletContext);

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx() {
            @Override
            protected ActionForward processException(
                    HttpServletRequest request, HttpServletResponse response,
                    Exception exception, ActionForm form, ActionMapping mapping)
                                                                                throws IOException,
                                                                                ServletException {
                throw new ServletException("hoge");
            }
        };
        proc
                .setProcessPopulateHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);
        proc.init(actionServlet, moduleConfig);

        // eXg
        proc.processPopulate(req, res, form, mapping);

        // 
        Object ehFlag = req
                .getAttribute(DelegatingRequestProcessorEx.EXCEPTION_HANDLED_FLAG);
        assertNull(ehFlag);
    }

    /**
     * processMultipart\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>req : null</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean("processMultipartHandler") : Boolean.TRUE, <br>
     * getBean("processMultipartHandler") : new DefaultprocessMultipartHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OȂ</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessMultipart001() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        HttpServletRequest req = new MockHttpServletRequest();

        // ProcessMultipartHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSMULTIPART_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSMULTIPART_HANDLER_NAME,
                        new ProcessMultipartHandler() {
                            public HttpServletRequest processMultipart(
                                    HttpServletRequest request,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac) {
                                return null;
                            }
                        });

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setProcessMultipartHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSMULTIPART_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        try {
            // eXg
            proc.initHandler();
            HttpServletRequest result = proc.processMultipart(req);
            assertNull(result);
        } catch (Exception e) {
            // 
            fail();
        }
    }

    /**
     * processMultipart\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>req : null</li>
     * <li>processPopulator : new ProcessPopulatorStub()</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeanOfType() : processPopulator, <br>
     * containsBean("processMultipartHandler") : Boolean.TRUE, <br>
     * getBean("processMultipartHandler") : new DefaultprocessMultipartHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OȂ</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessMultipart002() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        HttpServletRequest req = new MockHttpServletRequest();

        // ProcessMultipartHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSMULTIPART_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSMULTIPART_HANDLER_NAME,
                        new ProcessMultipartHandler() {
                            public HttpServletRequest processMultipart(
                                    HttpServletRequest request,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac) {
                                return null;
                            }
                        });

        ProcessPopulator processPopulator = new ProcessPopulatorStub();

        applicationContext.addBeansOfTypeMap("hoge", processPopulator);

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setProcessMultipartHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSMULTIPART_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        try {
            // eXg
            proc.initHandler();
            HttpServletRequest result = proc.processMultipart(req);
            assertNull(result);
        } catch (Exception e) {
            // 
            fail();
        }
    }

    /**
     * processMultipart\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>req : null</li>
     * <li>processPopulator : new ProcessPopulatorStub()</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeanOfType() : processPopulator, <br>
     * containsBean("processMultipartHandler") : Boolean.TRUE, <br>
     * getBean("processMultipartHandler") : new DefaultprocessMultipartHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OȂ</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessMultipart003() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        HttpServletRequest req = new MockHttpServletRequest();

        // ProcessMultipartHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSMULTIPART_HANDLER_NAME,
                        Boolean.FALSE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSMULTIPART_HANDLER_NAME,
                        new ProcessMultipartHandler() {
                            public HttpServletRequest processMultipart(
                                    HttpServletRequest request,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac) {
                                return null;
                            }
                        });

        ProcessPopulator processPopulator = new ProcessPopulatorStub();

        applicationContext.addBeansOfTypeMap("hoge", processPopulator);

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setProcessMultipartHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSMULTIPART_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        try {
            // eXg
            HttpServletRequest result = proc.processMultipart(req);
            assertNotNull(result);
        } catch (Exception e) {
            // 
            fail();
        }
    }

    /**
     * processValidate\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>req : null</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean("processValidateHandler") : Boolean.TRUE, <br>
     * getBean("processValidateHandler") : new DefaultprocessValidateHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OȂ</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessValidate001() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        HttpServletRequest req = new MockHttpServletRequest();
        HttpServletResponse res = new MockHttpServletResponse();
        ActionForm form = null;
        ActionMapping mapping = null;

        // processValidateHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME,
                        new ProcessValidateHandler() {
                            public boolean processValidate(
                                    HttpServletRequest request,
                                    HttpServletResponse response,
                                    ActionForm form, ActionMapping mapping,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac)
                                                              throws IOException,
                                                              ServletException,
                                                              InvalidCancelException {
                                return false;
                            }
                        });

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setProcessValidateHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        proc.initHandler();
        boolean result = proc.processValidate(req, res, form, mapping);

        // 
        assertFalse(result);
    }

    /**
     * processValidate\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>req : null</li>
     * <li>processPopulator : new ProcessPopulatorStub()</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeanOfType() : processPopulator, <br>
     * containsBean("processValidateHandler") : Boolean.TRUE, <br>
     * getBean("processValidateHandler") : new DefaultprocessValidateHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OȂ</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessValidate002() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        HttpServletRequest req = new MockHttpServletRequest();
        HttpServletResponse res = new MockHttpServletResponse();
        ActionForm form = null;
        ActionMapping mapping = null;

        // processValidateHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME,
                        new ProcessValidateHandler() {
                            public boolean processValidate(
                                    HttpServletRequest request,
                                    HttpServletResponse response,
                                    ActionForm form, ActionMapping mapping,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac)
                                                              throws IOException,
                                                              ServletException,
                                                              InvalidCancelException {
                                return false;
                            }
                        });

        ProcessPopulator processPopulator = new ProcessPopulatorStub();

        applicationContext.addBeansOfTypeMap("hoge", processPopulator);

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setProcessValidateHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        proc.initHandler();
        boolean result = proc.processValidate(req, res, form, mapping);

        // 
        assertFalse(result);
    }

    /**
     * processValidate\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>req : null</li>
     * <li>processPopulator : new ProcessPopulatorStub()</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeanOfType() : processPopulator, <br>
     * containsBean("processValidateHandler") : Boolean.TRUE, <br>
     * getBean("processValidateHandler") : new DefaultprocessValidateHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OȂ</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessValidate003() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        HttpServletRequest req = new MockHttpServletRequest();
        HttpServletResponse res = new MockHttpServletResponse();
        ActionForm form = null;
        ActionMapping mapping = null;

        // processValidateHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME,
                        Boolean.FALSE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME,
                        new ProcessValidateHandler() {
                            public boolean processValidate(
                                    HttpServletRequest request,
                                    HttpServletResponse response,
                                    ActionForm form, ActionMapping mapping,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac)
                                                              throws IOException,
                                                              ServletException,
                                                              InvalidCancelException {
                                return false;
                            }
                        });

        ProcessPopulator processPopulator = new ProcessPopulatorStub();

        applicationContext.addBeansOfTypeMap("hoge", processPopulator);

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setProcessValidateHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        boolean result = proc.processValidate(req, res, form, mapping);

        // 
        assertTrue(result);
    }

    /**
     * processValidate\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>req : null</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean("processValidateHandler") : Boolean.TRUE, <br>
     * getBean("processValidateHandler") : new DefaultprocessValidateHandler(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OȂ</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testProcessValidate004() throws Exception {
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // p[^
        HttpServletRequest req = new MockHttpServletRequest();
        HttpServletResponse res = new MockHttpServletResponse();
        ActionForm form = null;
        ActionMapping mapping = null;

        req.setAttribute(DelegatingRequestProcessorEx.EXCEPTION_HANDLED_FLAG,
                Boolean.TRUE.toString());

        // processValidateHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME,
                        new ProcessValidateHandler() {
                            public boolean processValidate(
                                    HttpServletRequest request,
                                    HttpServletResponse response,
                                    ActionForm form, ActionMapping mapping,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac)
                                                              throws IOException,
                                                              ServletException,
                                                              InvalidCancelException {
                                return false;
                            }
                        });

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        proc
                .setProcessValidateHandlerName(DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME);
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        proc.initHandler();
        boolean result = proc.processValidate(req, res, form, mapping);

        // 
        assertFalse(result);
    }

    /**
     * @throws Exception
     */
    @Test
    public void testInit001() throws Exception {
        // p[^
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        ActionServlet actionServlet = null;
        ModuleConfig moduleConfig = null;

        // eXg
        proc.init(actionServlet, moduleConfig);
    }

    /**
     * @throws Exception
     */
    @Test
    public void testInit002() throws Exception {
        // p[^
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        PropertyUtil
                .addPropertyFile("jp/terasoluna/fw/web/struts/action/DelegatingRequestProcessorExTest001.properties");

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        ActionServlet actionServlet = null;
        ModuleConfig moduleConfig = null;

        // eXg
        proc.init(actionServlet, moduleConfig);
    }

    /**
     * @throws Exception
     */
    @Test
    public void testInit003() throws Exception {
        // p[^
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        PropertyUtil
                .addPropertyFile("jp/terasoluna/fw/web/struts/action/DelegatingRequestProcessorExTest002.properties");

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        ActionServlet actionServlet = null;
        ModuleConfig moduleConfig = null;

        // eXg
        proc.init(actionServlet, moduleConfig);
    }

    /**
     * @throws Exception
     */
    @Test
    public void testInit004() throws Exception {
        // p[^
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // ProcessMultipartHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSMULTIPART_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSMULTIPART_HANDLER_NAME,
                        new ProcessMultipartHandler() {
                            public HttpServletRequest processMultipart(
                                    HttpServletRequest request,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac) {
                                return null;
                            }
                        });

        // ProcessActionFormHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSACTIONFORM_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSACTIONFORM_HANDLER_NAME,
                        new DefaultProcessActionFormHandler());

        // ProcessPopulateHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        new DefaultProcessPopulateHandler());

        // processValidateHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME,
                        new ProcessValidateHandler() {
                            public boolean processValidate(
                                    HttpServletRequest request,
                                    HttpServletResponse response,
                                    ActionForm form, ActionMapping mapping,
                                    ModuleConfig moduleConfig,
                                    ActionServlet servlet,
                                    WebApplicationContext wac)
                                                              throws IOException,
                                                              ServletException,
                                                              InvalidCancelException {
                                return false;
                            }
                        });

        // DelegateActionHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        new DefaultDelegateActionHandler());

        // vpeBǂݍ
        PropertyUtil
                .addPropertyFile("jp/terasoluna/fw/web/struts/action/DelegatingRequestProcessorExTest001.properties");

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        ActionServlet actionServlet = null;
        ModuleConfig moduleConfig = null;

        // eXg
        proc.init(actionServlet, moduleConfig);
    }

    /**
     * @throws Exception
     */
    @Test
    public void testInit005() throws Exception {
        // p[^
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // ProcessMultipartHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSMULTIPART_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSMULTIPART_HANDLER_NAME,
                        new Object());

        // ProcessActionFormHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSACTIONFORM_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSACTIONFORM_HANDLER_NAME,
                        new Object());

        // ProcessPopulateHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSPOPULATE_HANDLER_NAME,
                        new Object());

        // processValidateHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_PROCESSVALIDATE_HANDLER_NAME,
                        new Object());

        // DelegateActionHandler
        applicationContext
                .addContainsBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        Boolean.TRUE);
        applicationContext
                .addBeanMap(
                        DelegatingRequestProcessorEx.DEFAULT_DELEGATEACTION_HANDLER_NAME,
                        new Object());

        // vpeBǂݍ
        PropertyUtil
                .addPropertyFile("jp/terasoluna/fw/web/struts/action/DelegatingRequestProcessorExTest001.properties");

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        ActionServlet actionServlet = null;
        ModuleConfig moduleConfig = null;

        // eXg
        proc.init(actionServlet, moduleConfig);
    }

    /**
     * @throws Exception
     */
    @Test
    public void testInitHandlerBeanName001() throws Exception {
        // p[^
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        proc.initHandlerBeanName();
    }

    /**
     * @throws Exception
     */
    @Test
    public void testInitHandlerBeanName002() throws Exception {
        // p[^
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        PropertyUtil
                .addPropertyFile("jp/terasoluna/fw/web/struts/action/DelegatingRequestProcessorExTest001.properties");

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        proc.initHandlerBeanName();
    }

    /**
     * @throws Exception
     */
    @Test
    public void testInitHandlerBeanName003() throws Exception {
        // p[^
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        PropertyUtil
                .addPropertyFile("jp/terasoluna/fw/web/struts/action/DelegatingRequestProcessorExTest002.properties");

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        proc.initHandlerBeanName();
    }

    /**
     * @throws Exception
     */
    @Test
    public void testInitHandlerBeanName004() throws Exception {
        // p[^
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        UTUtil.setPrivateField(PropertyUtil.class, "props",
                new TreeMap<String, String>());

        // 
        DelegatingRequestProcessorEx proc = new DelegatingRequestProcessorEx();
        UTUtil.setPrivateField((DelegatingRequestProcessor) proc,
                "webApplicationContext", applicationContext);

        // eXg
        proc.initHandlerBeanName();
    }

}
