/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.orm.ibatis.support;

import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.springframework.jdbc.support.lob.LobHandler;

/**
 * {@link jp.terasoluna.fw.orm.ibatis.support.ClobReaderTypeHandler}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * iBATIS痘pClobƃXg[}bsOiBATIS̃^CvnhB
 * <p>
 * 
 * @see jp.terasoluna.fw.orm.ibatis.support.ClobReaderTypeHandler
 */
@SuppressWarnings("unused")
public class ClobReaderTypeHandlerTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ClobReaderTypeHandlerTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ClobReaderTypeHandlerTest(String name) {
        super(name);
    }

    /**
     * testClobReaderTypeHandler01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() lobHandler:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) lobHandler:lobHandlerƓlobHandler<br>
     *         
     * <br>
     * not null̏ꍇAɐݒ肷邱Ƃ̃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testClobReaderTypeHandler01() throws Exception {
        // O
        LobHandler lob = new LobHandlerImpl01();

        // eXg{
        ClobReaderTypeHandler handler = new ClobReaderTypeHandler(lob);

        // 
        assertSame(lob, UTUtil.getPrivateField(handler, "lobHandler"));
    }

    /**
     * testClobReaderTypeHandler02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() lobHandler:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *         
     * <br>
     * null̏ꍇAIllegalStateExceptionX[邱Ƃ̃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testClobReaderTypeHandler02() throws Exception {
        // O
        LobHandler lob = null;

        // eXg{
        try {
            ClobReaderTypeHandler handler =
                new ClobReaderTypeHandler(lob);
            fail();
        } catch (IllegalStateException e) {
            //             
        }
    }

    /**
     * testSetParameterInternal01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:ReaderCX^X<br>
     *         () lobCreator.setClobAsCharacterStream():<br>
     *         
     * <br>
     * ҒlF(߂l) void:<br>
     *         (ԕω) lobCreator.setClobAsCharacterStream():ĂяoĂ邱ƂmF<br>
     *         
     * <br>
     * lobCreator.setClobAsCharacterStream()sĂ邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetParameterInternal01() throws Exception {
        // O
        LobHandler lob = new LobHandlerImpl01();
        
        PreparedStatement ps = null;
        int index = 0;
        // value : Reader
        StringReader value = new StringReader("");
        String jdbcType = null;
        // LobCreatorNX : ĂяomF
        LobCreatorImpl01 lobCreator = new LobCreatorImpl01();
        
        ClobReaderTypeHandler handler = new ClobReaderTypeHandler(lob);

        // eXg{
        handler.setParameterInternal(ps, index, value, jdbcType, lobCreator);

        // 
        boolean b = ((Boolean) lobCreator.isSetClobAsCharacterStream)
        .booleanValue();
        assertTrue(b);
        
        value.close();
    }

    /**
     * testSetParameterInternal02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() value:ReaderȊÕCX^X<br>
     *         
     * <br>
     * ҒlF(ԕω) Ȃ:ClassCastExceptinon<br>
     *         
     * <br>
     * ClassCastExceptionX[邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetParameterInternal02() throws Exception {
        // O
        LobHandler lob = new LobHandlerImpl01();
        
        PreparedStatement ps = null;
        int index = 0;
        // value : ReaderȊO
        String value = "";
        String jdbcType = null;
        // LobCreatorNX
        LobCreatorImpl01 lobCreator = new LobCreatorImpl01();
        
        ClobReaderTypeHandler handler = new ClobReaderTypeHandler(lob);

        try {
            // eXg{
            handler.setParameterInternal(ps, index, value, jdbcType, lobCreator);
            fail();
        } catch (ClassCastException e) {
            // 
        }
    }

    /**
     * testSetParameterInternal03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() lobCreator.setClobAsCharacterStream():SQLException<br>
     *         
     * <br>
     * ҒlF(ԕω) Ȃ:SQLException<br>
     *         
     * <br>
     * SQLExceptionX[邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetParameterInternal03() throws Exception {
        // O
        LobHandler lob = new LobHandlerImpl01();
        
        PreparedStatement ps = null;
        int index = 0;
        // value : -
        StringReader value = null;
        String jdbcType = null;
        // LobCreatorNX : SQLException
        LobCreatorImpl02 lobCreator = new LobCreatorImpl02();
        
        ClobReaderTypeHandler handler = new ClobReaderTypeHandler(lob);

        try {
            // eXg{
            handler.setParameterInternal(ps, index, value, jdbcType, lobCreator);
            fail();
        } catch (SQLException e) {
            // 
        }
    }

    /**
     * testGetResultInternal01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() lobHandler.getClobAsCharacterStream():not null<br>
     *         
     * <br>
     * ҒlF(߂l) Object:lobHandler.getClobAsCharacterStream()̖߂lƓCX^X<br>
     *         (ԕω) lobHandler.getClobAsCharacterStream():ĂяoĂ邱ƂmF<br>
     *         
     * <br>
     * lobHandler.getClobAsCharacterStream()̖߂lƓCX^Xԋp邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetResultInternal01() throws Exception {
        // O
        LobHandlerImpl01 lob = new LobHandlerImpl01();
        
        ResultSet ps = null;
        int index = 0;
        
        // LobHandlerNXgetClobAsCharacterStream̃^[l : 
        // StringReaderCX^X
        StringReader sr = new StringReader("");
        UTUtil.setPrivateField(lob, "r", sr);
        
        ClobReaderTypeHandler handler =
            new ClobReaderTypeHandler(lob);

        // eXg{
        StringReader reader =
            (StringReader) handler.getResultInternal(ps, index, lob);

        // 
        boolean b = ((Boolean) lob.isGetClobAsCharacterStream).booleanValue();
        assertTrue(b);
        assertSame(sr, reader);
        
        sr.close();
    }

    /**
     * testGetResultInternal02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() lobHandler.getClobAsCharacterStream():null<br>
     *         
     * <br>
     * ҒlF(߂l) Object:null<br>
     *         (ԕω) lobHandler.getClobAsCharacterStream():ĂяoĂ邱ƂmF<br>
     *         
     * <br>
     * nullԋp邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetResultInternal02() throws Exception {
        // O
        LobHandlerImpl01 lob = new LobHandlerImpl01();
        
        ResultSet ps = null;
        int index = 0;
        
        // LobHandlerNXgetClobAsCharacterStream̃^[l : null
        StringReader sr = null;
        UTUtil.setPrivateField(lob, "r", sr);
        
        ClobReaderTypeHandler handler =
            new ClobReaderTypeHandler(lob);

        // eXg{
        StringReader reader =
            (StringReader) handler.getResultInternal(ps, index, lob);

        // 
        boolean b = ((Boolean) lob.isGetClobAsCharacterStream).booleanValue();
        assertTrue(b);
        assertNull(reader);
    }

    /**
     * testGetResultInternal03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() lobHandler.getClobAsCharacterStream():SQLException<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SQLException<br>
     *         
     * <br>
     * SQLExceptionX[邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetResultInternal03() throws Exception {
        // O
        // getClobAsCharacterStream : SQLException
        LobHandlerImpl02 lob = new LobHandlerImpl02();
        
        ResultSet ps = null;
        int index = 0;
        
        ClobReaderTypeHandler handler =
            new ClobReaderTypeHandler(lob);

        try {
            // eXg{
            StringReader reader =
                (StringReader) handler.getResultInternal(ps, index, lob);
            fail();
        } catch (SQLException e) {
            // 
        }
    }

    /**
     * testValueOf01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() s:null<br>
     *         
     * <br>
     * ҒlF(߂l) Object:null<br>
     *         
     * <br>
     * nullԋp邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValueOf01() throws Exception {
        // O
        LobHandlerImpl01 lob = new LobHandlerImpl01();
        
        ClobReaderTypeHandler handler =
            new ClobReaderTypeHandler(lob);
        
        String s = null;

        // eXg{
        Object obj = handler.valueOf(s);

        // 
        assertNull(obj);
    }

    /**
     * testValueOf02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() s:""<br>
     *         
     * <br>
     * ҒlF(߂l) Object:new StringReader("".getBytes())<br>
     *         
     * <br>
     * ""𕶎Xg[̂ԋp邱Ƃ̃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValueOf02() throws Exception {
        // O
        LobHandlerImpl01 lob = new LobHandlerImpl01();
        
        ClobReaderTypeHandler handler =
            new ClobReaderTypeHandler(lob);
        
        String s = "";

        // eXg{
        Object obj = handler.valueOf(s);

        // 
        assertEquals(StringReader.class.getName(),
                obj.getClass().getName());
        String str = (String) UTUtil.getPrivateField(obj, "str");
        assertEquals("", str);
    }

    /**
     * testValueOf03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() s:"ABC"<br>
     *         
     * <br>
     * ҒlF(߂l) Object:new StringReader("ABC".getBytes())<br>
     *         
     * <br>
     * "ABC"𕶎Xg[̂ԋpeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValueOf03() throws Exception {
        // O
        LobHandlerImpl01 lob = new LobHandlerImpl01();
        
        ClobReaderTypeHandler handler =
            new ClobReaderTypeHandler(lob);
        
        String s = "ABC";

        // eXg{
        Object obj = handler.valueOf(s);

        // 
        assertEquals(StringReader.class.getName(),
                obj.getClass().getName());
        String str = (String) UTUtil.getPrivateField(obj, "str");
        assertEquals("ABC", str);
    }
}