/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import com.mockrunner.base.NestedApplicationException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamUtil {
    private static final Log log = LogFactory.getLog((Class)(class$com$mockrunner$util$common$StreamUtil == null ? (class$com$mockrunner$util$common$StreamUtil = StreamUtil.class$("com.mockrunner.util.common.StreamUtil")) : class$com$mockrunner$util$common$StreamUtil));
    static /* synthetic */ Class class$com$mockrunner$util$common$StreamUtil;

    public static byte[] getStreamAsByteArray(InputStream inputStream) {
        return StreamUtil.getStreamAsByteArray(inputStream, -1);
    }

    public static byte[] getStreamAsByteArray(InputStream inputStream, int n) {
        if (n == 0) {
            return new byte[0];
        }
        boolean bl = true;
        if (n < 0) {
            n = Integer.MAX_VALUE;
            bl = false;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2 = inputStream.read();
            if (bl) {
                --n;
            }
            while (-1 != n2 && n >= 0) {
                byteArrayOutputStream.write(n2);
                n2 = inputStream.read();
                if (!bl) continue;
                --n;
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            log.error((Object)"Exception while reading from stream", (Throwable)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String getReaderAsString(Reader reader) {
        return StreamUtil.getReaderAsString(reader, -1);
    }

    public static String getReaderAsString(Reader reader, int n) {
        if (n == 0) {
            return "";
        }
        boolean bl = true;
        if (n < 0) {
            n = Integer.MAX_VALUE;
            bl = false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2 = reader.read();
            if (bl) {
                --n;
            }
            while (-1 != n2 && n >= 0) {
                stringBuffer.append((char)n2);
                n2 = reader.read();
                if (!bl) continue;
                --n;
            }
        }
        catch (IOException iOException) {
            log.error((Object)"Exception while reading from reader", (Throwable)iOException);
        }
        return stringBuffer.toString();
    }

    public static InputStream copyStream(InputStream inputStream) {
        try {
            if (inputStream.markSupported()) {
                inputStream.mark(inputStream.available());
            }
            byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream);
            if (inputStream.markSupported()) {
                inputStream.reset();
            }
            return new ByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            log.error((Object)"Exception while copying stream", (Throwable)iOException);
            return null;
        }
    }

    public static Reader copyReader(Reader reader) {
        try {
            if (reader.markSupported()) {
                reader.mark(Integer.MAX_VALUE);
            }
            String string = StreamUtil.getReaderAsString(reader);
            if (reader.markSupported()) {
                reader.reset();
            }
            return new StringReader(string);
        }
        catch (IOException iOException) {
            log.error((Object)"Exception while copying reader", (Throwable)iOException);
            return null;
        }
    }

    public static boolean compareStreams(InputStream inputStream, InputStream inputStream2) {
        try {
            if (inputStream.markSupported()) {
                inputStream.mark(inputStream.available());
            }
            if (inputStream2.markSupported()) {
                inputStream2.mark(inputStream2.available());
            }
            byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream);
            byte[] byArray2 = StreamUtil.getStreamAsByteArray(inputStream2);
            if (inputStream.markSupported()) {
                inputStream.reset();
            }
            if (inputStream2.markSupported()) {
                inputStream2.reset();
            }
            return Arrays.equals(byArray, byArray2);
        }
        catch (IOException iOException) {
            log.error((Object)"Exception while comparing streams", (Throwable)iOException);
            return false;
        }
    }

    public static boolean compareReaders(Reader reader, Reader reader2) {
        try {
            if (reader.markSupported()) {
                reader.mark(Integer.MAX_VALUE);
            }
            if (reader2.markSupported()) {
                reader2.mark(Integer.MAX_VALUE);
            }
            String string = StreamUtil.getReaderAsString(reader);
            String string2 = StreamUtil.getReaderAsString(reader2);
            if (reader.markSupported()) {
                reader.reset();
            }
            if (reader2.markSupported()) {
                reader2.reset();
            }
            return string.equals(string2);
        }
        catch (IOException iOException) {
            log.error((Object)"Exception while comparing readers", (Throwable)iOException);
            return false;
        }
    }

    public static List getLinesFromReader(Reader reader) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            while (string != null) {
                arrayList.add(string);
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            throw new NestedApplicationException(iOException);
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

