/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.uc_a01_03.blogic;

import java.util.Calendar;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.toursample.common.exception.RecordNotFoundException;
import jp.terasoluna.toursample.common.util.DateUtil;
import jp.terasoluna.toursample.uc_a01_03.dto.RP_A01_03_02_01Input;
import jp.terasoluna.toursample.uc_a01_03.exception.CannotEditException;
import jp.terasoluna.toursample.uc_a01_03.exception.TourMemberOverException;

/**
 * cA[\ύXmBLogicNXB <br>
 * EUC_A01_03FcA[\ύX
 * 
 * 
 * 
 */
public class RP_A01_03_02_01BLogicImpl implements BLogic<RP_A01_03_02_01Input> {

    /**
     * ʏsNullԋpꂽꍇ̃G[bZ[WB
     */
    public static final String ERROR_NOT_RESERVED = "error.common.00008";

    /**
     * DAONXB<br>
     * SpringɂCX^Xݒ肳B
     */
    private QueryDAO queryDAO = null;

    /**
     * DAONXB<br>
     * SpringɂCX^Xݒ肳B
     */
    private UpdateDAO updateDAO = null;

    /**
     * cȐȂꍇ̃G[bZ[WB
     */
    public static final String ERROR_NOT_ENOUGH_SEAT = "warn.UC_A01_03.00001";

    /**
     * ONXB
     */
    private static final Log log = LogFactory
            .getLog(RP_A01_03_02_01BLogicImpl.class);

    /**
     * QueryDAOݒ肷B
     * 
     * @param queryDAO
     *            ݒ肷QueryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {

        this.queryDAO = queryDAO;
    }

    /**
     * UpdateDAOݒ肷B
     * 
     * @param updateDAO
     *            ݒ肷UpdateDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {

        this.updateDAO = updateDAO;
    }

    /**
     * cA[\ύXrWlXWbNB<br>
     * cȐ̊mFAcA[\ύX
     * 
     * @param params
     *            cA[\ύXێpNX
     * @exception TourMemberOverException
     *                cȐȂꍇ̗O
     */
    public BLogicResult execute(RP_A01_03_02_01Input params) {

        // cA[\̐UtOB
        Boolean transfer = queryDAO.executeForObject(
                "UC_A01_03.selectTransfer", params, Boolean.class);

        // \񂪂ȂꍇAOsB
        // ONXFRecordNotFoundException
        if (transfer == null) {

            if (log.isErrorEnabled()) {
                log.error(ERROR_NOT_RESERVED + ":\񂪌܂B");
            }

            throw new RecordNotFoundException(ERROR_NOT_RESERVED);
        }

        // UtOUς݂̏ꍇOsB
        if (transfer) {

            if (log.isWarnEnabled()) {
                log.warn("warn.UC_A01_03.00002:xς݂̂ߗ\ύXłȂB");
            }

            throw new CannotEditException("warn.UC_A01_03.00002");
        }

        // U擾B
        Date paymentTimeLimit = DateUtil.getOneWeekBeforeDate(params
                .getReserveDetail().getDepDay());
        // VXetƐUr
        // U߂ĂꍇAƖG[ʂ֑JڂB
        Date today = DateUtil.getTodayDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);

        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.clear(Calendar.MINUTE);
        calendar.clear(Calendar.SECOND);
        calendar.clear(Calendar.MILLISECOND);

        if (calendar.getTime().after(paymentTimeLimit)) {
            if (log.isWarnEnabled()) {
                log.warn("warn.UC_A01_03.00002:U߂Ă邽ߗ\ύXłȂB");
            }           
            throw new CannotEditException("warn.UC_A01_03.00002");
        }

        // Ɩ̓NXf[^̎擾
        String tourCode = params.getReserveDetail().getTourCode();
        String reserveNo = params.getReserveNo();
        Integer adultCount = params.getPrice().getAdultCount();
        Integer childCount = params.getPrice().getChildCount();
        Integer sumPrice = params.getPrice().getSumPrice();
        String remarks = params.getReserveDetail().getRemarks();

        // őÍsl擾B
        SelectNumberOfPersonInput numberOfPerson = new SelectNumberOfPersonInput();
        numberOfPerson.setTourCode(tourCode);
        Integer avaRecMax = queryDAO.executeForObject(
                "UC_A01_03.selectAvaRecMaxForUpdate", numberOfPerson,
                Integer.class);

        // ύX\ȊO̗\l擾
        numberOfPerson.setReserveNo(reserveNo);
        Integer totalReserveCount = queryDAO.executeForObject(
                "UC_A01_03.selectTotalReserveCount", numberOfPerson,
                Integer.class);

        // ύX\ȊO̗\lȂꍇ(null)0ŏ
        if (totalReserveCount == null) {
            totalReserveCount = Integer.valueOf(0);
        }

        // cȐ`FbN
        // wcA[őÍslx<
        // w\lx + ͒lwliljx + ͒lwliqǂjx
        if (avaRecMax.intValue() < (totalReserveCount.intValue()
                + adultCount.intValue() + childCount.intValue())) {

            if (log.isWarnEnabled()) {
                log.warn(ERROR_NOT_ENOUGH_SEAT + ":cȐ܂B");
            }

            throw new TourMemberOverException(ERROR_NOT_ENOUGH_SEAT);
        }

        // \XV
        UpdateReserveInput reserveInput = new UpdateReserveInput();
        reserveInput.setReserveNo(reserveNo);
        reserveInput.setAdultCount(adultCount);
        reserveInput.setChildCount(childCount);
        reserveInput.setRemarks(remarks);
        reserveInput.setSumPrice(sumPrice);

        params.setSumPrice(params.getPrice().getSumPrice());
        updateDAO.execute("UC_A01_03.updateReserve", reserveInput);

        // o͒l𐶐B
        BLogicResult bResult = new BLogicResult();
        bResult.setResultString("success");

        return bResult;
    }

}
