/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.uc_a01_01.blogic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Map;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.toursample.common.util.DateUtil;
import jp.terasoluna.toursample.uc_a01_01.dto.RP_A01_01_01_02Input;
import jp.terasoluna.toursample.uc_a01_01.dto.RP_A01_01_01_02Output;
import jp.terasoluna.toursample.uc_a01_01.dto.SelectTourInfoInput;
import jp.terasoluna.toursample.uc_a01_01.dto.TourInfo;

/**
 * <p>
 * cA[擾rWlXWbNB
 * cA[\o^NGXgƃcA[\y[WNJڃNGXg<br>
 * 킹NXB
 * </p>
 * 
 * 
 * 
 */
public class RP_A01_01_01_02BLogicImpl 
    implements BLogic<RP_A01_01_01_02Input> {

    /**
     * ʃR[h0̏ꍇ̃bZ[WB
     */
    public static final String INFO_NOT_TOUR = "info.UC_A01_01.00003";

    /**
     * ʃR[h1ȏ̏ꍇ̃bZ[WB
     */
    public static final String INFO_TOUR = "info.common.00001";

    /**
     * ONXB
     */
    private static final Log log = 
        LogFactory.getLog(RP_A01_01_01_02BLogicImpl.class);

    /**
     * DAONXB SpringɂCX^Xݒ肳B
     */
    protected QueryDAO queryDAO = null;

    /**
     * ̃R[hϊMapB
     */
    private Map<String, Integer> daysMap = null;

    /**
     * {̃R[hϊMapB
     */
    private Map<String, Integer> priceMap = null;

    /**
     * QueryDAOݒ肷B
     * 
     * @param queryDAO ݒ肷QueryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }

    /**
     * ̃R[hϊMapԋpB
     * 
     * @return ̃R[hϊMap
     */
    public Map<String, Integer> getDaysMap() {
        return daysMap;
    }

    /**
     * ̃R[hϊMapݒ肷B
     * 
     * @param daysMap ݒ肷̃R[hϊMap
     */
    public void setDaysMap(Map<String, Integer> daysMap) {
        this.daysMap = daysMap;
    }

    /**
     * {̃R[hϊMapԋpB
     * 
     * @return {̃R[hϊMap
     */
    public Map<String, Integer> getPriceMap() {
        return priceMap;
    }

    /**
     * {̃R[hϊMapݒ肷B
     * 
     * @param priceMap ݒ肷{̃R[hϊMap
     */
    public void setPriceMap(Map<String, Integer> priceMap) {
        this.priceMap = priceMap;
    }

    /**
     * 1:͏ƃR[hXg񂩂猟𐶐āA擾B
     * <br>
     * 2:y[WN@\B
     * 
     * @param param ێDtoNX
     * @return ʁB
     */
    public BLogicResult execute(RP_A01_01_01_02Input param) {

        // sʂpӂB
        BLogicResult result = new BLogicResult();

        // cA[邽߂̃NX𐶐B
        SelectTourInfoInput selectInput = new SelectTourInfoInput();

        // ϊB
        Integer days = daysMap.get(param.getTourDaysCondition());

        // {ϊB
        Integer price = priceMap.get(param.getBasePriceCondition());

        // ZbgB
        // (on,ړIn,cA[o,,{,)
        selectInput.setDepCodeCondition(param.getDepCodeCondition());
        selectInput.setArrCodeCondition(param.getArrCodeCondition());
        String jointDepDay = 
            param.getDepDayYearCondition() + "/" + 
            param.getDepDayMonthCondition() + "/" + 
            param.getDepDayDayCondition();
        selectInput.setDepDayCondition(jointDepDay);
        selectInput.setTourDays(days);
        selectInput.setAdultCountCondition(param.getAdultCountCondition());
        selectInput.setChildCountCondition(param.getChildCountCondition());
        selectInput.setBasePrice(price);

        // o͏i[NX𐶐B
        RP_A01_01_01_02Output rp_a01_01_01_02Output = 
            new RP_A01_01_01_02Output();

        // f[^x[XcA[񂩂10擾B
        Integer startIndex = param.getStartIndex();
        Integer row = param.getRow();

        // 10cA[̌Ǝs
        TourInfo[] tourInfo = 
            queryDAO.executeForObjectArray("UC_A01_01.selectTourInfo", 
                    selectInput, TourInfo.class, startIndex, row);

        // cA[ʑ擾B
        Integer tourCount = 
            queryDAO.executeForObject("UC_A01_01.selectTourInfoCount", 
                    selectInput, Integer.class);

        // bZ[Wݒ肷B
        BLogicMessages messages = new BLogicMessages();

        // 0
        if (tourCount == 0) {
            messages.add(this.getClass().getName(), 
                    new BLogicMessage(INFO_NOT_TOUR));

            if (log.isDebugEnabled()) {
                log.debug(INFO_NOT_TOUR + "cA[ 0");
            }

        } else {

            // ϊB
            for (int i = 0; i < tourInfo.length; i++) {
                tourInfo[i].setTourDays(DateUtil.convertNightDays(tourInfo[i]
                        .getTourIntDays()));
            }

            messages.add(this.getClass().getName(), 
                    new BLogicMessage(INFO_TOUR, tourCount));

            if (log.isDebugEnabled()) {
                log.debug(INFO_TOUR + "cA[" + tourCount + "");
            }

        }

        // cA[o͒lɃZbgB
        rp_a01_01_01_02Output.setTourInfoList(tourInfo);
        rp_a01_01_01_02Output.setAllListInfoLineCount(tourCount);

        // ʂZbgB
        result.setMessages(messages);
        result.setResultObject(rp_a01_01_01_02Output);
        result.setResultString("success");

        return result;
    }

}