/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.core;

import java.util.LinkedHashMap;

import jp.terasoluna.fw.batch.openapi.JobContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Wũt[[NŋK肷ƒPʂǗAsNXB
 * 
 * <p><code>{@link JobWorker}</code> Ȃǂ̑ <code>{@link Workable}</code>
 * C^tF[X̎NXƋɁAƂ̊Kw\\B<code>JobManager
 * </code>́AƂ̊Kw\̒œ͏Ƃ̓͂ɑΉ鏈ǗB
 * <code>JobManager</code> ́AƊKw̒ŃWuɑΉƂs邾
 * łȂA"͏Ƃ̓͂ɑΉ鏈"ō\邷ׂĂ̍Ƃ
 * sB</p>
 * 
 * <p>Ƃ̊Kw̒ŁAƂŉwiƂȍƒPʁj̍Ƃ 
 * <code>JobWorker</code>ɂčs邪A<code>JobWorker</code> ͏
 * тĊǗƂ<code>JobManager</code> sBɂ́AWu
 * ȂǁA<code>JobManager</code>̓͂тKvꍇɂ́A
 * ʊKw <code>JobManager</code> ɂāA͏Ƃ̓͂
 *  <code>JobManager</code> ѕtB</p>
 * 
 * <p>ƊKẃA<code>Workable</code> C^tF[X̎NXKwI
 * ςݏグꂽR|Wbgȍ\ɂȂĂB<code>JobManager</code> ́A
 * ŉwȊO̕\B</p>
 * 
 * <p><strong>L[̍쐬ARN^Ăяo</strong></p>
 *
 * <p><code>JobManager</code> ł́A<code>workQueueFactory</code> 
 * ݒ肳ĂƃL[t@NgA͏ƁA̓͂Ƃ
 * Ԃ̃L[擾B</p>
 * 
 * <p>擾L[́A͏s <code>collector</code> ̃RN^
 * nB܂ÃNXł́ARN^̏ʃnȟĂяoƁA
 * ̓͏ŗOꍇ̗OnhĂяosB</p>
 * 
 * <p><strong>Ȉ</strong></p>
 *
 * <p>RN^ɂ͏AэƃL[ɃL[COꂽƂׂ̂Ă
 * I҂ƂŁÃNX̏̓^[B̃NX̏
 * ^[ۂɂ́AWuXe[^Xsi<code>JobStatus.STATE.STARTED
 * </code>A邢<code>JobStatus.STATE.RESTARTED</code>)łꍇɂ͐I
 * i<code>JobStatus.STATE.ENDING_NORMALLY</code>jɍXVB</p>
 * 
 * <p><strong>O</strong></p>
 * 
 * <p>RN^ɂ͏̋NsOɁA<code>preProcessor</code> 
 * ɐݒ肳ꂽT|[gvZbTɂđOsBOsꂽ
 * AWuXe[^X̃`FbNsBWuXe[^XpԂłȂꍇ
 * ɂ́ARN^ɂ͏Ȃǂ͋NꂸAɂ̃NX烊^[
 * B</p>
 * 
 * <p><strong>㏈</strong></p>
 * 
 * <p>RN^ɂ͏AэƃL[ɃL[COꂽƂI
 * ł́A<code>postProcessor</code> ɐݒ肳ꂽT|[gvZbTɂ
 * ㏈sBRN^ɂ͏AэƃL[ɃL[CO
 * ƂɂăWuXe[^XIAُIȂǂ̏IԂɍXV
 * ꍇɂ́AWu㏈͋NȂB</p>
 *
 */
public class JobManager implements Workable<WorkUnit> {

    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(JobManager.class);

    /**
     * RN^B
     */
    private Collector<JobContext> collector = null;

    /**
     * Ώۃf[^擾ʂ̃nhB
     */
    private CollectorResultHandler collectorResultHandler = null;

    /**
     * ƃL[̃t@NgB
     */
    private WorkQueueFactory workQueueFactory = null;

    /**
     * Wu}lW[B
     */
    private String name = null;

    /**
     * Onh`BOL[ƂāAL[̗OɑΉOnh
     * ݒ肷B
     */
    private LinkedHashMap<JobException, JobExceptionHandler> 
        exceptionHandlerMap = null;

    /**
     * ftHgOnhB
     */
    private JobExceptionHandler defaultJobExceptionHandler = null;

    /**
     * WuOsT|[gvZbTB
     */
    private SupportProcessor preProcessor = null;

    /**
     * Wu㏈sT|[gvZbTB
     */
    private SupportProcessor postProcessor = null;

    /**
     * ƂsB
     *
     * @param workUnit ƒP
     * @param jobStatus WuXe[^X
     */
    public void work(WorkUnit workUnit, JobStatus jobStatus) {
        JobStatus childJobStatus = null;
        childJobStatus = jobStatus.getChild(workUnit.getJobContext());
        
        //JnO
        writeStartLog(childJobStatus);

        preProcessor.process(workUnit.getJobContext(), childJobStatus);
        if (!childJobStatus.isContinue()) {
            return;
        }

        // {
        WorkQueue managerQueue = workQueueFactory.getWorkQueue(childJobStatus);

        processCollect(workUnit.getJobContext(), managerQueue, childJobStatus);

        managerQueue.waitForAllWorkers();

        postProcessor.process(workUnit.getJobContext(), childJobStatus);

        finishWork(jobStatus, childJobStatus);
        //IO
        writeEndLog(childJobStatus);
    }

    /**
     * ƏIsB
     * 
     * @param parentJobStatus ÑWuXe[^X
     * @param jobStatus ̃Wu}l[W̃WuXe[^X
     */
    protected void finishWork(JobStatus parentJobStatus, JobStatus jobStatus) {
        if (jobStatus.isExecuting() || jobStatus.isShutdownGraceful()
                || jobStatus.isShutdownImmediate()) {
            jobStatus.setJobState(JobStatus.STATE.ENDING_NORMALLY);
        }
    }

    /**
     * Ώۃf[^擾sB
     *
     * @param jobContext WuReLXg
     * @param workQueue Ώۃf[^i[pL[
     * @param jobStatus WuXe[^X
     */
    private void processCollect(JobContext jobContext, WorkQueue workQueue,
             JobStatus jobStatus) {
        CollectorResult collectorResult = null;
        try {
            collectorResult    = collector.collect(jobContext, workQueue,
                    jobStatus);

            collectorResultHandler.handle(collectorResult, jobStatus);
        } catch (RuntimeException e) {
            // CollectorACollectorʃnhŔȌ

            CollectorException wrappingException
                = new CollectorException(e, collectorResult);

            JobExceptionHandler handler
                = ExceptionHandlerUtil.getJobExceptionHandler(wrappingException,
                            exceptionHandlerMap, defaultJobExceptionHandler);

            handler.handlException(jobContext, wrappingException, jobStatus);
        }
    }

    /**
     * Ώۃf[^擾ʂ̃nhݒ肷B
     *
     * @param collectorResultHandler Ώۃf[^擾ʂ̃nh
     */
    public void setCollectorResultHandler(
            CollectorResultHandler collectorResultHandler) {
        this.collectorResultHandler = collectorResultHandler;
    }

    /**
     * ƃL[̃t@Ngݒ肷B
     *
     * @param workQueueFactory ƃL[̃t@Ng
     */
    public void setWorkQueueFactory(WorkQueueFactory workQueueFactory) {
        this.workQueueFactory = workQueueFactory;
    }

    /**
     * RN^ݒ肷B
     *
     * @param collector RN^
     */
    public void setCollector(Collector<JobContext> collector) {
        this.collector = collector;
    }

    /**
     * Wu}lW[ݒ肷B
     *
     * @param name Wu}lW[
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Wu㏈sT|[gvZbTݒ肷B
     *
     * @param postProcessor Wu㏈sT|[gvZbT
     */
    public void setPostProcessor(SupportProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    /**
     * WuOsT|[gvZbTݒ肷B
     *
     * @param preProcessor WuOsT|[gvZbT
     */
    public void setPreProcessor(SupportProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    /**
     * Onh`ݒ肷B
     *
     * @param exceptionHandlerMap Onh`
     */
    public void setExceptionHandlerMap(
         LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }

    /**
     * ftHgOnhݒ肷B
     * 
     * @param defaultJobExceptionHandler ftHgOnh
     */
    public void setDefaultJobExceptionHandler(
        JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }
    
    /**
     * JobManager̊JnOo͂B
     * 
     * @param jobStatus WuXe[^X
     */
    private void writeStartLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("ySTARTz");
            logStr.append(" [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("]");
            logStr.append(" [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("]");
            logStr.append(" [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("]");
            logStr.append(" [JobManagerName=");
            logStr.append(name);
            logStr.append("]");
            logStr.append(" [JobState=");
            logStr.append(jobStatus.getJobState());
            logStr.append("]");
            log.debug(logStr.toString());
        }
    }

    /**
     * JobManageȑIOo͂B
     * 
     * @param jobStatus WuXe[^X
     */
    private void writeEndLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("y END z");
            logStr.append(" [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("]");
            logStr.append(" [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("]");
            logStr.append(" [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("]");
            logStr.append(" [JobManagerName=");
            logStr.append(name);
            logStr.append("]");
            logStr.append(" [JobState=");
            logStr.append(jobStatus.getJobState());
            logStr.append("]");
            log.debug(logStr.toString());
        }
    }
}
