#ifndef _TMRSQRT_HPP
#define _TMRSQRT_HPP

#include <cmath>
#include <limits>

namespace tempest{
/*
	class math_number{ 
public:
	static const double pi = 3.141592653589793;//15...16
	static const double  e = 2.71828183;
};
*/
/*
	h = 1.0 - x * y*y;
	y = y * (1 + h * (8 + h * (6 + 5 * h)) *(1.0/16.0) );
*/
	
inline float approx_rsqrt(float x){
	int dx;
	float y,h;
	dx = (( 0xBE800000 - *reinterpret_cast<int*>(&x)) >> 1);//0xBE800000;//0x7f000000 + 0x3f800000-->(1.0<<1)+1.0
	y = *reinterpret_cast<float*>(&dx);
	//y = y*(1.47f- 0.47f * x*y*y);	
	/*
		y = y*(1.5f - 0.5f  * x*y*y);
		y = y*(1.5f - 0.5f  * x*y*y);
	*/
	
	h = 1.0f - x * y*y;
	//y = y * (1.0f + h * (8.0f         + h * ( 6.0f         + h * 5.0f         )) *(1.0f/16.0f) );
	y = y * (1.0f + h * ((8.0f/16.0f) + h * ( (6.0f/16.0f) + h * (5.0f/16.0f) )) );
	/*
	h = 1.0 - x * y*y;
	hh = h*h;
	y = y * (1 + (64 * h + hh * (48 + 40 * h + 35 * hh)) *(1.0/ 128) );
	*/
	return y;
}

inline double approx_rsqrt(double x){
	int dx;
	float f;
	double y;
	double h;
	
	f = static_cast<float>(x);
	dx = (( 0xBE800000 - *reinterpret_cast<int*>(&f)) >> 1);//0xBE800000;//0x7f000000 + 0x3f800000-->(1.0<<1)+1.0
	y = static_cast<double>(*reinterpret_cast<float*>(&dx));
	//y = y*(1.47- 0.47 * x*y*y);
	/*
		//2_
		y = y*(1.5 - 0.5  * x*y*y);
		y = y*(1.5 - 0.5  * x*y*y);
	*/
	
		//3_
		h = 1.0 - x * y*y;
		//y = y * (1 + h * (8 + h * (6 + 5 * h)) *(1.0/16.0) );
		y = y * (1.0 + h * ((8.0/16.0) + h * ( (6.0/16.0) + h * (5.0/16.0) )) );
	
	/*
	h = 1.0 - x * y*y;
	hh = h*h;
	y = y * (1 + (64 * h + hh * (48 + 40 * h + 35 * hh)) *(1.0/ 128) );
	*/
	return y;
}

inline long double approx_rsqrt(long double x){
	/*
	int dx;
	float f;
	long double y;
	
	f = static_cast<float>(x);
	dx = (( 0xBE800000 - *reinterpret_cast<int*>(&f)) >> 1);//0xBE800000;//0x7f000000 + 0x3f800000-->(1.0<<1)+1.0
	y = static_cast<long double>(*reinterpret_cast<float*>(&dx));
	y = y*(1.47- 0.47 * x*y*y);
	y = y*(1.5 - 0.5  * x*y*y);
	y = y*(1.5 - 0.5  * x*y*y);
	return y;
	*/
	return 1.0l/std::sqrt(x);
}


//is_iec559
template<class T, bool IS_IEEE = false>
struct rsqrt_struct{
	inline static T rsqrt(T x){return T(1)/std::sqrt(x);}	
};

template<class T>
struct rsqrt_struct<T,true>{
	inline static T rsqrt(T x){return approx_rsqrt(x);}	
};

template<class T>
inline T rsqrt(T x){
	return rsqrt_struct<T,std::numeric_limits<T>::is_iec559&&sizeof(float)==sizeof(int)>::rsqrt(x);	
}

#define DACARE_NEWTON_FUNCTION(TYPE)		\
inline TYPE newton_rsqrt(TYPE n, TYPE xn){	\
	return 0.5 * xn * (3.0 - n * xn * xn);	\
}											\
inline TYPE newton_rcp(TYPE n, TYPE xn){	\
	return xn * (2.0 - n * xn);				\
}											\

	DACARE_NEWTON_FUNCTION(float)
	DACARE_NEWTON_FUNCTION(double)
	DACARE_NEWTON_FUNCTION(long double)
	
#undef DACARE_NEWTON_FUNCTION

	
/*	
template<class T>
T rsqrt(T x){return T(1)/std::sqrt(x);}

float rsqrt(float x){
	//return newton_rsqrt(x,approx_rsqrt(x));
	//return newton_rsqrt(x,newton_rsqrt(x,approx_rsqrt(x)) );	
	return float(1)/std::sqrt((float)x);
}
double rsqrt(double x){return double(1)/std::sqrt(x);}
long double rsqrt_imp(long double x){typedef long double ld;return ld(1)/std::sqrt(x);}
*/
	
}
#endif


