#include"../vector/safety_vector.hpp"
#include"../vector/vector.hpp"
#include"../vector/safety_matrix.hpp"

#include<complex>
#include<iostream>
#include<vector>
#include<list>

template<class IT>
void disp(IT a,IT b){
	std::cout << "-------" << std::endl;
	while(a != b){
		std::cout << *a << std::endl;
		++a;
	}
	std::cout << "-------" << std::endl;
}

int func(){
	static int p = 0;
	return p++;
}

class test_obj{
public:
	int my_counter;
public:
	test_obj():my_counter( func() ){		
		std::cout<< "constructor!"<< my_counter <<"\n";
	}
	test_obj(const test_obj& k):my_counter( k.my_counter){
		std::cout<< "copy constructor!"<< my_counter <<"\n";
	}
	test_obj(int i):my_counter( i ){
		std::cout<< "constructor!"<< my_counter <<"\n";
	}
	~test_obj(){
		std::cout<< "destructor!"<<my_counter<<"\n";	
	}
	int get(){
		return my_counter;
	}
	
};

int main(){
	typedef tempest::safety_vector<double,3> safe;
	typedef tempest::safety_vector<std::complex<double>,3> safe_c;
	//typedef tempest::vector<::std::complex<double>,3> vector;
	
	
	typedef tempest::safety_vector<test_obj,3> SF;
	typedef tempest::vector<test_obj,3> ZF;
	typedef std::vector<test_obj> VF;
	typedef std::list<test_obj> LF;
	
	
	std::cout<<"//////////////////////////////////////////////\n\n";
	//test_obj::counter=0;
	std::cout<<"\ntempest::safety_vector\n";
	{
		SF sf;
	}
	
	std::cout<<"\nstd::vector\n";
	{
		VF vf(3);
	}
	std::cout<<"\ntempest::vector\n";
	{
		ZF zf;
	}
	
	std::cout<<"\ntempest::safety_vector with copy by std::list\n";
	{
		LF v(6);
		std::cout<<"\n";
		SF sf(v.begin(),v.end());
		std::cout<<"\n";
	}
	
	std::cout<<"\ntempest::safety_vector with copy by std::vector\n";
	{
		VF v(6);
		std::cout<<"\n";
		SF sf(v.begin(),v.end());
		std::cout<<"\n";
	}
	
	std::cout<<"\n\n";
	//std::cout << sv1 <<"  ,  "<< sv2 << std::endl;
	
	std::cout<<"//////////////////////////////////////////////\n\n";
	
	tempest::safety_matrix<std::complex<double>,2,2> cm1,cm2;
	for(int i = 0;i<2;i++){
		for(int j = 0;j<2;j++){
			cm2[i][j] = cm1[i][j] = std::complex<double>(2*i+j,i);
		}
	}
	
	disp(cm1.begin(),cm1.end());
	
	std::cout << cm1<<"\n , \n"<< cm2 <<"\n = \n"<< cm1+cm2  << std::endl;
	
	std::cout << cm1[1][1]  << std::endl;
	
	try{
		std::cout << cm1[3][2] << std::endl;	
	}catch(...){
		std::cout << "ERROR" <<std::endl;
	}
	
	std::cout<<"//////////////////////////////////////////////\n\n";
	{
		tempest::safety_vector<tempest::safety_vector<test_obj,2>,2> tm;
		
		std::cout << tm[1][1].get() << std::endl;
	}
	
	std::cout<<"//////////////////////////////////////////////\n\n";
	{
		std::vector<std::vector<test_obj> > tm(2);tm[0].resize(2);tm[1].resize(2);
		
		std::cout << tm[1][1].get() << std::endl;
	}
	std::cout<<"//////////////////////////////////////////////\n\n";
	tempest::safety_matrix<double,2,2> dm1,dm2;
	//tempest::safety_vector< tempest::safety_vector<double,2>, 2 > dm1,dm2;
	for(int i = 0;i<2;i++)
		for(int j = 0;j<2;j++)
			dm2[i][j] = dm1[i][j] = 2*i+j;
	
	if(dm1 == dm2){
		std::cout<< dm1 <<" == "<< dm2 << std::endl;	
	}
	std::cout<< dm1 <<" + "<< dm2 << " = " << (dm1+dm2) << std::endl;
	
	tempest::safety_vector<std::complex<double> ,2> s1,s2;
	for(int i=0;i<2;i++){
		s1[i]  = i;s2[i] = 2*i;
	}
	
	std::cout << s1<<","<<s2 <<std::endl;
	s1.swap(s2);
	std::cout << s1<<","<<s2 <<std::endl;
	
	std::cout << s1+s2 <<std::endl;
	
	return 0;	
}









