#include<iostream>
#include<iomanip>
#include"../vector/vector3.hpp"
#include"../vector/quaternion.hpp"

#include"../vector/matrix.hpp"
#include"../vector/matrix3.hpp"
#include"../vector/matrix_generator.hpp"
#include"../vector/transform.hpp"

double radian(double degree){
	return degree /180.0 * 3.14159;
}

int main(){
	typedef tempest::quaternion<double> QTRN;
	typedef tempest::vector<double,3> VCTR;
	typedef tempest::matrix<double,3> MTRX;
	typedef tempest::matrix_generator<MTRX> MTGEN;
	
	double theta = 30./180 * 3.14;
	double theta2 = 90./180 * 3.14;
	
	VCTR v(1,0,0);
	v.normalize();
	
	QTRN q(v,theta);
	QTRN q2(-v,theta);
	QTRN q3(q[0],-q[1],-q[2],-q[3]);
	
	std::cout<< std::setprecision(2);
	std::cout.setf(std::ios_base::fixed);
	
	std::cout << q << std::endl;
	std::cout << q* ~q << std::endl;
	std::cout << q3 << std::endl;
	
	std::cout << std::endl;
	
	std::cout << q*q3 << std::endl;
	std::cout << dot(q,q) << std::endl;
	
	std::cout << std::endl;
	
	std::cout << MTGEN::q2m(q) <<"\n"<< std::endl;
	
	std::cout << MTGEN::x_rotate(theta) <<"\n"<< std::endl;
	
	std::cout << MTGEN::q2m(q2) <<"\n"<< std::endl;
	
	std::cout << MTGEN::q2m(q * ~q) <<"\n"<< std::endl;
	
	std::cout << MTGEN::q2m(q2 * ~q2) <<"\n"<< std::endl;
	
	std::cout << std::endl;	
	
	double phi1 = -30./180 * 3.14;
	double phi2 = 270./180 * 3.14;
	VCTR axis(1,3,4);
	axis.normalize();
	
	QTRN qx1(axis,phi1);
	QTRN qx2(axis,phi2);
	
	std::cout << qx1 << std::endl;
	std::cout << qx2 << std::endl;
	
	std::cout<<"angle:slerp:lerp"<<std::endl;
	for(int i = 0;i<20;i++){
		double t = i/20.;
		std::cout << ((1-t)*phi1+t*phi2)*180./3.14<<":";
		QTRN temp1(slerp(qx1,qx2,t));
		std::cout << 2*std::atan2(temp1[1]/axis[0],temp1[0])*180./3.14 <<":";
		QTRN temp2(lerp(qx1,qx2,t));
		std::cout << 2*std::atan2(temp2[1]/axis[0],temp2[0])*180./3.14 <<std::endl;
	}
	
	std::cout << std::endl;
	
	VCTR out;
	
	const int num = 10;
	for(int i = 0;i<=num;i++){
		tempest::transform(QTRN(VCTR(1,0,0),radian((90.*i)/num)),VCTR(0,1,0),out);	
		std::cout << out << std::endl;
	}
	
	
	return 0;
}


