### !/bin/bash
### Tavouries install script
### by fa2_l <ifa26417@outlook.com.vn>

## Variables
[ -z "$dotfilesrepo" ] && repodir="https://github.com/TCH69/tavodotfiles.git"


installpkg(){ pacman --noconfirm --needed -S "$1" >/dev/null 2>&1 ;}
updatepkg(){ pacman --noconfirm --needed -Syyu >/dev/null 2>&1 ;}

repseq="\"^[PGA]*,\""

## Functions

error() { printf "Stopped. ERROR:\\n%s\\n" "$1"; exit;}

start() { \
     dialog --title "Welcome to Tavouries!" --msgbox "Hi. This *small (no i mean big) script will install Tavouries for you. Just press OK to continue." 10 60
     dialog --colors --title "Important!" --yes-lable "OK, let's continue" --no-lable "I think I gonna stop here.." --yesno "This script will NOT install any bootloader on your system, so you have to install it yourself, otherwise the system will not boot." 8 70
     dialog --msgbox "If everything is ready, let's get it!" 10 60
     }

systemupdate() { \
     dialog --infobox "Running pacman -Syyu to make sure your system is up-to-date.." 5 70
     updatepkg
     }

basesystem() { \
     dialog --infobox "Installing base, base-devel, openrc and stuffs that required to the system to work.." 5 70
     installpkg base base-devel linux intel-ucode amd-ucode 
     }

useraccount() { \
     name=$(dialog --inputbox "First, please enter a name for the user account." 10 60 3>&1 1>&2 2>&3 3>&1) || exit
     while ! echo "$name" | grep "^[a-z_][a-z0-9_-]*$" >/dev/null 2>&1; do
         name=$(dialog --no-cancel --inputbox "Username not valid. Give a username beginning with a letter, with only lowercase letters, - or _." 10 60 3>&1 1>&2 2>&3 3>&1)
     done
     pass1=$(dialog --no-cancel --passwordbox "Enter a password for that user." 10 60 3>&1 1>&2 2>&3 3>&1)
     pass2=$(dialog --no-cancel --passwordbox "Retype password." 10 60 3>&1 1>&2 2>&3 3>&1)
     while ! [ "$pass1" = "$pass2" ]; do
         unset pass2
         pass1=$(dialog --no-cancel --passwordbox "Passwords do not match.\\n\\nEnter password again." 10 60 3>&1 1>&2 2>&3 3>&1)
         pass2=$(dialog --no-cancel --passwordbox "Retype password." 10 60 3>&1 1>&2 2>&3 3>&1)
     done ;}

usercheck() { \
     ! (id -u "$name" > /dev/null) 2>&1 ||
     dialog --colors --title "Warning!" --yes-label "Yes, continue." --no-label "Wait a second.." --yesno "The username \`$name\` did exist on your system. Do you want to continue?\\n\\You can still continue, but all the settings of that user will be override, so be careful." 14 70
     }

preinstallmessage() { \
     dialog --title "Start the installation!"  --yes-label "Yes!" --no-lable "No wait.." --yesno "The install process will now automated, so you can sit back and relax while Tavo's installing the system for you." 13 60  || { clear; exit; }
     }

useradding() { \
     dialog --infobox "Adding user \"$name\"..." 4 50
     useradd -m -g wheel -s /bin/bash "$name" >/dev/null 2>&1 ||
     usermod -a -G wheel "$name" && mkdir -p /home/"$name" && chown "$name":wheel /home/"$name"
     echo "$name:$pass1" | chpasswd
     unset pass1 pass2 ;}

refreshkeys() { \
     dialog --infobox "Refreshing keyrings..." 4 40
     pacman --noconfirm -Sy archlinux-keyring artix-keyring  >/dev/null 2>&1
     }

#permissions() { \
#     sed -i "/#TAVO/d" /etc/sudoers
#     echo "$* #TAVO" >> /etc/sudoers ;}
#     }

xorg_install() { \
     dialog --infobox "Installing Xorg.." 4 40
     installpkg xorg xorg-xinit xorg-server
     }

network_install() { \
     dialog --infobox "Installing NetworkManager and dependencies.."
     installpkg networkmanager networkmanager-openrc dbus
     }

network_enable() { \
     dialog --infobox "Enabling NetworkManager.."
     rc-update add networkmanager default
     }

video_driver() { \
     dialog --infobox "Installing xorg-drivers.." 4 50
     installpkg xorg-drivers
     }

desktop_install() { \
     dialog --infobox "Installing packages for your desktop, like firefox, pcmanfm or IBus.." 4 70
     installpkg firefox pcmanfm file-roller ibus ibus-unikey spectrwm rxvt-unicode ttf-roboto ttf-roboto-mono
     }

dotfiles_install() { \
     dialog --infobox "Downloading and installing config files.." 4 60
     sudo -u "$name" git clone $dotfilesrepo /home/$name/
     sudo -u "$name" rm -rf /home/$name/.git /home/$name/README.md
     }

theme() { \
     dialog --infobox "Install theme.." 4 40
     git clone https://github.com/madgrid/plata-theme-compiled /usr/share/themes
     rm -rf /usr/share/themes/.git /usr/share/themes/README.md
     }

final() { \
     dialog --infobox "Completing.." 2 15
     dialog --title "Completed!" --msgbox "Now you can quit this, install grub for your system, then it should boot!\\n\\After reboot and login as your newly created user, type 'startx' to start the desktop environment." 12 90
     }

## This is where the script actually start

# Check if user is root then install base system
installpkg dialog base base-devel || error "Are you really running this as root and have an internet connection?"

# Welcome user to the "installer"
start || error "User exited."

# Get username and password
useraccount || error "User exited."

# Give warning if user already exist on the system
usercheck || error "User exited."

# Last change for user to exit before the installation begin
#preinstallmessage || error "User exited."

# Error while adding user
useradding || error "Error adding username and password."

# Refresh ArchLinux and ArtixLinux keyring
refreshkeys || error "Error when refreshing keyrings. Consider doing it yourself."

# Install graphical environment
dialog --title "Tavouries Installation" --infobox "Installing \'OpenRC\', \'base\', \'base-devel\' and \'git\' for installing other software required for this installation.."  5 70
installpkg openrc eudev-openrc elogind-openrc
installpkg base base-devel linux linux-firmware
installpkg git

[ -f /etc/sudoers.pacnew ] && cp /etc/sudoers.pacnew /etc/sudoers

newperm "%wheel ALL=(ALL) NOPASSWD: ALL"
xorg_install
network_install
network_enable
video_driver
desktop_install
theme
dotfiles_install

newperms "%wheel ALL=(ALL) ALL
%wheel ALL=(ALL) NOPASSWD: /usr/bin/shutdown,/usr/bin/reboot,/usr/bin/halt"


## Last message, install completed.
finalize
clear

