/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx;

import static org.junit.Assert.*;

import java.util.HashMap;
import java.util.Map;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * GtxContextTest.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/04/17
 * @since   JDK5.0 Tiger
 */
public class GtxContextTest {
	
	private GtxContext _target = new GtxContext();

	@Before
	public void setUp() throws Exception {
		
		GtxContext parent = new GtxContext();
		parent.put("key1", "parent1");
		parent.put("key2", "parent2");
		
		_target = new GtxContext();
		_target.put("key2", "child2");
		_target.put("key3", "child3");
		_target.setParent(parent);
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testSearch() {
		
		String value = (String) _target.search("key1");
		assertEquals(value, "parent1");

		value = (String) _target.search("key2");
		assertEquals(value, "child2");

		value = (String) _target.search("key3");
		assertEquals(value, "child3");

		value = (String) _target.search("key4");
		assertNull(value);
	}

	@Test
	public void testFlatten() {
		
		Map<String, Object> expected = new HashMap<String, Object>();
		expected.put("key1", "parent1");
		expected.put("key2", "child2");
		expected.put("key3", "child3");
		
		System.out.println("expected: " + expected);
		
		Map<String, Object> result = _target.flatten();
		
		System.out.println("result: " + result);
		
		assertEquals(result, expected);
	}

}
