/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.node;


import jp.sf.tatooine.gtx.GtxContext;
import jp.sf.tatooine.gtx.GtxSyntaxException;

/**
 * ProcessingInstructionNode.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/09/10
 * @since   JDK5.0 Tiger
 */
public class ProcessingInstructionNode extends Node {

	private String _target;
	
	private String _data;

	public ProcessingInstructionNode(String target, String data) {
		_target = target;
		_data = data;
	}
	
	public String getTarget() {
		return _target;
	}

	public String getData() {
		return _data;
	}

	/**
	 * @see jp.sf.tatooine.gtx.node.GtxEvaluateable
	 * 		#evaluate(StringBuilder, jp.sf.tatooine.gtx.GtxContext)
	 */
	public void evaluate(StringBuilder builder, GtxContext context) throws GtxSyntaxException {
		builder.append(toString());
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append(START_TAG_PREFIX);
		builder.append("?");
		builder.append(_target);
		builder.append(" ");
		builder.append(_data);
		builder.append(" ?");
		builder.append(TAG_POSTFIX);
		
		return builder.toString();
	}
	
	
}
