/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.node;

import jp.sf.tatooine.base.OftenUsedStrings;

/**
 * gtx属性型.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/09/07
 * @since   JDK5.0 Tiger
 */
public class GtxAttribute extends Attribute {
	
	/** 名前空間プレフィックス */
	private String _prefix;
	
	/**
	 * コンストラクタ.
	 * 
	 * @param type		属性の種類
	 * @param gtxNS		gtx名前空間名
	 * @param name		属性名
	 * @param value		属性値
	 */
	public GtxAttribute(
			GtxAttributeType type, 
			String prefix, 
			String name, 
			String value) {
		
		super(type, name, value);
		_prefix = prefix;
	}
	
	/**
	 * 名前空間プレフィックスを取得する.
	 * 
	 * @return	名前空間プレフィックス
	 */
	public String getPrefix() {
		return _prefix;
	}

	/**
	 * @see jp.sf.tatooine.gtx.node.Attribute#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append(_prefix);
		builder.append(OftenUsedStrings.COLON);
		builder.append(super.toString());
		return builder.toString();
	}
	
}
