/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.node;

import jp.sf.tatooine.gtx.ELUtils;
import jp.sf.tatooine.gtx.GtxContext;
import jp.sf.tatooine.gtx.GtxSyntaxException;

/**
 * 属性.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/09/07
 * @since   JDK5.0 Tiger
 */
public class Attribute implements GtxEvaluateable {
	
	public static final String VALUE_PREFIX = "=\"";
	
	public static final String VALUE_POSTFIX = "\"";

	/** 属性の種類 */
	private GtxAttributeType _type;
	
	/** 属性名 */
	private String _name;
	
	/** 属性値 */
	private String _value;

	/**
	 * コンストラクタ.
	 * 
	 * @param name		属性名
	 * @param value		属性値
	 */
	public Attribute(
			GtxAttributeType type, 
			String name, 
			String value) {
		
		_type = type;
		_name = name;
		_value = value;
	}
	
	/**
	 * 属性の種類を取得する.
	 * 
	 * @return	属性の種類
	 */
	public GtxAttributeType getType() {
		return _type;
	}

	/**
	 * 属性名を取得する.
	 * 
	 * @return 属性名
	 */
	public String getName() {
		return _name;
	}

	/**
	 * 属性値を取得する.
	 * 
	 * @return 属性値
	 */
	public String getValue() {
		return _value;
	}

	/**
	 * @see jp.sf.tatooine.gtx.node.GtxEvaluateable
	 * 		#evaluate(StringBuilder, jp.sf.tatooine.gtx.GtxContext)
	 */
	public void evaluate(StringBuilder builder, GtxContext context) 
			throws GtxSyntaxException {
		
		builder.append(_name);
		builder.append(VALUE_PREFIX);
		builder.append(ELUtils.evaluateEL(context, _value));
		builder.append(VALUE_POSTFIX);
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		
		StringBuilder builder = new StringBuilder();
		builder.append(_name);
		builder.append(VALUE_PREFIX);
		builder.append(_value);
		builder.append(VALUE_POSTFIX);
		return builder.toString();
	}
	
}
