/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx;

import java.util.HashMap;
import java.util.Map;

/**
 * GtxContext.
 * <p>
 * コンテキストパラメータを保持する.
 * 
 * @author  Tooru Noda
 * @version 1.0 2007/04/11
 * @since   JDK5.0 Tiger
 */
public class GtxContext extends HashMap<String, Object> {
	
	private static final long serialVersionUID = 1L;
	
	/** 上位コンテキスト */
	private GtxContext _parent = null;
	
	/**
	 * 上位階層のコンテキストを設定する.
	 * 
	 * @param parent	上位階層のコンテキスト
	 */
	protected final void setParent(GtxContext parent) {
		_parent = parent;
	}

	/**
	 * 設定されたコンテキストパラメータを検索する.
	 * 
	 * @param 	key	コンテキストキー
	 * @return	コンテキストパラメータ
	 */
	protected final Object search(String key) {
		if (containsKey(key)) {
			return get(key);
		}
		if (_parent != null) {
			return _parent.search(key);
		}
		return null;
	}
	
	/**
	 * 階層で管理された<code>Map</code>を平坦な１つの<code>Map</code>に変換する.
	 * 
	 * @return	変換後の<code>Map</code>
	 */
	public final Map<String, Object> flatten() {
		Map<String, Object> map;
		if (_parent != null) {
			map = _parent.flatten();
		}
		else {
			map = new HashMap<String, Object>();
		}
		map.putAll(this);
		
		return map;
	}
	
//	public void bindById(String id, Map map) {
//		
//	}
}
