/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.filter;

import static org.junit.Assert.*;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * LeftTest.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/04/18
 * @since   JDK5.0 Tiger
 */
public class LeftTest {

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testInvokeN1() {
		Left target = new Left();
		String[] args = {"3"};
		String result = target.invoke("1230000000", args);
		assertEquals("123", result);
	}

	@Test
	public void testInvokeE1() {
		Left target = new Left();
		String[] args = {};
		try {
			String result = target.invoke("1230000000", args);
			fail(result);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Test
	public void testInvokeE2() {
		Left target = new Left();
		String[] args = {"3", "4"};
		try {
			String result = target.invoke("1230000000", args);
			fail(result);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Test
	public void testInvokeE3() {
		Left target = new Left();
		String[] args = {"-10"};
		try {
			String result = target.invoke("1230000000", args);
			fail(result);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
}
