/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.ui.swing;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jp.sourceforge.talisman.hermes.HermesContextExporter;
import jp.sourceforge.talisman.hermes.ui.swing.CurrentDirectoryHandler;
import jp.sourceforge.talisman.hermes.ui.swing.HermesContextBuilder;

class SaveAction
extends AbstractAction {
    private static final long serialVersionUID = -1231038425322405695L;
    private HermesContextBuilder parent;
    private CurrentDirectoryHandler handler;

    public SaveAction(HermesContextBuilder parent, CurrentDirectoryHandler handler) {
        super("Save");
        this.parent = parent;
        this.handler = handler;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser(this.handler.getCurrentDirectory());
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        this.handler.registerFileFilter(chooser);
        int value = chooser.showSaveDialog(this.parent);
        if (value == 0) {
            this.handler.setCurrentDirectory(chooser.getCurrentDirectory());
            File target = chooser.getSelectedFile();
            try {
                new HermesContextExporter().export(target, this.parent.getContext());
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this.parent, e1.getMessage());
            }
        }
    }
}

