/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.ui.swing;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jp.sourceforge.talisman.hermes.HermesContext;
import jp.sourceforge.talisman.hermes.HermesContextParser;
import jp.sourceforge.talisman.hermes.InvalidHermesConfigException;
import jp.sourceforge.talisman.hermes.ui.swing.CurrentDirectoryHandler;
import jp.sourceforge.talisman.hermes.ui.swing.HermesContextBuilder;

class LoadAction
extends AbstractAction {
    private static final long serialVersionUID = 147877202111907178L;
    private HermesContextBuilder builder;
    private CurrentDirectoryHandler handler;

    public LoadAction(HermesContextBuilder builder, CurrentDirectoryHandler handler) {
        super("Load");
        this.builder = builder;
        this.handler = handler;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            JFileChooser chooser = new JFileChooser(this.handler.getCurrentDirectory());
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            this.handler.registerFileFilter(chooser);
            int value = chooser.showOpenDialog(this.builder);
            if (value == 0) {
                this.handler.setCurrentDirectory(chooser.getCurrentDirectory());
                File file = chooser.getSelectedFile();
                HermesContextParser parser = new HermesContextParser();
                HermesContext context = parser.parse(file);
                this.builder.setContext(context);
            }
        }
        catch (InvalidHermesConfigException e1) {
            JOptionPane.showMessageDialog(this.builder, e1.getLocalizedMessage());
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this.builder, e1.getLocalizedMessage());
        }
    }
}

