/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.maven;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.talisman.hermes.DomUtils;
import jp.sourceforge.talisman.hermes.maven.RepositoryIOException;
import jp.sourceforge.talisman.hermes.maven.RepositoryItem;
import jp.sourceforge.talisman.hermes.maven.RepositoryItemMismatchException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class RepositoryItemParser {
    private RepositoryItem item;

    public RepositoryItemParser(RepositoryItem item) {
        this.item = item;
    }

    public void parse(InputStream in) throws RepositoryIOException {
        try {
            Element root = DomUtils.readRootElement(in);
            this.checkRepositoryItem(root);
            this.parseElement(root);
        }
        catch (RepositoryIOException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new RepositoryIOException(e);
        }
        catch (IOException e) {
            throw new RepositoryIOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryIOException(e);
        }
    }

    private void checkRepositoryItem(Element root) throws RepositoryIOException {
        String artifactId = DomUtils.getContentOfElement(root, "artifactId");
        String groupId = DomUtils.getContentOfElement(root, "groupId");
        if (!this.item.getArtifactId().equals(artifactId)) {
            throw new RepositoryItemMismatchException(String.format("artifactId is expected <%s>, but <%s>", this.item.getArtifactId(), artifactId));
        }
        if (!this.item.getGroupId().equals(groupId)) {
            throw new RepositoryItemMismatchException(String.format("groupId is expected <%s>, but <%s>", this.item.getGroupId(), groupId));
        }
    }

    protected abstract void parseElement(Element var1) throws RepositoryIOException;
}

