/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import jp.sourceforge.talisman.hermes.RepositoryScope;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.ItemFetcher;
import jp.sourceforge.talisman.hermes.maven.Metadata;
import jp.sourceforge.talisman.hermes.maven.MetadataParser;
import jp.sourceforge.talisman.hermes.maven.ProjectObjectModel;
import jp.sourceforge.talisman.hermes.maven.ProjectObjectModelParser;
import jp.sourceforge.talisman.hermes.maven.RepositoryIOException;
import jp.sourceforge.talisman.hermes.maven.RepositoryItemNotFoundException;

public class Repository
implements Serializable {
    private static final long serialVersionUID = 3922032760947434478L;
    private static final Repository LOCAL_REPOSITORY;
    private transient ItemFetcher fetcher;
    private String id;
    private String name;
    private URL location;

    public Repository(String id, String name, URL location) {
        this(location);
        this.id = id;
        this.name = name;
    }

    public Repository(URL location) {
        this.location = location;
    }

    public static final Repository getLocalRepository() {
        return LOCAL_REPOSITORY;
    }

    public boolean contains(Artifact artifact) throws IOException {
        if (!artifact.hasVersion()) {
            return this.contains(artifact.getGroupId(), artifact.getArtifactId());
        }
        URL url = new URL(this.location + artifact.getRelativePath() + "/" + artifact.getFileName());
        try {
            return url.getContent() != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean contains(String groupId, String artifactId) throws IOException {
        URL url = new URL(this.location + groupId.replace('.', '/') + "/" + artifactId);
        try {
            return url.getContent() != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean contains(String groupId, String artifactId, String version) throws IOException {
        boolean flag = version == null ? this.contains(groupId, artifactId) : this.contains(new Artifact(groupId, artifactId, version));
        return flag;
    }

    public boolean equals(Object o) {
        if (o instanceof Repository) {
            Repository r = (Repository)o;
            boolean flag = this.getLocation().equals(r.getLocation());
            flag = this.getId() != null ? (flag &= this.getId().equals(r.getId())) : (flag &= r.getId() == null);
            flag = this.getName() != null ? (flag &= this.getName().equals(r.getName())) : (flag &= r.getName() == null);
            return flag;
        }
        return false;
    }

    public Artifact findArtifact(Artifact origArtifact) throws IOException {
        if (origArtifact.hasVersion() && origArtifact.getPom().isAlreadyRead()) {
            return origArtifact;
        }
        Artifact artifact = origArtifact;
        if (!origArtifact.hasVersion()) {
            artifact = this.findLatestVersion(artifact);
        }
        if (artifact.hasVersion()) {
            this.parsePom(artifact.getPom());
            return artifact;
        }
        throw new RepositoryItemNotFoundException(String.format("%s.%s is not found.", origArtifact.getGroupId(), origArtifact.getArtifactId()));
    }

    public Artifact findLatestVersion(Artifact artifact) throws IOException {
        try {
            String latestVersion = this.getLatestVersion(artifact);
            return new Artifact(artifact.getGroupId(), artifact.getArtifactId(), latestVersion);
        }
        catch (RepositoryItemNotFoundException e) {
            return artifact;
        }
    }

    public synchronized ItemFetcher getFetcher() {
        if (this.fetcher == null) {
            this.fetcher = new ItemFetcher(this);
        }
        return this.fetcher;
    }

    public String getId() {
        return this.id;
    }

    public URL getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        return result;
    }

    public boolean isAllowed(RepositoryScope scope) {
        return scope.isScope(this.getLocation());
    }

    public boolean isSameLocation(URL location) {
        return this.getLocation().sameFile(location);
    }

    private String getLatestVersion(Artifact artifact) throws IOException {
        Metadata metadata = new Metadata(artifact.getGroupId(), artifact.getArtifactId());
        InputStream in = this.getFetcher().fetch(metadata);
        new MetadataParser(metadata).parse(in);
        return metadata.getLatestVersion();
    }

    private void parsePom(ProjectObjectModel pom) throws IOException, RepositoryIOException {
        InputStream in = this.getFetcher().fetch(pom);
        new ProjectObjectModelParser(pom).parse(in);
        pom.setRepository(this);
        if (pom.getParent() != null) {
            this.parsePom(pom.getParent());
        }
        pom.setAlreadyRead(true);
    }

    static {
        try {
            LOCAL_REPOSITORY = new Repository("local", "Maven Local Repository", new File(System.getProperty("user.home"), ".m2/repository").toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new InternalError();
        }
    }
}

