/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes;

import java.io.Serializable;

public class Version
implements Serializable,
Comparable<Version> {
    private static final long serialVersionUID = 7980518164461500648L;
    private String[] strings;
    private String original;
    private String separator;

    public Version(String versionString) {
        this(versionString, "[-.]");
    }

    public Version(String versionString, String separateRegex) {
        this.original = versionString;
        this.strings = versionString.split(separateRegex);
        this.separator = separateRegex;
    }

    public boolean isSnapshot() {
        return this.original.toLowerCase().endsWith("snapshot");
    }

    public String toString() {
        return this.original;
    }

    public int hashCode() {
        return this.original.hashCode() | this.separator.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Version && this.compareTo((Version)o) == 0;
    }

    @Override
    public int compareTo(Version version) {
        int v = 0;
        String[] s1 = this.copyStringArray(this.strings);
        String[] s2 = this.copyStringArray(version.strings);
        int index = 0;
        for (int i = 0; i < s1.length && i < s2.length; ++i) {
            if (!s1[i].equals(s2[i])) {
                try {
                    int i1 = Integer.parseInt(s1[i]);
                    int i2 = Integer.parseInt(s2[i]);
                    if (i1 < i2) {
                        v = -1;
                        break;
                    }
                    v = 1;
                }
                catch (NumberFormatException e) {
                    if (s1[i].compareTo(s2[i]) < 0) {
                        v = -1;
                        break;
                    }
                    v = 1;
                }
                break;
            }
            ++index;
        }
        if (v == 0 && (index != s1.length || index != s2.length)) {
            v = s1.length < s2.length ? -1 : 1;
        }
        return v;
    }

    private String[] copyStringArray(String[] values) {
        String[] strings = new String[values.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = values[i].toLowerCase();
            if (strings[i].equals("alpha")) {
                strings[i] = "1a";
                continue;
            }
            if (strings[i].equals("beta")) {
                strings[i] = "1b";
                continue;
            }
            if (strings[i].equals("gamma")) {
                strings[i] = "1c";
                continue;
            }
            if (strings[i].equals("delta")) {
                strings[i] = "1d";
                continue;
            }
            if (strings[i].equals("epsilon")) {
                strings[i] = "1e";
                continue;
            }
            if (strings[i].equals("zeta")) {
                strings[i] = "1f";
                continue;
            }
            if (strings[i].equals("eta")) {
                strings[i] = "1g";
                continue;
            }
            if (strings[i].equals("theta")) {
                strings[i] = "1h";
                continue;
            }
            if (strings[i].equals("iota")) {
                strings[i] = "1i";
                continue;
            }
            if (strings[i].equals("kappa")) {
                strings[i] = "1j";
                continue;
            }
            if (strings[i].equals("lambda")) {
                strings[i] = "1k";
                continue;
            }
            if (strings[i].equals("mu")) {
                strings[i] = "1l";
                continue;
            }
            if (strings[i].equals("nu")) {
                strings[i] = "1m";
                continue;
            }
            if (strings[i].equals("xi")) {
                strings[i] = "1n";
                continue;
            }
            if (strings[i].equals("o")) {
                strings[i] = "1o";
                continue;
            }
            if (strings[i].equals("pi")) {
                strings[i] = "1p";
                continue;
            }
            if (strings[i].equals("rho")) {
                strings[i] = "1q";
                continue;
            }
            if (strings[i].equals("sigma")) {
                strings[i] = "1r";
                continue;
            }
            if (strings[i].equals("tau")) {
                strings[i] = "1s";
                continue;
            }
            if (strings[i].equals("upsilon")) {
                strings[i] = "1t";
                continue;
            }
            if (strings[i].equals("phi")) {
                strings[i] = "1u";
                continue;
            }
            if (strings[i].equals("chi")) {
                strings[i] = "1v";
                continue;
            }
            if (strings[i].equals("psi")) {
                strings[i] = "1w";
                continue;
            }
            if (strings[i].equals("omega")) {
                strings[i] = "1x";
                continue;
            }
            if (strings[i].equals("snapshot")) {
                strings[i] = "0a";
                continue;
            }
            if (!strings[i].startsWith("rc")) continue;
            strings[i] = "2" + strings[i].substring(2);
        }
        return strings;
    }
}

