/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.talisman.hermes.RepositoryScope;
import jp.sourceforge.talisman.hermes.UpdatingLibraryCheckPolicy;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.DependencyScope;
import jp.sourceforge.talisman.hermes.maven.Repository;

public class HermesContext
implements Serializable,
Iterable<Artifact> {
    private static final long serialVersionUID = 3130612309057960466L;
    private String destination;
    private UpdatingLibraryCheckPolicy policy;
    private RepositoryScope scope;
    private List<Artifact> dependencies;
    private List<PropertyChangeListener> propertyChangeListeners;
    private List<Repository> repositories = new ArrayList<Repository>();
    private Set<DependencyScope> dependencyScopes;
    private Map<String, List<String>> ignores;

    public HermesContext() {
        this(Repository.getLocalRepository());
    }

    HermesContext(Repository localRepository) {
        this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
        this.ignores = new HashMap<String, List<String>>();
        this.dependencyScopes = new HashSet<DependencyScope>();
        this.dependencies = new ArrayList<Artifact>();
        this.scope = RepositoryScope.BOTH;
        this.policy = UpdatingLibraryCheckPolicy.DESTINATION_CHECK;
        this.repositories.add(localRepository);
        this.dependencyScopes.add(DependencyScope.COMPILE);
        this.dependencyScopes.add(DependencyScope.RUNTIME);
    }

    public void addDependency(Artifact artifact) {
        if (!this.dependencies.contains(artifact)) {
            Artifact[] oldValue = this.dependencies.toArray(new Artifact[this.dependencies.size()]);
            this.dependencies.add(artifact);
            Artifact[] newValue = this.dependencies.toArray(new Artifact[this.dependencies.size()]);
            this.fireEvent(new PropertyChangeEvent(this, "dependency", oldValue, newValue));
        }
    }

    public synchronized void addDependencyScope(DependencyScope scope) {
        if (!this.dependencyScopes.contains((Object)scope)) {
            DependencyScope[] oldValue = this.dependencyScopes.toArray(new DependencyScope[this.dependencyScopes.size()]);
            this.dependencyScopes.add(scope);
            DependencyScope[] newValue = this.dependencyScopes.toArray(new DependencyScope[this.dependencyScopes.size()]);
            this.fireEvent(new PropertyChangeEvent(this, "dependency-scope", oldValue, newValue));
        }
    }

    public void addIgnore(String groupId, String artifactId) {
        Artifact[] oldValue = this.getIgnores();
        List<String> list = this.ignores.get(groupId);
        if (list == null) {
            list = new ArrayList<String>();
            this.ignores.put(groupId, list);
        }
        if (!list.contains(artifactId)) {
            list.add(artifactId);
            Artifact[] newValue = this.getIgnores();
            this.fireEvent(new PropertyChangeEvent(this, "ignores", oldValue, newValue));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void addRepository(Repository repository) {
        if (!this.repositories.contains(repository)) {
            Repository[] oldValue = this.repositories.toArray(new Repository[this.repositories.size()]);
            this.repositories.add(repository);
            Repository[] newValue = this.repositories.toArray(new Repository[this.repositories.size()]);
            this.fireEvent(new PropertyChangeEvent(this, "repositories", oldValue, newValue));
        }
    }

    public Artifact[] getDependencies() {
        return this.dependencies.toArray(new Artifact[this.dependencies.size()]);
    }

    public Artifact getDependency(String groupId, String artifactId) {
        for (Artifact artifact : this.dependencies) {
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId)) continue;
            return artifact;
        }
        return null;
    }

    public String getDestination() {
        return this.destination;
    }

    public Artifact[] getIgnores() {
        ArrayList<Artifact> ignoreList = new ArrayList<Artifact>();
        for (Map.Entry<String, List<String>> entry : this.ignores.entrySet()) {
            String groupId = entry.getKey();
            List<String> list = entry.getValue();
            for (String artifactId : list) {
                ignoreList.add(new Artifact(groupId, artifactId));
            }
        }
        return ignoreList.toArray(new Artifact[ignoreList.size()]);
    }

    public UpdatingLibraryCheckPolicy getPolicy() {
        return this.policy;
    }

    public synchronized Repository[] getRepositories() {
        return Collections.unmodifiableList(this.repositories).toArray(new Repository[this.repositories.size()]);
    }

    public int getRepositoryCount() {
        return this.repositories.size();
    }

    public RepositoryScope getRepositoryScope() {
        return this.scope;
    }

    public synchronized Repository[] getScopedRepositories() {
        ArrayList<Repository> repositoryList = new ArrayList<Repository>();
        for (Repository repository : this.repositories) {
            if (!repository.isAllowed(this.scope)) continue;
            repositoryList.add(repository);
        }
        return repositoryList.toArray(new Repository[repositoryList.size()]);
    }

    public synchronized boolean hasRepository(Repository repo) {
        return this.repositories.contains(repo);
    }

    public synchronized boolean hasRepository(URL url) {
        for (Repository repo : this.repositories) {
            if (!repo.isSameLocation(url)) continue;
            return true;
        }
        return false;
    }

    public boolean isIgnore(String groupId, String artifactId) {
        List<String> list = this.ignores.get(groupId);
        return list != null && list.contains(artifactId);
    }

    public boolean isInclude(DependencyScope scope) {
        return this.dependencyScopes.contains((Object)scope);
    }

    @Override
    public Iterator<Artifact> iterator() {
        return Collections.unmodifiableList(this.dependencies).iterator();
    }

    public void removeDependency(Artifact artifact) {
        if (artifact == null) {
            throw new NullPointerException();
        }
        this.removeDependency(artifact.getGroupId(), artifact.getArtifactId());
    }

    public void removeDependency(String groupId, String artifactId) {
        if (groupId == null || artifactId == null) {
            throw new NullPointerException();
        }
        Artifact[] oldValue = this.dependencies.toArray(new Artifact[this.dependencies.size()]);
        Artifact targetArtifact = null;
        for (Artifact a : this) {
            if (!a.getGroupId().equals(groupId) || !a.getArtifactId().equals(artifactId)) continue;
            targetArtifact = a;
            break;
        }
        if (targetArtifact != null) {
            this.dependencies.remove(targetArtifact);
            Artifact[] newValue = this.dependencies.toArray(new Artifact[this.dependencies.size()]);
            this.fireEvent(new PropertyChangeEvent(this, "dependency", oldValue, newValue));
        }
    }

    public void removeDependencyScope(DependencyScope scope) {
        if (this.dependencyScopes.contains((Object)scope)) {
            DependencyScope[] oldValue = this.dependencyScopes.toArray(new DependencyScope[this.dependencyScopes.size()]);
            this.dependencyScopes.remove((Object)scope);
            DependencyScope[] newValue = this.dependencyScopes.toArray(new DependencyScope[this.dependencyScopes.size()]);
            this.fireEvent(new PropertyChangeEvent(this, "dependency-scope", oldValue, newValue));
        }
    }

    public void removeIgnores(Artifact artifact) {
        if (artifact == null) {
            throw new NullPointerException();
        }
        this.removeIgnores(artifact.getGroupId(), artifact.getArtifactId());
    }

    public void removeIgnores(String groupId, String artifactId) {
        if (groupId == null || artifactId == null) {
            throw new NullPointerException();
        }
        Artifact[] oldValue = this.getIgnores();
        List<String> list = this.ignores.get(groupId);
        if (list != null && list.contains(artifactId)) {
            list.remove(artifactId);
            if (list.size() == 0) {
                this.ignores.remove(groupId);
            }
            Artifact[] newValue = this.getIgnores();
            this.fireEvent(new PropertyChangeEvent(this, "ignores", oldValue, newValue));
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public synchronized boolean removeRepository(Repository repository) {
        Repository[] oldValue = this.getRepositories();
        boolean flag = this.repositories.remove(repository);
        if (flag) {
            Repository[] newValue = this.getRepositories();
            this.fireEvent(new PropertyChangeEvent(this, "repositories", oldValue, newValue));
        }
        return flag;
    }

    public synchronized boolean removeRepository(URL url) {
        Repository[] oldValue = this.getRepositories();
        Repository removeRepository = null;
        for (Repository repo : this.repositories) {
            if (!repo.isSameLocation(url)) continue;
            removeRepository = repo;
            break;
        }
        if (removeRepository != null) {
            this.repositories.remove(removeRepository);
        }
        if (removeRepository != null) {
            Repository[] newValue = this.getRepositories();
            this.fireEvent(new PropertyChangeEvent(this, "repositories", oldValue, newValue));
        }
        return removeRepository != null;
    }

    public void setDestination(String dest) {
        String oldValue = this.getDestination();
        this.destination = dest;
        this.fireEvent(new PropertyChangeEvent(this, "destination", oldValue, dest));
    }

    public void setPolicy(UpdatingLibraryCheckPolicy policy) {
        UpdatingLibraryCheckPolicy oldValue = this.getPolicy();
        this.policy = policy;
        this.fireEvent(new PropertyChangeEvent(this, "policy", (Object)oldValue, (Object)policy));
    }

    public void setRepositoryScope(RepositoryScope scope) {
        RepositoryScope oldValue = this.getRepositoryScope();
        this.scope = scope;
        this.fireEvent(new PropertyChangeEvent(this, "repository-scope", (Object)oldValue, (Object)scope));
    }

    private void fireEvent(PropertyChangeEvent e) {
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            listener.propertyChange(e);
        }
    }
}

