/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.ui.mark;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import jp.sourceforge.talisman.mds.ui.swing.MarkDrawer;

public abstract class AbstractMarkDrawer
implements MarkDrawer {
    private boolean fill;

    public AbstractMarkDrawer() {
        this(false);
    }

    public AbstractMarkDrawer(boolean fill) {
        this.setFilled(fill);
    }

    public boolean isFilled() {
        return this.fill;
    }

    public void setFilled(boolean fill) {
        this.fill = fill;
    }

    public abstract Shape getPlainShape(double var1, double var3);

    public abstract Shape getOveredShape(double var1, double var3);

    public Stroke getPlainStroke() {
        return null;
    }

    public Stroke getOverStroke() {
        return null;
    }

    public void draw(Graphics2D g, double x, double y) {
        Stroke s = this.getPlainStroke();
        if (s != null) {
            g.setStroke(s);
        }
        this.drawImpl(g, this.getPlainShape(x, y));
    }

    public void drawOver(Graphics2D g, double x, double y) {
        Stroke s = this.getOverStroke();
        if (s != null) {
            g.setStroke(s);
        }
        this.drawImpl(g, this.getOveredShape(x, y));
    }

    private void drawImpl(Graphics2D g, Shape s) {
        if (this.isFilled()) {
            g.fill(s);
        } else {
            g.draw(s);
        }
    }
}

