/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.distance;

import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.cluster.Cluster;
import jp.sourceforge.talisman.mds.distance.AbstractClusterDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceAlgorithm;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;

public class WardsClusterDistanceCalculator
extends AbstractClusterDistanceCalculator {
    public WardsClusterDistanceCalculator() {
    }

    public WardsClusterDistanceCalculator(ItemDistanceAlgorithm ida) {
        super(ida);
    }

    public ClusterDistanceAlgorithm getAlgorithm() {
        return ClusterDistanceAlgorithm.WARDS_METHOD;
    }

    public double calculate(Cluster c1, Cluster c2) {
        Item pbar = c1.getMedian();
        Item qbar = c2.getMedian();
        double distance = this.getItemDistanceCalculator().calculate(pbar, qbar);
        return (double)(c1.getSize() * c2.getSize() / (c1.getSize() + c2.getSize())) * distance;
    }

    public double update(Cluster ci, Cluster cj, Cluster ck, double dij, double dik, double djk) {
        int sum = ci.getSize() + cj.getSize() + ck.getSize();
        return dik * (double)(ci.getSize() + ck.getSize()) / (double)sum + djk * (double)(cj.getSize() + ck.getSize()) / (double)sum - dij * (double)ck.getSize() / (double)sum;
    }
}

