package jp.sourceforge.talisman.fmv.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

import jp.sourceforge.talisman.fmv.ui.FmvGraphSetting;
import jp.sourceforge.talisman.i18n.MessageManager;

public class FmvGraphSettingPane extends JPanel{
    private static final long serialVersionUID = -8658533959286291229L;

    private MessageManager mm;

    private JCheckBox showConfigurationButton;
    private JCheckBox showDetails;
    private JCheckBox showGrid;
    private JCheckBox showSubGrid;
    private JCheckBox showGraphLabel;
    private JCheckBox fill;
    private ColorButton stringColor;
    private ColorButton backgroundColor;
    private ColorButton foregroundColor;
    private ColorButton gridColor;
    private ColorButton subGridColor;
    private JTextField history;
    private JTextField step;
    private JTextField interval;
    private JTextField width;
    private JTextField height;

    public FmvGraphSettingPane(MessageManager mm){
        this(mm, new FmvGraphSetting());
    }

    public FmvGraphSettingPane(MessageManager mm, FmvGraphSetting fgs){
        this.mm = mm;
        if(fgs == null){
            fgs = new FmvGraphSetting();
        }

        initLayout(fgs);
    }

    public FmvGraphSetting getGraphSetting(){
        FmvGraphSetting fgs = new FmvGraphSetting();

        fgs.setShowConfigurationButton(showConfigurationButton.isSelected());
        fgs.setShowDetails(showDetails.isSelected());
        fgs.setShowGrid(showGrid.isSelected());
        fgs.setShowSubGrid(showSubGrid.isSelected());
        fgs.setShowGraphLabel(showGraphLabel.isSelected());
        fgs.setFill(fill.isSelected());

        fgs.setStringColor(stringColor.getColor());
        fgs.setBackgroundColor(backgroundColor.getColor());
        fgs.setForegroundColor(foregroundColor.getColor());
        fgs.setGridColor(gridColor.getColor());
        fgs.setSubGridColor(subGridColor.getColor());

        fgs.setHistoryCount(Integer.parseInt(history.getText()));
        fgs.setStepCount(Integer.parseInt(step.getText()));
        fgs.setInterval(Integer.parseInt(interval.getText()));

        fgs.setMinimumSize(new Dimension(Integer.parseInt(width.getText()), Integer.parseInt(height.getText())));

        return fgs;
    }

    private void initLayout(FmvGraphSetting fgs){
        showConfigurationButton = new JCheckBox(mm.getMessages().get("show.configuration"), fgs.isShowConfigurationButton());
        showDetails = new JCheckBox(mm.getMessages().get("show.details"), fgs.isShowDetails());
        showGraphLabel = new JCheckBox(mm.getMessages().get("show.graphlabel"), fgs.isShowGraphLabel());

        showGrid = new JCheckBox(mm.getMessages().get("show.grid"), fgs.isShowGrid());
        showSubGrid = new JCheckBox(mm.getMessages().get("show.subgrid"), fgs.isShowSubGrid());
        fill = new JCheckBox(mm.getMessages().get("fill.graph"), fgs.isFill());

        stringColor = new ColorButton(mm, "stringcolor", fgs.getStringColor());
        backgroundColor = new ColorButton(mm, "background", fgs.getBackgroundColor());
        foregroundColor = new ColorButton(mm, "foreground", fgs.getForegroundColor());
        gridColor = new ColorButton(mm, "gridcolor", fgs.getGridColor());
        subGridColor = new ColorButton(mm, "subgridcolor", fgs.getSubGridColor());

        history = new JTextField(String.valueOf(fgs.getHistoryCount()));
        history.setHorizontalAlignment(JTextField.RIGHT);
        history.setInputVerifier(new IntegerInputVerifier());
        history.setBorder(new TitledBorder(mm.getMessages().get("history.count")));

        step = new JTextField(String.valueOf(fgs.getStepCount()));
        step.setHorizontalAlignment(JTextField.RIGHT);
        step.setInputVerifier(new IntegerInputVerifier());
        step.setBorder(new TitledBorder(mm.getMessages().get("step.count")));

        interval = new JTextField(String.valueOf(fgs.getInterval()));
        interval.setHorizontalAlignment(JTextField.RIGHT);
        interval.setInputVerifier(new IntegerInputVerifier());
        interval.setBorder(new TitledBorder(mm.getMessages().get("interval")));

        width = new JTextField(String.valueOf(fgs.getMinimumSize().width));
        width.setHorizontalAlignment(JTextField.RIGHT);
        width.setInputVerifier(new IntegerInputVerifier());
        width.setBorder(new TitledBorder(mm.getMessages().get("minimumsize.width")));

        height = new JTextField(String.valueOf(fgs.getMinimumSize().height));
        height.setHorizontalAlignment(JTextField.RIGHT);
        height.setInputVerifier(new IntegerInputVerifier());
        height.setBorder(new TitledBorder(mm.getMessages().get("minimumsize.height")));

        setLayout(new GridLayout(6, 3));
        add(showConfigurationButton);
        add(showDetails);
        add(fill);

        add(showGrid);
        add(showSubGrid);
        add(showGraphLabel);

        add(stringColor);
        add(backgroundColor);
        add(foregroundColor);

        add(gridColor);
        add(subGridColor);
        add(new JPanel());

        add(history);
        add(step);
        add(interval);

        add(width);
        add(height);
    }
    
    private static class ColorButton extends JButton{
        private static final long serialVersionUID = -7735369010520675405L;

        private Color color;

        public ColorButton(final MessageManager mm, String label, Color defaultColor){
            super(mm.getMessages().get(label));
            this.color = defaultColor;
            setBackground(color);
            setForeground(getContraColor(color));

            addActionListener(new ActionListener(){
                public void actionPerformed(ActionEvent e){
                    Color newColor = JColorChooser.showDialog(
                        ColorButton.this, mm.getMessages().get("colorselect"), color
                    );
                    if(newColor != null){
                        color = newColor;
                        setBackground(newColor);
                        setForeground(getContraColor(newColor));
                        
                    }
                }
            });
        }

        public Color getColor(){
            return color;
        }

        private Color getContraColor(Color c){
            Color cc = new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
            if(Math.abs(cc.getRed() - c.getRed()) < 10 &&
                    Math.abs(cc.getGreen() - c.getGreen()) < 10 &&
                    Math.abs(cc.getBlue() - c.getBlue()) < 10){
                cc = Color.WHITE;
            }
            return cc;
        }
    }
    private static class IntegerInputVerifier extends InputVerifier{
        @Override
        public boolean verify(JComponent c) {
            boolean verified = false;
            JTextField textField = (JTextField)c;
            try{
                Integer.parseInt(textField.getText());
                verified = true;
            }catch(NumberFormatException e) {
                UIManager.getLookAndFeel().provideErrorFeedback(c);
                //Toolkit.getDefaultToolkit().beep();
            }
            return verified;
        }
    };
}
