/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.fmv;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import jp.sourceforge.talisman.fmv.MemoryStateNotifier;
import jp.sourceforge.talisman.fmv.RunningListener;

public class TimeredMemoryStateNotifier
extends MemoryStateNotifier {
    public static final int DEFAULT_INTERVAL = 300;
    private Timer timer;
    private List<RunningListener> listeners = new ArrayList<RunningListener>();

    public TimeredMemoryStateNotifier() {
        this(300);
    }

    public TimeredMemoryStateNotifier(int initialInterval) {
        this.timer = new Timer(initialInterval, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TimeredMemoryStateNotifier.this.informAll();
            }
        });
        this.timer.setRepeats(true);
    }

    public void addRunningListener(RunningListener listener) {
        this.listeners.add(listener);
    }

    public void removeRunningListener(RunningListener listener) {
        this.listeners.remove(listener);
    }

    public void start() {
        if (!this.isRunning()) {
            this.timer.start();
            for (RunningListener listener : this.listeners) {
                listener.timerStarted();
            }
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.timer.stop();
            for (RunningListener listener : this.listeners) {
                listener.timerStopped();
            }
        }
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    public int getInterval() {
        return this.timer.getDelay();
    }

    public void setInterval(int interval) {
        this.timer.setDelay(interval);
    }
}

