package jp.sourceforge.talisman.pcp.ui.swing;

/*
 * $Id: PcpMainPane.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

import javax.swing.JPanel;

import jp.sourceforge.talisman.pcp.MetricsDomain;
import jp.sourceforge.talisman.pcp.Sample;
import jp.sourceforge.talisman.pcp.Samples;
import jp.sourceforge.talisman.pcp.ui.PcpGraphSetting;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
class PcpMainPane extends JPanel{
    private static final long serialVersionUID = 4743119584650784221L;

    private Samples samples;
    private MetricsDomain[] domains;
    private PcpGraphSetting setting;

    public PcpMainPane(Samples samples, MetricsDomain[] domains, PcpGraphSetting setting){
        this.samples = samples;
        this.domains = domains;
        this.setting = setting;
        setOpaque(false);
    }

    @Override
    public void paintComponent(Graphics graphics){
        Graphics2D g = (Graphics2D)graphics;
        Color initColor = g.getColor();
        Stroke initStroke = g.getStroke();

        Dimension dim = getSize();
        double width = dim.getWidth() / domains.length;
        double height = dim.getHeight() - setting.getSouthOffset();
        double middleWidth = width / 2;
        for(Sample sample: samples){
            Point2D lastPoint = null;
            if(sample.isActive()){
                g.setColor(setting.getActiveLineColor());
                g.setStroke(setting.getActiveLineStroke());
            }
            else{
                g.setColor(setting.getInactiveLineColor());
                g.setStroke(setting.getInactiveLineStroke());
            }
            for(int i = 0; i < domains.length; i++){
                double step = height / (domains[i].getMaximum() - domains[i].getMinimum());
                double offsetX = width * i;
                boolean valueExists = sample.hasValue(domains[i].getMetrics());
                Point2D currentPoint;

                if(valueExists){
                    int v = sample.getValue(domains[i].getMetrics()) - domains[i].getMinimum();
                    currentPoint = new Point2D.Double(offsetX + middleWidth, 10d + height - (v * step));
                    if(setting.isDotPlot()){
                        g.fill(new Ellipse2D.Double(offsetX + middleWidth - 3d, 10d + height - (v * step) - 3d, 6d, 6d));
                    }
                }
                else{
                    double missingValueLine = dim.getHeight() - PcpGraphSetting.MISSING_VALUE_OFFSET;
                    currentPoint = new Point2D.Double(offsetX + middleWidth, missingValueLine);
                }
                if(lastPoint != null){
                    if(!valueExists && !setting.isShowMissingValueArea()){
                        currentPoint = null;
                    }

                    if(currentPoint != null && lastPoint != null){
                        g.draw(new Line2D.Double(lastPoint, currentPoint));
                    }
                }
                lastPoint = currentPoint;
            }
        }

        g.setStroke(initStroke);
        g.setColor(initColor);
        super.paintComponent(g);
    }
}
