package jp.sourceforge.talisman.pcp.ui;

/*
 * $Id: PcpGraphSetting.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class PcpGraphSetting implements Serializable{
    private static final long serialVersionUID = 4134897821731566626L;

    static final int SOUTH_OFFSET = 50;
    public static final int MISSING_VALUE_OFFSET = 20;

    private int transparency;
    private boolean showMissingValueArea;
    private boolean showScales;
    private boolean dotplot;
    private Stroke activeLineStroke;
    private Color activeLineColor;
    private Stroke inactiveLineStroke;
    private Color selectionAreaColor;
    private Color inactiveLineColor;
    private Color borderColor;

    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    /**
     * default constructor.
     */
    public PcpGraphSetting(){
        setTransparency(200);
        setShowMissingValueArea(true);
        setShowScales(true);
        setDotPlot(true);
        setActiveLineStroke(new BasicStroke(2f));
        setActiveLineColor(Color.RED);
        setInactiveLineStroke(new BasicStroke(1f));
        setInactiveLineColor(Color.GRAY);
        setBorderColor(Color.BLACK);
        setSelectedAreaColor(Color.DARK_GRAY);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener){
        listeners.add(listener);
    }

    public Color getActiveLineColor(){
        return activeLineColor;
    }

    public Stroke getActiveLineStroke(){
        return activeLineStroke;
    }

    /**
     * returns PCP border line color.
     */
    public Color getBorderColor(){
        return borderColor;
    }

    public Color getInactiveLineColor(){
        return inactiveLineColor;
    }

    public Stroke getInactiveLineStroke(){
        return inactiveLineStroke;
    }

    public Color getSelectedAreaColor(){
        return selectionAreaColor;
    }

    public int getSouthOffset(){
        int southOffset = MISSING_VALUE_OFFSET;
        if(isShowMissingValueArea()){
            southOffset = SOUTH_OFFSET;
        }
        return southOffset;
    }

    public int getTransparency(){
        return transparency;
    }

    public boolean isDotPlot(){
        return dotplot;
    }

    public boolean isShowMissingValueArea(){
        return showMissingValueArea;
    }

    public boolean isShowScales(){
        return showScales;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener){
        listeners.remove(listener);
    }

    public void setActiveLineColor(Color color){
        if(color == null){
            throw new NullPointerException();
        }
        Color c = activeLineColor;
        activeLineColor = color;
        fireEvent(new PropertyChangeEvent(this, "active_line_color", c, color));
    }

    public void setActiveLineStroke(Stroke stroke){
        if(stroke == null){
            throw new NullPointerException();
        }
        Stroke s = this.activeLineStroke;
        activeLineStroke = stroke;
        fireEvent(new PropertyChangeEvent(this, "active_line_stroke", s, stroke));
    }

    public void setBorderColor(Color color){
        if(color == null){
            throw new NullPointerException();
        }
        Color c = borderColor;
        borderColor = color;
        fireEvent(new PropertyChangeEvent(this, "border_color", c, borderColor));
    }

    public void setDotPlot(boolean dotplot){
        Boolean b = new Boolean(this.dotplot);
        this.dotplot = dotplot;
        fireEvent(new PropertyChangeEvent(this, "dot_plot", b, dotplot));
    }

    public void setInactiveLineColor(Color color){
        if(color == null){
            throw new NullPointerException();
        }
        Color c = inactiveLineColor;
        this.inactiveLineColor = color;
        fireEvent(new PropertyChangeEvent(this, "inactive_line_color", c, color));
    }

    public void setInactiveLineStroke(Stroke stroke){
        if(stroke == null){
            throw new NullPointerException();
        }
        Stroke s = inactiveLineStroke;
        inactiveLineStroke = stroke;
        fireEvent(new PropertyChangeEvent(this, "inactive_line_stroke", s, stroke));
    }

    public void setSelectedAreaColor(Color color){
        if(color == null){
            throw new NullPointerException();
        }
        Color c = selectionAreaColor;
        selectionAreaColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), getTransparency());
        fireEvent(new PropertyChangeEvent(this, "selected_area_color", c, color));
    }

    public void setShowMissingValueArea(boolean showMissingValueArea){
        Boolean b = new Boolean(this.showMissingValueArea);
        this.showMissingValueArea = showMissingValueArea;
        fireEvent(new PropertyChangeEvent(this, "show_missing_value_area", b, showMissingValueArea));
    }

    public void setShowScales(boolean showScales){
        Boolean b = new Boolean(this.showScales);
        this.showScales = showScales;
        fireEvent(new PropertyChangeEvent(this, "show_scales", b, showScales));
    }

    public void setTransparency(int transparency){
        if(transparency < 0 || transparency > 0xff){
            throw new IllegalArgumentException("transparency must be 0-255: " + transparency);
        }
        Integer i = new Integer(this.transparency);
        this.transparency = transparency;
        Color c = selectionAreaColor;
        if(c != null){
            selectionAreaColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), transparency);
        }
        fireEvent(new PropertyChangeEvent(this, "transparency", i, transparency));
    }

    protected void fireEvent(PropertyChangeEvent e){
        for(PropertyChangeListener listener: listeners){
            listener.propertyChange(e);
        }
    }
}
