package jp.sourceforge.talisman.pcp.io;

/*
 * $Id: SamplesParser.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import jp.sourceforge.talisman.csvio.CsvLine;
import jp.sourceforge.talisman.csvio.CsvParser;
import jp.sourceforge.talisman.pcp.Metrics;
import jp.sourceforge.talisman.pcp.Sample;
import jp.sourceforge.talisman.pcp.Samples;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class SamplesParser{
    public Samples parse(InputStream in) throws IOException{
        return parse(new InputStreamReader(in));
    }

    public Samples parse(Reader in) throws IOException{
        return parse(new BufferedReader(in));
    }

    public Samples parse(BufferedReader in) throws IOException{
        CsvParser parser = new CsvParser(in);

        CsvLine header = parser.next();
        Metrics[] metrics = new Metrics[header.size() - 1];
        for(int i = 0; i < metrics.length; i++){
            metrics[i] = new Metrics(header.getValue(i + 1).trim());
        }

        Samples samples = new Samples();
        while(parser.hasNext()){
            CsvLine line = parser.next();
            Sample sample = new Sample(line.getValue(0).trim(), samples);
            for(int i = 0; i < metrics.length; i++){
                sample.setValue(metrics[i], Integer.parseInt(line.getValue(i + 1).trim()));
            }
            samples.addSample(sample);
        }
        return samples;
    }
}