package jp.sourceforge.talisman.pcp;

/*
 * $Id: Samples.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class Samples implements Serializable, Iterable<Sample>{
    private static final long serialVersionUID = 947291361173171290L;

    private List<Sample> samples = new ArrayList<Sample>();
    private Set<Metrics> metricsSet = new LinkedHashSet<Metrics>();
    private int selectedCount;

    /**
     * default constructor.
     */
    public Samples(){
    }

    public void addSample(Sample sample){
        samples.add(sample);
        calculateSelectedCount();
    }

    public void removeSample(Sample sample){
        samples.remove(sample);
        calculateSelectedCount();
    }

    public synchronized Metrics[] getAvailableMetrics(){
        return metricsSet.toArray(new Metrics[metricsSet.size()]);
    }

    public int getSampleCount(){
        return samples.size();
    }

    public int getSelectedSampleCount(){
        return selectedCount;
    }

    public synchronized Sample[] getSamples(){
        return samples.toArray(new Sample[samples.size()]);
    }

    public Iterator<Sample> iterator(){
        return samples.iterator();
    }

    public synchronized Sample[] getSelectedSamples(){
        List<Sample> selectedSample = new ArrayList<Sample>();
        for(Sample sample: this){
            if(sample.isActive()){
                selectedSample.add(sample);
            }
        }
        return selectedSample.toArray(new Sample[selectedSample.size()]);
    }

    public void setSelected(Metrics metrics, int value, Criterion criterion){
        selectedCount = 0;
        for(Sample sample: this){
            int v = sample.getValue(metrics);
            boolean flag = true;
            switch(criterion){
            case EQUALS:
                flag = v == value;
                break;
            case LESS:
                flag = v < value;
                break;
            case LESS_EQUALS:
                flag = v <= value;
                break;
            case MORE:
                flag = v > value;
                break;
            case MORE_EQUALS:
                flag = v >= value;
                break;
            }
            sample.setActive(flag);
            if(flag){
                selectedCount++;
            }
        }
    }

    void addMetrics(Metrics metrics){
        metricsSet.add(metrics);
    }

    private void calculateSelectedCount(){
        selectedCount = 0;
        for(Sample sample: this){
            if(sample.isActive()){
                selectedCount++;
            }
        }
    }
}