package jp.sourceforge.talisman.pcp;

/*
 * $Id: Sample.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class Sample implements Serializable{
    private static final long serialVersionUID = 4929816297324672494L;

    private String id;
    private Map<Metrics, Integer> metricsMap = new LinkedHashMap<Metrics, Integer>();
    private boolean active = true;
    private Samples samples;

    /**
     * basic constructor.
     */
    public Sample(String id){
        if(id == null){
            throw new NullPointerException();
        }
        this.id = id;
    }

    public Sample(String id, Samples samples){
        this(id);
        setSamples(samples);
    }

    public void setSamples(Samples samples){
        if(samples == null){
            throw new NullPointerException();
        }
        for(Metrics metrics: metricsMap.keySet()){
            samples.addMetrics(metrics);
        }
        this.samples = samples;
    }

    public Samples getSamples(){
        return samples;
    }

    public String getId(){
        return id;
    }

    public Iterator<Metrics> metrics(){
        // metrics order is important information.
        // Therefore, LinkedHashSet is constructed.
        Set<Metrics> metricsSet = new LinkedHashSet<Metrics>(metricsMap.keySet());

        return metricsSet.iterator();
    }

    public boolean hasValue(Metrics metrics){
        return metricsMap.get(metrics) != null;
    }

    public void removeValue(Metrics metrics){
        metricsMap.remove(metrics);
    }

    public Integer getValue(Metrics metrics){
        return metricsMap.get(metrics);
    }

    public void setValue(Metrics metrics, int value){
        metricsMap.put(metrics, new Integer(value));
        if(samples != null){
            samples.addMetrics(metrics);
        }
    }

    public boolean isActive(){
        return active;
    }

    public void setActive(boolean selected){
        this.active = selected;
    }

    public boolean equals(Object o){
        boolean flag = false;
        if(o instanceof Sample){
            Sample s = (Sample)o;
            Iterator<Map.Entry<Metrics, Integer>> i1 = metricsMap.entrySet().iterator();
            Iterator<Map.Entry<Metrics, Integer>> i2 = s.metricsMap.entrySet().iterator();

            flag = true;
            while(flag && i1.hasNext() && i2.hasNext()){
                Map.Entry<Metrics, Integer> m1 = i1.next();
                Map.Entry<Metrics, Integer> m2 = i2.next();

                flag = flag && m1.getKey().equals(m2.getKey()) && 
                    m1.getValue().equals(m2.getValue());
            }

            flag = flag && !i1.hasNext() && !i2.hasNext();
        }
        return flag;
    }

    public int hashCode(){
        return toString().hashCode();
    }

    public String toString(){
        StringBuilder sb = new StringBuilder(id);
        sb.append("={ ");
        boolean first = true;
        for(Map.Entry<Metrics, Integer> entry: metricsMap.entrySet()){
            if(!first){
                sb.append(", ");
            }
            sb.append("[").append(entry.getKey().getName());
            sb.append("=").append(entry.getValue()).append("]");
            first = false;
        }
        sb.append(" }");
        return new String(sb);
    }
}