package jp.sourceforge.talisman.pcp;

/*
 * $Id: Metrics.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.io.Serializable;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class Metrics implements Serializable{
    private static final long serialVersionUID = -3929701382434338654L;

    private volatile String name;
    private String description;

    /**
     * self constructor.
     */
    public Metrics(Metrics metrics){
        this(metrics.getName());
        setDescrpition(metrics.getDescription());
    }

    /**
     * basic constructor.
     */
    public Metrics(String name){
        if(name == null){
            throw new NullPointerException();
        }
        this.name = name;
    }

    /**
     * returns the name of this metrics.
     */
    public String getName(){
        return name;
    }

    /**
     * sets a description of this metrics.
     */
    public void setDescrpition(String description){
        this.description = description;
    }

    /**
     * returns the description of this metrics.
     */
    public String getDescription(){
        return description;
    }

    public boolean equals(Object o){
        return o instanceof Metrics && getName().equals(((Metrics)o).getName());
    }

    public int hashCode(){
        return getName().hashCode();
    }
}