package jp.sourceforge.talisman.xmlcli.io;

/*
 * $Id: ArgfReader.java 28 2007-08-21 01:27:00Z tama3 $
 */

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


/**
 * @author Haruaki TAMADA
 * @version $Revision: 28 $ $Date: 2007-08-21 10:27:00 +0900 (Tue, 21 Aug 2007) $
 */
public class ArgfReader extends Reader implements Argf{
    private boolean stdin = false;
    private String[] fileNames;
    private Reader current;
    private String currentFile;
    private List<StreamChangeListener> listeners = new ArrayList<StreamChangeListener>();
    private int index = 0;

    public ArgfReader(String[] fileNames){
        this.fileNames = fileNames;

        if(fileNames == null){
            current = new InputStreamReader(System.in);
            stdin = true;
        }
    }

    public boolean isStdin(){
        return stdin;
    }

    public String getFileName(){
        return currentFile;
    }

    public int read() throws IOException {
        if(current == null){
            boolean flag = next();
            if(!flag) return -1;
        }
        int c = current.read();
        boolean flag = false;
        if(c == -1){
            flag = next();
        }
        if(flag) return read();
        return c;
    }

    public int read(char[] data, int off, int len) throws IOException{
        int size = 0;
        if(current == null){
            return -1;
        }
        for(int i = 0; i < len; i++){
            int d = current.read();
            if(d == -1){
                next();
                break;
            }
            data[i + off] = (char)d;
            size++;
        }

        return size;
    }

    public void addStreamChangeListener(StreamChangeListener listener){
        if(!listeners.contains(listener)){
            listeners.add(listener);
        }
    }

    public void removeStreamChangeListener(StreamChangeListener listener){
        listeners.remove(listener);
    }

    public long skip(long n) throws IOException{
        if(current == null) 
            throw new IOException("Already closed stream");
        return current.skip(n);
    }

    public boolean markSupported(){
        if(current == null) return false;
        return current.markSupported();
    }

    public void mark(int limit) throws IOException{
        if(current != null) current.mark(limit);
    }

    public void reset() throws IOException{
        if(current != null) current.reset();
    }

    public void close() throws IOException{
        fileNames = null;
        if(current != null) current.close();
        current = null;
    }

    @SuppressWarnings("unchecked")
	private void fireEvent(StreamChangeEvent e){
        for(Iterator i = listeners.iterator(); i.hasNext(); ){
            StreamChangeListener listener = (StreamChangeListener)i.next();
            switch(e.getID()){
            case StreamChangeEvent.CHANGE_STREAM:
                listener.changeStream(e);
                break;
            case StreamChangeEvent.FILE_NOT_FOUND:
                listener.fileNotFound(e);
                break;
            }
        }
    }

    private boolean next() throws IOException{
        if(current != null && !isStdin()){
            current.close();
        }
        if(fileNames == null || index >= fileNames.length){
             return false; 
         }
        if(fileNames != null && index >= fileNames.length){
            try{
                FileReader in = new FileReader(fileNames[index]);
                currentFile = fileNames[index];
                this.current = in;
                fireEvent(
                    new StreamChangeEvent(this, StreamChangeEvent.CHANGE_STREAM)
                );
            } catch(FileNotFoundException e){
                fireEvent(
                    new StreamChangeEvent(this, StreamChangeEvent.FILE_NOT_FOUND)
                );
            }
        }
        index++;
        return true;
    }
}
