/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Group</b> is generated from xmlcli-1_1.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="group">
 *       <oneOrMore>
 *         <ref name="option"/>
 *       </oneOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="group"&gt;
 *       &lt;oneOrMore&gt;
 *         &lt;ref name="option"/&gt;
 *       &lt;/oneOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version xmlcli-1_1.rng (Mon Aug 13 18:01:29 JST 2007)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
@SuppressWarnings({ "unchecked", "unused", "serial"})
public class Group implements java.io.Serializable, Cloneable, IAvailableOptionsChoice {
    // List<String>
    private java.util.List option_ = new java.util.ArrayList();

    /**
     * Creates a <code>Group</code>.
     *
     */
    public Group() {
    }

    /**
     * Creates a <code>Group</code>.
     *
     * @param source
     */
    public Group(Group source) {
        setup(source);
    }

    /**
     * Creates a <code>Group</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Group(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Group</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Group(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Group</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Group(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Group</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Group(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Group</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Group(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Group</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Group(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Group</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Group(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Group</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Group(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Group</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Group(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Group</code> by the Group <code>source</code>.
     *
     * @param source
     */
    public void setup(Group source) {
        int size;
        setOption(source.getOption());
    }

    /**
     * Initializes the <code>Group</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Group</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Group</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        try {
            option_ = URelaxer.getElementPropertyAsStringListByStack(stack, "option");
        } catch (IllegalArgumentException e) {} 
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new Group((Group)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("group");
        int size;
        URelaxer.setElementPropertyByStringList(element, "option", this.option_);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Group</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Group</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Group</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Group</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Group</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Group</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>option</b>.
     *
     * @return String[]
     */
    public String[] getOption() {
        String[] array = new String[option_.size()];
        return ((String[])option_.toArray(array));
    }

    /**
     * Sets the String property <b>option</b>.
     *
     * @param option
     */
    public void setOption(String[] option) {
        this.option_.clear();
        for (int i = 0;i < option.length;i++) {
            addOption(option[i]);
        }
    }

    /**
     * Sets the String property <b>option</b>.
     *
     * @param option
     */
    public void setOption(String option) {
        this.option_.clear();
        addOption(option);
    }

    /**
     * Adds the String property <b>option</b>.
     *
     * @param option
     */
    public void addOption(String option) {
        this.option_.add(option);
    }

    /**
     * Adds the String property <b>option</b>.
     *
     * @param option
     */
    public void addOption(String[] option) {
        for (int i = 0;i < option.length;i++) {
            addOption(option[i]);
        }
    }

    /**
     * Gets number of the String property <b>option</b>.
     *
     * @return int
     */
    public int sizeOption() {
        return (option_.size());
    }

    /**
     * Gets the String property <b>option</b> by index.
     *
     * @param index
     * @return String
     */
    public String getOption(int index) {
        return ((String)option_.get(index));
    }

    /**
     * Sets the String property <b>option</b> by index.
     *
     * @param index
     * @param option
     */
    public void setOption(int index, String option) {
        this.option_.set(index, option);
    }

    /**
     * Adds the String property <b>option</b> by index.
     *
     * @param index
     * @param option
     */
    public void addOption(int index, String option) {
        this.option_.add(index, option);
    }

    /**
     * Remove the String property <b>option</b> by index.
     *
     * @param index
     */
    public void removeOption(int index) {
        this.option_.remove(index);
    }

    /**
     * Remove the String property <b>option</b> by object.
     *
     * @param option
     */
    public void removeOption(String option) {
        this.option_.remove(option);
    }

    /**
     * Clear the String property <b>option</b>.
     *
     */
    public void clearOption() {
        this.option_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<group");
        buffer.append(">");
        size = sizeOption();
        for (int i = 0;i < size;i++) {
            buffer.append("<option>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getOption(i))));
            buffer.append("</option>");
        }
        buffer.append("</group>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<group");
        buffer.write(">");
        size = sizeOption();
        for (int i = 0;i < size;i++) {
            buffer.write("<option>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getOption(i))));
            buffer.write("</option>");
        }
        buffer.write("</group>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<group");
        buffer.print(">");
        size = sizeOption();
        for (int i = 0;i < size;i++) {
            buffer.print("<option>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getOption(i))));
            buffer.print("</option>");
        }
        buffer.print("</group>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String array.
     *
     * @return String[]
     */
    public String[] getOptionAsString() {
        int size = sizeOption();
        String[] array = new String[size];
        for (int i = 0;i < size;i++) {
            array[i] = URelaxer.getString(getOption(i));
        }
        return (array);
    }

    /**
     * Gets the property value by index as String.
     *
     * @param index
     * @return String
     */
    public String getOptionAsString(int index) {
        return (URelaxer.getString(getOption(index)));
    }

    /**
     * Sets the property value by String array.
     *
     * @param strings
     */
    public void setOptionByString(String[] strings) {
        if (strings.length > 0) {
            String string = strings[0];
            setOption(string);
            for (int i = 1;i < strings.length;i++) {
                string = strings[i];
                addOption(string);
            }
        }
    }

    /**
     * Sets the property value by String via index.
     *
     * @param index
     * @param value
     */
    public void setOptionByString(int index, String value) {
        setOption(index, value);
    }

    /**
     * Adds the property value by String.
     *
     * @param string
     */
    public void addOptionByString(String string) {
        addOption(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Group</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "group")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "option")) {
            return (false);
        }
        $match$ = true;
        while ((child = target.peekElement()) != null) {
            if (!URelaxer.isTargetElement(child, "option")) {
                break;
            }
            target.popElement();
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Group</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Group</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
