/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Definition</b> is generated from xmlcli-1_1.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="definition">
 *       <attribute name="name">
 *         <data type="ID"/>
 *       </attribute>
 *       <choice>
 *         <ref name="short-option"/>
 *         <ref name="long-option"/>
 *         <ref name="short-long-option"/>
 *       </choice>
 *       <interleave>
 *         <optional>
 *           <element name="description">
 *             <data type="string"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="argument">
 *             <choice>
 *               <value>REQUIRED</value>
 *               <value>OPTIONAL</value>
 *               <value>NONE</value>
 *             </choice>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="argument-name">
 *             <data type="string"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="multiple-args">
 *             <choice>
 *               <data type="integer"/>
 *               <empty/>
 *             </choice>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="value-separator">
 *             <data type="string">
 *               <param name="maxLength">1</param>
 *             </data>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="require">
 *             <empty/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="type">
 *             <data type="string"/>
 *           </element>
 *         </optional>
 *       </interleave>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="definition"&gt;
 *       &lt;attribute name="name"&gt;
 *         &lt;data type="ID"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;choice&gt;
 *         &lt;ref name="short-option"/&gt;
 *         &lt;ref name="long-option"/&gt;
 *         &lt;ref name="short-long-option"/&gt;
 *       &lt;/choice&gt;
 *       &lt;interleave&gt;
 *         &lt;optional&gt;
 *           &lt;element name="description"&gt;
 *             &lt;data type="string"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="argument"&gt;
 *             &lt;choice&gt;
 *               &lt;value&gt;REQUIRED&lt;/value&gt;
 *               &lt;value&gt;OPTIONAL&lt;/value&gt;
 *               &lt;value&gt;NONE&lt;/value&gt;
 *             &lt;/choice&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="argument-name"&gt;
 *             &lt;data type="string"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="multiple-args"&gt;
 *             &lt;choice&gt;
 *               &lt;data type="integer"/&gt;
 *               &lt;empty/&gt;
 *             &lt;/choice&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="value-separator"&gt;
 *             &lt;data type="string"&gt;
 *               &lt;param name="maxLength"&gt;1&lt;/param&gt;
 *             &lt;/data&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="require"&gt;
 *             &lt;empty/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="type"&gt;
 *             &lt;data type="string"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *       &lt;/interleave&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version xmlcli-1_1.rng (Mon Aug 13 18:01:29 JST 2007)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
@SuppressWarnings({ "unchecked", "unused", "serial"})
public class Definition implements java.io.Serializable, Cloneable {
    public static final String ARGUMENT_REQUIRED = "REQUIRED";
    public static final String ARGUMENT_OPTIONAL = "OPTIONAL";
    public static final String ARGUMENT_NONE = "NONE";

    private String name_;
    private IDefinitionChoice content_;
    private String description_;
    private String argument_;
    private String argumentName_;
    private String multipleArgs_;
    private String valueSeparator_;
    private String require_;
    private String type_;

    /**
     * Creates a <code>Definition</code>.
     *
     */
    public Definition() {
        name_ = "";
    }

    /**
     * Creates a <code>Definition</code>.
     *
     * @param source
     */
    public Definition(Definition source) {
        setup(source);
    }

    /**
     * Creates a <code>Definition</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Definition(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Definition</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Definition(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Definition</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Definition(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Definition</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Definition(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Definition</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Definition(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Definition</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Definition(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Definition</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Definition(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Definition</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Definition(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Definition</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Definition(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Definition</code> by the Definition <code>source</code>.
     *
     * @param source
     */
    public void setup(Definition source) {
        int size;
        name_ = source.name_;
        if (source.content_ != null) {
            setContent((IDefinitionChoice)source.getContent().clone());
        }
        description_ = source.description_;
        argument_ = source.argument_;
        argumentName_ = source.argumentName_;
        multipleArgs_ = source.multipleArgs_;
        valueSeparator_ = source.valueSeparator_;
        require_ = source.require_;
        type_ = source.type_;
    }

    /**
     * Initializes the <code>Definition</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Definition</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Definition</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        RInterleave interleave;
        try {
            name_ = URelaxer.getAttributePropertyAsString(element, "name");
        } catch (IllegalArgumentException e) {} 
        if (ShortLongOption.isMatch(stack)) {
            setContent(new ShortLongOption(stack));
        } else if (ShortOption.isMatch(stack)) {
            setContent(new ShortOption(stack));
        } else if (LongOption.isMatch(stack)) {
            setContent(new LongOption(stack));
        } else {
        }
        interleave = new RInterleave(stack);
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("argument", "?");
        interleave.addElementSlot("argument-name", "?");
        interleave.addElementSlot("multiple-args", "?");
        interleave.addElementSlot("value-separator", "?");
        interleave.addElementSlot("require", "?");
        interleave.addElementSlot("type", "?");
        if (interleave.isMatch()) {
            try {
            description_ = interleave.getElementPropertyAsString("description");
        } catch (IllegalArgumentException e) {} 
            try {
            argument_ = interleave.getElementPropertyAsString("argument");
        } catch (IllegalArgumentException e) {} 
            try {
            argumentName_ = interleave.getElementPropertyAsString("argument-name");
        } catch (IllegalArgumentException e) {} 
            try {
            multipleArgs_ = interleave.getElementPropertyAsString("multiple-args");
        } catch (IllegalArgumentException e) {} 
            try {
            valueSeparator_ = interleave.getElementPropertyAsString("value-separator");
        } catch (IllegalArgumentException e) {} 
            try {
            require_ = interleave.getElementPropertyAsString("require");
        } catch (IllegalArgumentException e) {} 
            try {
            type_ = interleave.getElementPropertyAsString("type");
        } catch (IllegalArgumentException e) {} 
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new Definition((Definition)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("definition");
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.content_ != null) {
            this.content_.makeElement(element);
        }
        if (this.description_ != null) {
            URelaxer.setElementPropertyByString(element, "description", this.description_);
        }
        if (this.argument_ != null) {
            URelaxer.setElementPropertyByString(element, "argument", this.argument_);
        }
        if (this.argumentName_ != null) {
            URelaxer.setElementPropertyByString(element, "argument-name", this.argumentName_);
        }
        if (this.multipleArgs_ != null) {
            URelaxer.setElementPropertyByString(element, "multiple-args", this.multipleArgs_);
        }
        if (this.valueSeparator_ != null) {
            URelaxer.setElementPropertyByString(element, "value-separator", this.valueSeparator_);
        }
        if (this.require_ != null) {
            URelaxer.setElementPropertyByString(element, "require", this.require_);
        }
        if (this.type_ != null) {
            URelaxer.setElementPropertyByString(element, "type", this.type_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Definition</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Definition</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Definition</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Definition</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Definition</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Definition</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the IDefinitionChoice property <b>content</b>.
     *
     * @return IDefinitionChoice
     */
    public IDefinitionChoice getContent() {
        return (content_);
    }

    /**
     * Sets the IDefinitionChoice property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IDefinitionChoice content) {
        this.content_ = content;
    }

    /**
     * Gets the String property <b>description</b>.
     *
     * @return String
     */
    public String getDescription() {
        return (description_);
    }

    /**
     * Sets the String property <b>description</b>.
     *
     * @param description
     */
    public void setDescription(String description) {
        this.description_ = description;
    }

    /**
     * Gets the String property <b>argument</b>.
     *
     * @return String
     */
    public String getArgument() {
        return (argument_);
    }

    /**
     * Sets the String property <b>argument</b>.
     *
     * @param argument
     */
    public void setArgument(String argument) {
        this.argument_ = argument;
    }

    /**
     * Gets the String property <b>argumentName</b>.
     *
     * @return String
     */
    public String getArgumentName() {
        return (argumentName_);
    }

    /**
     * Sets the String property <b>argumentName</b>.
     *
     * @param argumentName
     */
    public void setArgumentName(String argumentName) {
        this.argumentName_ = argumentName;
    }

    /**
     * Gets the String property <b>multipleArgs</b>.
     *
     * @return String
     */
    public String getMultipleArgs() {
        return (multipleArgs_);
    }

    /**
     * Sets the String property <b>multipleArgs</b>.
     *
     * @param multipleArgs
     */
    public void setMultipleArgs(String multipleArgs) {
        this.multipleArgs_ = multipleArgs;
    }

    /**
     * Gets the String property <b>valueSeparator</b>.
     *
     * @return String
     */
    public String getValueSeparator() {
        return (valueSeparator_);
    }

    /**
     * Sets the String property <b>valueSeparator</b>.
     *
     * @param valueSeparator
     */
    public void setValueSeparator(String valueSeparator) {
        this.valueSeparator_ = valueSeparator;
    }

    /**
     * Gets the String property <b>require</b>.
     *
     * @return String
     */
    public String getRequire() {
        return (require_);
    }

    /**
     * Sets the String property <b>require</b>.
     *
     * @param require
     */
    public void setRequire(String require) {
        this.require_ = require;
    }

    /**
     * Gets the String property <b>type</b>.
     *
     * @return String
     */
    public String getType() {
        return (type_);
    }

    /**
     * Sets the String property <b>type</b>.
     *
     * @param type
     */
    public void setType(String type) {
        this.type_ = type;
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<definition");
        if (name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.append("\"");
        }
        if (content_ != null) {
            content_.makeTextAttribute(buffer);
        }
        buffer.append(">");
        if (content_ != null) {
            content_.makeTextElement(buffer);
        }
        if (description_ != null) {
            buffer.append("<description>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getDescription())));
            buffer.append("</description>");
        }
        if (argument_ != null) {
            buffer.append("<argument>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getArgument())));
            buffer.append("</argument>");
        }
        if (argumentName_ != null) {
            buffer.append("<argument-name>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getArgumentName())));
            buffer.append("</argument-name>");
        }
        if (multipleArgs_ != null) {
            buffer.append("<multiple-args>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getMultipleArgs())));
            buffer.append("</multiple-args>");
        }
        if (valueSeparator_ != null) {
            buffer.append("<value-separator>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getValueSeparator())));
            buffer.append("</value-separator>");
        }
        if (require_ != null) {
            buffer.append("<require>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getRequire())));
            buffer.append("</require>");
        }
        if (type_ != null) {
            buffer.append("<type>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getType())));
            buffer.append("</type>");
        }
        buffer.append("</definition>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<definition");
        if (name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.write("\"");
        }
        if (content_ != null) {
            content_.makeTextAttribute(buffer);
        }
        buffer.write(">");
        if (content_ != null) {
            content_.makeTextElement(buffer);
        }
        if (description_ != null) {
            buffer.write("<description>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getDescription())));
            buffer.write("</description>");
        }
        if (argument_ != null) {
            buffer.write("<argument>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getArgument())));
            buffer.write("</argument>");
        }
        if (argumentName_ != null) {
            buffer.write("<argument-name>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getArgumentName())));
            buffer.write("</argument-name>");
        }
        if (multipleArgs_ != null) {
            buffer.write("<multiple-args>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getMultipleArgs())));
            buffer.write("</multiple-args>");
        }
        if (valueSeparator_ != null) {
            buffer.write("<value-separator>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getValueSeparator())));
            buffer.write("</value-separator>");
        }
        if (require_ != null) {
            buffer.write("<require>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getRequire())));
            buffer.write("</require>");
        }
        if (type_ != null) {
            buffer.write("<type>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getType())));
            buffer.write("</type>");
        }
        buffer.write("</definition>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<definition");
        if (name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.print("\"");
        }
        if (content_ != null) {
            content_.makeTextAttribute(buffer);
        }
        buffer.print(">");
        if (content_ != null) {
            content_.makeTextElement(buffer);
        }
        if (description_ != null) {
            buffer.print("<description>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getDescription())));
            buffer.print("</description>");
        }
        if (argument_ != null) {
            buffer.print("<argument>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getArgument())));
            buffer.print("</argument>");
        }
        if (argumentName_ != null) {
            buffer.print("<argument-name>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getArgumentName())));
            buffer.print("</argument-name>");
        }
        if (multipleArgs_ != null) {
            buffer.print("<multiple-args>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getMultipleArgs())));
            buffer.print("</multiple-args>");
        }
        if (valueSeparator_ != null) {
            buffer.print("<value-separator>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getValueSeparator())));
            buffer.print("</value-separator>");
        }
        if (require_ != null) {
            buffer.print("<require>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getRequire())));
            buffer.print("</require>");
        }
        if (type_ != null) {
            buffer.print("<type>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getType())));
            buffer.print("</type>");
        }
        buffer.print("</definition>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDescriptionAsString() {
        return (URelaxer.getString(getDescription()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getArgumentAsString() {
        return (URelaxer.getString(getArgument()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getArgumentNameAsString() {
        return (URelaxer.getString(getArgumentName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMultipleArgsAsString() {
        return (URelaxer.getString(getMultipleArgs()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getValueSeparatorAsString() {
        return (URelaxer.getString(getValueSeparator()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getRequireAsString() {
        return (URelaxer.getString(getRequire()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDescriptionByString(String string) {
        setDescription(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setArgumentByString(String string) {
        setArgument(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setArgumentNameByString(String string) {
        setArgumentName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMultipleArgsByString(String string) {
        setMultipleArgs(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setValueSeparatorByString(String string) {
        setValueSeparator(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setRequireByString(String string) {
        setRequire(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Definition</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "definition")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        RInterleave interleave;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return (false);
        }
        $match$ = true;
        if (ShortLongOption.isMatchHungry(target)) {
            $match$ = true;
        } else if (ShortOption.isMatchHungry(target)) {
            $match$ = true;
        } else if (LongOption.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return (false);
        }
        interleave = new RInterleave(target);
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("argument", "?");
        interleave.addElementSlot("argument-name", "?");
        interleave.addElementSlot("multiple-args", "?");
        interleave.addElementSlot("value-separator", "?");
        interleave.addElementSlot("require", "?");
        interleave.addElementSlot("type", "?");
        if (interleave.isMatch()) {
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Definition</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Definition</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
