package jp.sourceforge.talisman.xmlcli.builder;

/*
 * $Id: AbstractOptionsBuilder.java 28 2007-08-21 01:27:00Z tama3 $
 */

import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.cli.Options;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

import jp.sourceforge.talisman.xmlcli.OptionsBuilder;

/**
 * Abstract class of {@link OptionsBuilder <code>OptionsBuilder</code>}.
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 28 $ $Date: 2007-08-21 10:27:00 +0900 (Tue, 21 Aug 2007) $
 */
public abstract class AbstractOptionsBuilder implements OptionsBuilder{
    private InputStream in;

    public AbstractOptionsBuilder(InputStream in){
        this.in = in;
    }

    public InputStream getStream(){
        return in;
    }

    public abstract String getDefinitionName();

    public abstract Options buildOptions() throws IOException, SAXException, DOMException;
}
